/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.core.ModServices;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.mixin.accessor.AnvilMenuAccessor;
import fuzs.easyanvils.mixin.accessor.ItemCombinerMenuAccessor;
import fuzs.easyanvils.mixin.accessor.SlotAccessor;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.world.inventory.AnvilMenuState;
import fuzs.easyanvils.world.inventory.BuiltInAnvilMenu;
import fuzs.easyanvils.world.inventory.VanillaAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ModAnvilMenu
extends AnvilMenu
implements ContainerListener {
    private final AnvilMenuState builtInAnvilState;
    private final AnvilMenuState vanillaAnvilState;

    public ModAnvilMenu(int id, Inventory inventory) {
        super(id, inventory);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory);
    }

    public ModAnvilMenu(int id, Inventory inventory, Container inputSlots, ContainerLevelAccess containerLevelAccess) {
        super(id, inventory, containerLevelAccess);
        this.updateInputSlots(inputSlots);
        this.m_38893_(this);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory);
    }

    private void updateInputSlots(Container inputSlots) {
        ((ItemCombinerMenuAccessor)((Object)this)).setInputSlots(inputSlots);
        ((SlotAccessor)this.f_38839_.get(0)).setContainer(inputSlots);
        ((SlotAccessor)this.f_38839_.get(1)).setContainer(inputSlots);
    }

    protected void m_142365_(Player player, ItemStack stack) {
        super.m_142365_(player, stack);
        this.f_39770_.m_39292_((level, pos) -> {
            BlockEntity patt2870$temp = level.m_7702_(pos);
            if (patt2870$temp instanceof AnvilBlockEntity) {
                AnvilBlockEntity blockEntity = (AnvilBlockEntity)patt2870$temp;
                this.updateInputSlots(blockEntity);
            }
        });
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModRegistry.ANVIL_MENU_TYPE.get();
    }

    public boolean m_6875_(Player player) {
        return this.f_39769_.m_6542_(player);
    }

    protected boolean m_6560_(Player player, boolean hasStack) {
        return (player.m_150110_().f_35937_ || player.f_36078_ >= this.m_39028_()) && this.m_39028_() >= 0;
    }

    public void m_6640_() {
        if (this.builtInAnvilState == null || this.vanillaAnvilState == null) {
            return;
        }
        ItemStack left = this.f_39769_.m_8020_(0);
        ItemStack right = this.f_39769_.m_8020_(1);
        String itemName = ((AnvilMenuAccessor)((Object)this)).easyanvils$getItemName();
        this.builtInAnvilState.init(left, right, itemName);
        this.vanillaAnvilState.init(left, right, itemName);
        this.builtInAnvilState.fillResultSlots();
        this.vanillaAnvilState.fillResultSlots();
        if (!AnvilMenuState.equals(this.builtInAnvilState, this.vanillaAnvilState)) {
            super.m_6640_();
        } else {
            this.createResult(left, right, itemName);
        }
    }

    private void createResult(ItemStack left, ItemStack right, String itemName) {
        this.setCost(1);
        if (left.m_41619_()) {
            this.f_39768_.m_6836_(0, ItemStack.f_41583_);
            this.setCost(0);
        } else {
            int allOperationsCost;
            ItemStack output = left.m_41777_();
            Map map = EnchantmentHelper.m_44831_((ItemStack)output);
            int baseRepairCost = left.m_41610_() + (right.m_41619_() ? 0 : right.m_41610_());
            baseRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.operator.applyAsInt(baseRepairCost);
            this.setRepairItemCountCost(0);
            boolean isBook = false;
            int repairOperationCost = 0;
            int enchantOperationCost = 0;
            int renameOperationCost = 0;
            int maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).tooExpensiveLimit;
            if (!right.m_41619_()) {
                boolean bl = isBook = right.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)right).isEmpty();
                if (output.m_41763_() && output.m_41720_().m_6832_(left, right)) {
                    int repairMaterials;
                    int l2 = Math.min(output.m_41773_(), output.m_41776_() / 4);
                    if (l2 <= 0) {
                        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                        this.setCost(0);
                        return;
                    }
                    for (repairMaterials = 0; l2 > 0 && repairMaterials < right.m_41613_(); ++repairMaterials) {
                        int j3 = output.m_41773_() - l2;
                        output.m_41721_(j3);
                        repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialUnitCost;
                        l2 = Math.min(output.m_41773_(), output.m_41776_() / 4);
                    }
                    this.setRepairItemCountCost(repairMaterials);
                } else {
                    if (!(isBook || output.m_150930_(right.m_41720_()) && output.m_41763_())) {
                        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                        this.setCost(0);
                        return;
                    }
                    if (output.m_41763_() && !isBook) {
                        int l = left.m_41776_() - left.m_41773_();
                        int i1 = right.m_41776_() - right.m_41773_();
                        int j1 = i1 + output.m_41776_() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = output.m_41776_() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < output.m_41773_()) {
                            output.m_41721_(l1);
                            repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemCost;
                        }
                    }
                    Map map1 = EnchantmentHelper.m_44831_((ItemStack)right);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Enchantment enchantment1 : map1.keySet()) {
                        Integer oldEnchantmentLevel;
                        int rarityCostMultiplier;
                        int enchantmentLevel;
                        if (enchantment1 == null) continue;
                        int otherEnchantmentLevel = map.getOrDefault(enchantment1, 0);
                        enchantmentLevel = otherEnchantmentLevel == (enchantmentLevel = ((Integer)map1.get(enchantment1)).intValue()) ? enchantmentLevel + 1 : Math.max(enchantmentLevel, otherEnchantmentLevel);
                        boolean compatibleWithItem = enchantment1.m_6081_(left);
                        if (this.f_39771_.m_150110_().f_35937_ || left.m_150930_(Items.f_42690_)) {
                            compatibleWithItem = true;
                        }
                        for (Enchantment enchantment : map.keySet()) {
                            if (enchantment == enchantment1 || enchantment1.m_44695_(enchantment)) continue;
                            compatibleWithItem = false;
                            ++enchantOperationCost;
                        }
                        if (!compatibleWithItem) {
                            if (repairOperationCost > 0) continue;
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (enchantmentLevel > enchantment1.m_6586_()) {
                            enchantmentLevel = enchantment1.m_6586_();
                        }
                        int maxLevel = Math.max(map.getOrDefault(enchantment1, 0), (Integer)map1.get(enchantment1));
                        if ((maxLevel = Math.max(maxLevel, enchantmentLevel)) != enchantmentLevel) {
                            enchantmentLevel = maxLevel;
                        }
                        switch (enchantment1.m_44699_()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case COMMON: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.commonEnchantmentMultiplier;
                                break;
                            }
                            case UNCOMMON: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.uncommonEnchantmentMultiplier;
                                break;
                            }
                            case RARE: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.rareEnchantmentMultiplier;
                                break;
                            }
                            case VERY_RARE: {
                                int n = rarityCostMultiplier = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.veryRareEnchantmentMultiplier;
                            }
                        }
                        if (isBook && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.halvedBookCosts) {
                            rarityCostMultiplier = Math.max(1, rarityCostMultiplier / 2);
                        }
                        if ((oldEnchantmentLevel = map.put(enchantment1, enchantmentLevel)) == null || oldEnchantmentLevel != enchantmentLevel) {
                            enchantOperationCost += rarityCostMultiplier * enchantmentLevel;
                        }
                        if (left.m_41613_() <= 1 || this.f_39771_.m_150110_().f_35937_) continue;
                        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                        this.setCost(-1);
                        return;
                    }
                    if (flag3 && !flag2) {
                        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
                        this.setCost(0);
                        return;
                    }
                }
            }
            boolean hasRenamedItem = false;
            if (ComponentDecomposer.getStringLength(itemName) == 0) {
                if (left.m_41788_()) {
                    renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).freeRenames.filter.test(left) ? 0 : 1;
                    hasRenamedItem = true;
                    output.m_41787_();
                }
            } else if (!itemName.equals(ComponentDecomposer.toFormattedString(left.m_41786_()))) {
                renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).freeRenames.filter.test(left) ? 0 : 1;
                hasRenamedItem = true;
                output.m_41714_(ComponentDecomposer.toFormattedComponent(itemName));
            }
            if (isBook && !ModServices.ABSTRACTIONS.isBookEnchantable(output, right)) {
                output = ItemStack.f_41583_;
            }
            if ((allOperationsCost = enchantOperationCost + repairOperationCost + renameOperationCost) == 0) {
                this.setCost(0);
                if (!hasRenamedItem) {
                    output = ItemStack.f_41583_;
                }
            } else if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).renameAndRepairCosts == ServerConfig.RenameAndRepairCost.FIXED) {
                this.setCost(allOperationsCost);
            } else {
                this.setCost(baseRepairCost + allOperationsCost);
            }
            if (enchantOperationCost == 0 && this.m_39028_() >= maxAnvilRepairCost && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).renameAndRepairCosts == ServerConfig.RenameAndRepairCost.LIMITED) {
                if (maxAnvilRepairCost == -1) {
                    this.setCost(39);
                } else {
                    this.setCost(maxAnvilRepairCost - 1);
                }
            }
            if (this.m_39028_() >= maxAnvilRepairCost && maxAnvilRepairCost != -1 && !this.f_39771_.m_150110_().f_35937_) {
                output = ItemStack.f_41583_;
            }
            if (!output.m_41619_()) {
                int outputRepairCost = output.m_41610_();
                if (!right.m_41619_() && outputRepairCost < right.m_41610_()) {
                    outputRepairCost = right.m_41610_();
                }
                if (!(allOperationsCost <= 0 || enchantOperationCost <= 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).penaltyFreeRenamesAndRepairs)) {
                    outputRepairCost = AnvilMenu.m_39025_((int)outputRepairCost);
                }
                if (outputRepairCost > 0) {
                    output.m_41742_(outputRepairCost);
                }
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)output);
            }
            this.f_39768_.m_6836_(0, output);
            this.m_38946_();
        }
    }

    public void setCost(int cost) {
        this.m_7511_(0, cost);
    }

    public void setRepairItemCountCost(int repairItemCountCost) {
        ((AnvilMenuAccessor)((Object)this)).easyanvils$setRepairItemCountCost(repairItemCountCost);
    }

    public void m_6877_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemstack = this.m_142621_();
            if (!itemstack.m_41619_()) {
                if (player.m_6084_() && !serverPlayer.m_9232_()) {
                    player.m_150109_().m_150079_(itemstack);
                } else {
                    player.m_36176_(itemstack, false);
                }
                this.m_142503_(ItemStack.f_41583_);
            }
        }
        this.m_38943_(this);
    }

    public void m_39020_(String newName) {
        ((AnvilMenuAccessor)((Object)this)).easyanvils$setItemName(newName);
        if (this.m_38853_(2).m_6657_()) {
            ItemStack itemStack = this.m_38853_(2).m_7993_();
            Component component = ComponentDecomposer.toFormattedComponent(newName);
            if (component.getString().isEmpty()) {
                itemStack.m_41787_();
            } else {
                itemStack.m_41714_(component);
            }
        }
        this.m_6640_();
    }

    public void m_7934_(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
        if (containerToSend == this && dataSlotIndex >= 0 && dataSlotIndex < 2) {
            this.m_6199_(this.f_39769_);
        }
    }

    public void m_142153_(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
    }

    public static int repairCostToRepairs(int repairCost) {
        ++repairCost;
        int repairs = 0;
        while (repairCost >= 2) {
            repairCost /= 2;
            ++repairs;
        }
        return repairs;
    }
}

