/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy;

import com.aizistral.enigmaticlegacy.api.capabilities.PlayerPlaytimeCounter;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticArmorMaterials;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.brewing.SpecialBrewingRecipe;
import com.aizistral.enigmaticlegacy.brewing.ValidationBrewingRecipe;
import com.aizistral.enigmaticlegacy.config.EtheriumConfigHandler;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.crafting.HiddenRecipe;
import com.aizistral.enigmaticlegacy.gui.containers.LoreInscriberScreen;
import com.aizistral.enigmaticlegacy.handlers.DevotedBelieversHandler;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticKeybindHandler;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticUpdateHandler;
import com.aizistral.enigmaticlegacy.handlers.SoulArchive;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.items.GolemHeart;
import com.aizistral.enigmaticlegacy.objects.LoggerWrapper;
import com.aizistral.enigmaticlegacy.objects.RegisteredMeleeAttack;
import com.aizistral.enigmaticlegacy.packets.clients.PacketCosmicRevive;
import com.aizistral.enigmaticlegacy.packets.clients.PacketFlameParticles;
import com.aizistral.enigmaticlegacy.packets.clients.PacketForceArrowRotations;
import com.aizistral.enigmaticlegacy.packets.clients.PacketGenericParticleEffect;
import com.aizistral.enigmaticlegacy.packets.clients.PacketHandleItemPickup;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPatchouliForce;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPermadeath;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPlayQuote;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPlayerRotations;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPlayerSetlook;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.aizistral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.aizistral.enigmaticlegacy.packets.clients.PacketSetEntryState;
import com.aizistral.enigmaticlegacy.packets.clients.PacketSlotUnlocked;
import com.aizistral.enigmaticlegacy.packets.clients.PacketSyncPlayTime;
import com.aizistral.enigmaticlegacy.packets.clients.PacketSyncTransientData;
import com.aizistral.enigmaticlegacy.packets.clients.PacketUpdateCompass;
import com.aizistral.enigmaticlegacy.packets.clients.PacketUpdateExperience;
import com.aizistral.enigmaticlegacy.packets.clients.PacketUpdateNotification;
import com.aizistral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import com.aizistral.enigmaticlegacy.packets.server.PacketAnvilField;
import com.aizistral.enigmaticlegacy.packets.server.PacketConfirmTeleportation;
import com.aizistral.enigmaticlegacy.packets.server.PacketEnchantingGUI;
import com.aizistral.enigmaticlegacy.packets.server.PacketEnderRingKey;
import com.aizistral.enigmaticlegacy.packets.server.PacketInkwellField;
import com.aizistral.enigmaticlegacy.packets.server.PacketSpellstoneKey;
import com.aizistral.enigmaticlegacy.packets.server.PacketToggleMagnetEffects;
import com.aizistral.enigmaticlegacy.packets.server.PacketUpdateElytraBoosting;
import com.aizistral.enigmaticlegacy.packets.server.PacketXPScrollKey;
import com.aizistral.enigmaticlegacy.proxy.ClientProxy;
import com.aizistral.enigmaticlegacy.proxy.CommonProxy;
import com.aizistral.enigmaticlegacy.registries.EnigmaticBlocks;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEffects;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEnchantments;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEntities;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticLootFunctions;
import com.aizistral.enigmaticlegacy.registries.EnigmaticLootModifiers;
import com.aizistral.enigmaticlegacy.registries.EnigmaticMenus;
import com.aizistral.enigmaticlegacy.registries.EnigmaticPotions;
import com.aizistral.enigmaticlegacy.registries.EnigmaticRecipes;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTiles;
import com.aizistral.enigmaticlegacy.triggers.BeheadingTrigger;
import com.aizistral.enigmaticlegacy.triggers.CursedInventoryChangedTrigger;
import com.aizistral.enigmaticlegacy.triggers.CursedRingEquippedTrigger;
import com.aizistral.enigmaticlegacy.triggers.ForbiddenFruitTrigger;
import com.aizistral.enigmaticlegacy.triggers.RevelationGainTrigger;
import com.aizistral.enigmaticlegacy.triggers.RevelationTomeBurntTrigger;
import com.aizistral.enigmaticlegacy.triggers.UseUnholyGrailTrigger;
import com.aizistral.etherium.core.EtheriumEventHandler;
import com.aizistral.omniconfig.packets.PacketSyncOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="enigmaticlegacy")
public class EnigmaticLegacy {
    public static final String MODID = "enigmaticlegacy";
    public static final String VERSION = "2.26.5";
    public static final String RELEASE_TYPE = "Release";
    public static final String NAME = "Enigmatic Legacy";
    private static final String PTC_VERSION = "1";
    public static final int HOW_COOL_I_AM = Integer.MAX_VALUE;
    public static final LoggerWrapper LOGGER = new LoggerWrapper("Enigmatic Legacy");
    public static final UUID SOUL_OF_THE_ARCHITECT = UUID.fromString("bfa45411-874a-4ee0-b3bd-00c716059d95");
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static EnigmaticLegacy enigmaticLegacy;
    public static SimpleChannel packetInstance;
    public static EnigmaticEventHandler enigmaticHandler;
    public static EnigmaticKeybindHandler keybindHandler;
    public static List<String> damageTypesFire;
    public static EtheriumConfigHandler etheriumConfig;
    public static final CreativeModeTab MAIN_TAB;
    public static final CreativeModeTab POTION_TAB;
    public static final Rarity LEGENDARY;

    public EnigmaticLegacy() {
        LOGGER.info("Constructing mod instance...");
        enigmaticLegacy = this;
        OmniconfigHandler.initialize();
        etheriumConfig = new EtheriumConfigHandler();
        EnigmaticMaterials.setEtheriumConfig(etheriumConfig);
        EnigmaticArmorMaterials.setEtheriumConfig(etheriumConfig);
        enigmaticHandler = new EnigmaticEventHandler();
        keybindHandler = new EnigmaticKeybindHandler();
        this.loadClass(EnigmaticItems.class);
        this.loadClass(EnigmaticTiles.class);
        this.loadClass(EnigmaticMenus.class);
        this.loadClass(EnigmaticBlocks.class);
        this.loadClass(EnigmaticSounds.class);
        this.loadClass(EnigmaticEffects.class);
        this.loadClass(EnigmaticRecipes.class);
        this.loadClass(EnigmaticEntities.class);
        this.loadClass(EnigmaticEnchantments.class);
        this.loadClass(EnigmaticLootModifiers.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::intermodStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)enigmaticHandler);
        MinecraftForge.EVENT_BUS.register((Object)keybindHandler);
        MinecraftForge.EVENT_BUS.register((Object)new EnigmaticUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EtheriumEventHandler(etheriumConfig, EnigmaticItems.ETHERIUM_ORE));
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        LOGGER.info("Mod instance constructed successfully.");
    }

    private void loadClass(Class<?> theClass) {
        try {
            Class.forName(theClass.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("This can't be hapenning.");
        }
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Initializing load completion phase...");
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.ANGEL_BLESSING);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.GOLEM_HEART);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.OCEAN_STONE);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.BLAZING_CORE);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.EYE_OF_NEBULA);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.VOID_PEARL);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.THE_CUBE);
        EnigmaticItems.SPELLSTONES.add(EnigmaticItems.ENIGMATIC_ITEM);
        LOGGER.info("Registering brewing recipes...");
        if (OmniconfigHandler.isItemEnabled((Object)EnigmaticItems.RECALL_POTION)) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new SpecialBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.f_42589_, Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42545_}), new ItemStack((ItemLike)EnigmaticItems.RECALL_POTION), new ResourceLocation(MODID, "recall_potion")));
        }
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.TWISTED_POTION)) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new SpecialBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.RECALL_POTION}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.TWISTED_HEART}), new ItemStack((ItemLike)EnigmaticItems.TWISTED_POTION), new ResourceLocation(MODID, "twisted_potion")));
        }
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.COMMON_POTION)) {
            PotionHelper.registerCommonPotions();
        }
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.ULTIMATE_POTION)) {
            PotionHelper.registerBasicUltimatePotions();
            PotionHelper.registerSplashUltimatePotions();
            PotionHelper.registerLingeringUltimatePotions();
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ValidationBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.RECALL_POTION, EnigmaticItems.TWISTED_POTION, EnigmaticItems.ULTIMATE_POTION_LINGERING, EnigmaticItems.COMMON_POTION_LINGERING}), null));
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.THE_CUBE)) {
            HiddenRecipe.addRecipe(new ItemStack((ItemLike)EnigmaticItems.THE_CUBE), new ItemStack((ItemLike)EnigmaticItems.GOLEM_HEART), new ItemStack((ItemLike)EnigmaticItems.COSMIC_HEART), new ItemStack((ItemLike)EnigmaticItems.BLAZING_CORE), new ItemStack((ItemLike)EnigmaticItems.ANGEL_BLESSING), new ItemStack((ItemLike)Blocks.f_50080_), new ItemStack((ItemLike)EnigmaticItems.EYE_OF_NEBULA), new ItemStack((ItemLike)EnigmaticItems.OCEAN_STONE), new ItemStack((ItemLike)EnigmaticItems.COSMIC_HEART), new ItemStack((ItemLike)EnigmaticItems.VOID_PEARL));
        }
        if (OmniconfigHandler.isItemEnabled((Object)EnigmaticItems.ASCENSION_AMULET)) {
            HiddenRecipe.addRecipe(new ItemStack((ItemLike)EnigmaticItems.ASCENSION_AMULET), new ItemStack((ItemLike)Items.f_151049_), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST), new ItemStack((ItemLike)Items.f_151049_), new ItemStack((ItemLike)EnigmaticItems.ETHERIUM_INGOT), new ItemStack((ItemLike)EnigmaticItems.ENIGMATIC_AMULET), new ItemStack((ItemLike)EnigmaticItems.ETHERIUM_INGOT), new ItemStack((ItemLike)Items.f_42735_), new ItemStack((ItemLike)EnigmaticItems.COSMIC_HEART), new ItemStack((ItemLike)Items.f_42735_));
        }
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.ELDRITCH_AMULET)) {
            HiddenRecipe.addRecipe(new ItemStack((ItemLike)EnigmaticItems.ELDRITCH_AMULET), new ItemStack((ItemLike)EnigmaticItems.EVIL_ESSENCE), new ItemStack((ItemLike)EnigmaticItems.ABYSSAL_HEART), new ItemStack((ItemLike)EnigmaticItems.EVIL_ESSENCE), new ItemStack((ItemLike)Items.f_42418_), new ItemStack((ItemLike)EnigmaticItems.ASCENSION_AMULET), new ItemStack((ItemLike)Items.f_42418_), new ItemStack((ItemLike)EnigmaticItems.TWISTED_HEART), new ItemStack((ItemLike)Items.f_42686_), new ItemStack((ItemLike)EnigmaticItems.TWISTED_HEART));
        }
        if (OmniconfigHandler.isItemEnabled(EnigmaticItems.COSMIC_SCROLL)) {
            HiddenRecipe.addRecipe(new ItemStack((ItemLike)EnigmaticItems.COSMIC_SCROLL), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST), new ItemStack((ItemLike)Items.f_42437_), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST), new ItemStack((ItemLike)EnigmaticItems.ETHERIUM_INGOT), new ItemStack((ItemLike)EnigmaticItems.DARKEST_SCROLL), new ItemStack((ItemLike)EnigmaticItems.ETHERIUM_INGOT), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST), new ItemStack((ItemLike)EnigmaticItems.COSMIC_HEART), new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST));
        }
        EnigmaticUpdateHandler.init();
        PROXY.loadComplete(event);
        DevotedBelieversHandler.getDevotedBelievers().entrySet().forEach(entry -> LOGGER.getInternal().info("Believer: {}, UUID: {}", entry.getKey(), entry.getValue()));
        LOGGER.info("Load completion phase finished successfully");
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing common setup phase...");
        event.enqueueWork(() -> this.loadClass(EnigmaticLootFunctions.class));
        event.enqueueWork(() -> this.loadClass(EnigmaticPotions.class));
        GolemHeart.buildArmorExclusions();
        damageTypesFire.add(DamageSource.f_19308_.f_19326_);
        damageTypesFire.add(DamageSource.f_19305_.f_19326_);
        damageTypesFire.add(DamageSource.f_19307_.f_19326_);
        LOGGER.info("Registering packets...");
        packetInstance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        packetInstance.registerMessage(0, PacketRecallParticles.class, PacketRecallParticles::encode, PacketRecallParticles::decode, PacketRecallParticles::handle);
        packetInstance.registerMessage(1, PacketEnderRingKey.class, PacketEnderRingKey::encode, PacketEnderRingKey::decode, PacketEnderRingKey::handle);
        packetInstance.registerMessage(2, PacketSpellstoneKey.class, PacketSpellstoneKey::encode, PacketSpellstoneKey::decode, PacketSpellstoneKey::handle);
        packetInstance.registerMessage(3, PacketPlayerMotion.class, PacketPlayerMotion::encode, PacketPlayerMotion::decode, PacketPlayerMotion::handle);
        packetInstance.registerMessage(4, PacketPlayerRotations.class, PacketPlayerRotations::encode, PacketPlayerRotations::decode, PacketPlayerRotations::handle);
        packetInstance.registerMessage(5, PacketPlayerSetlook.class, PacketPlayerSetlook::encode, PacketPlayerSetlook::decode, PacketPlayerSetlook::handle);
        packetInstance.registerMessage(7, PacketConfirmTeleportation.class, PacketConfirmTeleportation::encode, PacketConfirmTeleportation::decode, PacketConfirmTeleportation::handle);
        packetInstance.registerMessage(8, PacketPortalParticles.class, PacketPortalParticles::encode, PacketPortalParticles::decode, PacketPortalParticles::handle);
        packetInstance.registerMessage(9, PacketXPScrollKey.class, PacketXPScrollKey::encode, PacketXPScrollKey::decode, PacketXPScrollKey::handle);
        packetInstance.registerMessage(10, PacketSlotUnlocked.class, PacketSlotUnlocked::encode, PacketSlotUnlocked::decode, PacketSlotUnlocked::handle);
        packetInstance.registerMessage(11, PacketHandleItemPickup.class, PacketHandleItemPickup::encode, PacketHandleItemPickup::decode, PacketHandleItemPickup::handle);
        packetInstance.registerMessage(12, PacketUpdateNotification.class, PacketUpdateNotification::encode, PacketUpdateNotification::decode, PacketUpdateNotification::handle);
        packetInstance.registerMessage(13, PacketAnvilField.class, PacketAnvilField::encode, PacketAnvilField::decode, PacketAnvilField::handle);
        packetInstance.registerMessage(14, PacketWitherParticles.class, PacketWitherParticles::encode, PacketWitherParticles::decode, PacketWitherParticles::handle);
        packetInstance.registerMessage(15, PacketFlameParticles.class, PacketFlameParticles::encode, PacketFlameParticles::decode, PacketFlameParticles::handle);
        packetInstance.registerMessage(16, PacketSetEntryState.class, PacketSetEntryState::encode, PacketSetEntryState::decode, PacketSetEntryState::handle);
        packetInstance.registerMessage(17, PacketForceArrowRotations.class, PacketForceArrowRotations::encode, PacketForceArrowRotations::decode, PacketForceArrowRotations::handle);
        packetInstance.registerMessage(18, PacketInkwellField.class, PacketInkwellField::encode, PacketInkwellField::decode, PacketInkwellField::handle);
        packetInstance.registerMessage(19, PacketSyncTransientData.class, PacketSyncTransientData::encode, PacketSyncTransientData::decode, PacketSyncTransientData::handle);
        packetInstance.registerMessage(20, PacketSyncOptions.class, PacketSyncOptions::encode, PacketSyncOptions::decode, PacketSyncOptions::handle);
        packetInstance.registerMessage(21, PacketGenericParticleEffect.class, PacketGenericParticleEffect::encode, PacketGenericParticleEffect::decode, PacketGenericParticleEffect::handle);
        packetInstance.registerMessage(22, PacketUpdateExperience.class, PacketUpdateExperience::encode, PacketUpdateExperience::decode, PacketUpdateExperience::handle);
        packetInstance.registerMessage(23, PacketToggleMagnetEffects.class, PacketToggleMagnetEffects::encode, PacketToggleMagnetEffects::decode, PacketToggleMagnetEffects::handle);
        packetInstance.registerMessage(24, PacketPatchouliForce.class, PacketPatchouliForce::encode, PacketPatchouliForce::decode, PacketPatchouliForce::handle);
        packetInstance.registerMessage(25, PacketSyncPlayTime.class, PacketSyncPlayTime::encode, PacketSyncPlayTime::decode, PacketSyncPlayTime::handle);
        packetInstance.registerMessage(26, PacketCosmicRevive.class, PacketCosmicRevive::encode, PacketCosmicRevive::decode, PacketCosmicRevive::handle);
        packetInstance.registerMessage(27, PacketEnchantingGUI.class, PacketEnchantingGUI::encode, PacketEnchantingGUI::decode, PacketEnchantingGUI::handle);
        packetInstance.registerMessage(28, PacketUpdateCompass.class, PacketUpdateCompass::encode, PacketUpdateCompass::decode, PacketUpdateCompass::handle);
        packetInstance.registerMessage(29, PacketPlayQuote.class, PacketPlayQuote::encode, PacketPlayQuote::decode, PacketPlayQuote::handle);
        packetInstance.registerMessage(30, PacketUpdateElytraBoosting.class, PacketUpdateElytraBoosting::encode, PacketUpdateElytraBoosting::decode, PacketUpdateElytraBoosting::handle);
        packetInstance.registerMessage(31, PacketPermadeath.class, PacketPermadeath::encode, PacketPermadeath::decode, PacketPermadeath::handle);
        LOGGER.info("Registering triggers...");
        CriteriaTriggers.m_10595_((CriterionTrigger)UseUnholyGrailTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)BeheadingTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)RevelationGainTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)CursedRingEquippedTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)RevelationTomeBurntTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)ForbiddenFruitTrigger.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)CursedInventoryChangedTrigger.INSTANCE);
        LOGGER.info("Registering stats...");
        event.enqueueWork(() -> {
            Registry.m_122965_((Registry)Registry.f_122832_, (ResourceLocation)PlayerPlaytimeCounter.TIME_WITH_CURSES_STAT, (Object)PlayerPlaytimeCounter.TIME_WITH_CURSES_STAT);
            Stats.f_12988_.m_12899_((Object)PlayerPlaytimeCounter.TIME_WITH_CURSES_STAT, StatFormatter.f_12876_);
            Registry.m_122965_((Registry)Registry.f_122832_, (ResourceLocation)PlayerPlaytimeCounter.TIME_WITHOUT_CURSES_STAT, (Object)PlayerPlaytimeCounter.TIME_WITHOUT_CURSES_STAT);
            Stats.f_12988_.m_12899_((Object)PlayerPlaytimeCounter.TIME_WITHOUT_CURSES_STAT, StatFormatter.f_12876_);
        });
        LOGGER.info("Common setup phase finished successfully.");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        LOGGER.info("Initializing client setup phase...");
        EnigmaticItems.ENIGMATIC_AMULET.registerVariants();
        EnigmaticItems.ENIGMATIC_EYE.registerVariants();
        EnigmaticItems.SOUL_COMPASS.registerVariants();
        PROXY.initEntityRendering();
        MenuScreens.m_96206_(EnigmaticMenus.LORE_INSCRIBER_CONTAINER, LoreInscriberScreen::new);
        LOGGER.info("Client setup phase finished successfully.");
    }

    private void intermodStuff(InterModEnqueueEvent event) {
        LOGGER.info("Sending messages to Curios API...");
        SuperpositionHandler.registerCurioType("charm", 1, false, null);
        SuperpositionHandler.registerCurioType("ring", 2, false, null);
        SuperpositionHandler.registerCurioType("back", 1, false, null);
        SuperpositionHandler.registerCurioType("spellstone", 0, false, new ResourceLocation(MODID, "slots/empty_spellstone_slot"));
        SuperpositionHandler.registerCurioType("scroll", 0, false, new ResourceLocation(MODID, "slots/empty_scroll_slot"));
    }

    private void onServerStart(ServerAboutToStartEvent event) {
        this.performCleanup();
        SoulArchive.initialize(event.getServer());
    }

    private void onServerStarted(ServerStartedEvent event) {
    }

    public void performCleanup() {
        PROXY.clearTransientData();
        EnigmaticEventHandler.AGERED_GUARDIANS.clear();
        EnigmaticEventHandler.POSTMORTAL_POSESSIONS.clear();
        EnigmaticEventHandler.KNOCKBACK_THAT_BASTARD.clear();
        EnigmaticEventHandler.DEFERRED_TOASTS.clear();
        EnigmaticEventHandler.DESOLATION_BOXES.clear();
        EnigmaticEventHandler.LAST_SOUL_COMPASS_UPDATE.clear();
        EnigmaticEventHandler.LAST_HEALTH.clear();
        EnigmaticEventHandler.SCHEDULED_DATA_SYNC.clear();
        EnigmaticItems.SOUL_CRYSTAL.attributeDispatcher.clear();
        EnigmaticItems.ENIGMATIC_ITEM.flightMap.clear();
        EnigmaticItems.HEAVEN_SCROLL.flyMap.clear();
        EnigmaticItems.THE_CUBE.clearLocationCache();
        RegisteredMeleeAttack.clearRegistry();
    }

    public boolean isCSGPresent() {
        return ModList.get().isLoaded("customstartinggear");
    }

    public boolean isLockboxPresent() {
        return ModList.get().isLoaded("enigmaticlockbox");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterKeybinds(RegisterKeyMappingsEvent event) {
        EnigmaticLegacy.keybindHandler.enderRingKey = new KeyMapping("key.enderRing", 73, "key.categories.enigmaticLegacy");
        EnigmaticLegacy.keybindHandler.spellstoneAbilityKey = new KeyMapping("key.spellstoneAbility", 75, "key.categories.enigmaticLegacy");
        EnigmaticLegacy.keybindHandler.xpScrollKey = new KeyMapping("key.xpScroll", 74, "key.categories.enigmaticLegacy");
        event.register(EnigmaticLegacy.keybindHandler.enderRingKey);
        event.register(EnigmaticLegacy.keybindHandler.spellstoneAbilityKey);
        event.register(EnigmaticLegacy.keybindHandler.xpScrollKey);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void stitchTextures(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            event.addSprite(new ResourceLocation(MODID, "slots/empty_spellstone_slot"));
            event.addSprite(new ResourceLocation(MODID, "slots/empty_scroll_slot"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onColorInit(RegisterColorHandlersEvent.Item event) {
        LOGGER.info("Initializing colors registration...");
        event.register((stack, color) -> {
            if (PotionHelper.isAdvancedPotion(stack)) {
                return color > 0 ? -1 : PotionHelper.getColor(stack);
            }
            return color > 0 ? -1 : PotionUtils.m_43575_((ItemStack)stack);
        }, new ItemLike[]{EnigmaticItems.ULTIMATE_POTION, EnigmaticItems.ULTIMATE_POTION_SPLASH, EnigmaticItems.ULTIMATE_POTION_LINGERING, EnigmaticItems.COMMON_POTION, EnigmaticItems.COMMON_POTION_SPLASH, EnigmaticItems.COMMON_POTION_LINGERING});
        LOGGER.info("Colors registered successfully.");
    }

    static {
        damageTypesFire = new ArrayList<String>();
        MAIN_TAB = new CreativeModeTab("enigmaticCreativeTab"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)EnigmaticItems.ENIGMATIC_ITEM);
            }
        };
        POTION_TAB = new CreativeModeTab("enigmaticPotionCreativeTab"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)EnigmaticItems.RECALL_POTION);
            }
        };
        LEGENDARY = Rarity.create((String)"legendary", (ChatFormatting)ChatFormatting.GOLD);
    }
}

