/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.handlers;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.capabilities.IPlaytimeCounter;
import com.aizistral.enigmaticlegacy.api.generic.ConfigurableItem;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.api.quack.IProperShieldUser;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.handlers.DevotedBelieversHandler;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.aizistral.enigmaticlegacy.handlers.RealSmoothTeleporter;
import com.aizistral.enigmaticlegacy.handlers.SoulArchive;
import com.aizistral.enigmaticlegacy.helpers.AdvancedSpawnLocationHelper;
import com.aizistral.enigmaticlegacy.items.GolemHeart;
import com.aizistral.enigmaticlegacy.items.InfernalShield;
import com.aizistral.enigmaticlegacy.items.TheAcknowledgment;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.objects.DimensionalPosition;
import com.aizistral.enigmaticlegacy.objects.EnigmaticTransience;
import com.aizistral.enigmaticlegacy.objects.TransientPlayerData;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.aizistral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.aizistral.enigmaticlegacy.packets.clients.PacketUpdateCompass;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEffects;
import com.aizistral.enigmaticlegacy.registries.EnigmaticEnchantments;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class SuperpositionHandler {
    public static final Random RANDOM = new Random();
    public static final char[] ALPHABET = "abcdefghijklmnopqrstuvwxyz".toUpperCase().toCharArray();
    public static final UUID SCROLL_SLOT_UUID = UUID.fromString("ae465e52-ffc2-4f57-b09a-066aa0cea3d4");
    public static final UUID SPELLSTONE_SLOT_UUID = UUID.fromString("63df175a-0d6d-4163-8ef1-218bcb42feba");
    public static final UUID RING_SLOT_UUID = UUID.fromString("76012386-aa31-4c17-8d6a-e9dd29affcb0");
    public static final UUID CHARM_SLOT_UUID = UUID.fromString("485121e7-b670-45dc-b014-4c8b8f62283d");
    public static final char[] UPPERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] LOWERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] NUMBERS = "0123456789".toCharArray();
    public static final char[] SPECIAL_SYMBOLS = "-+=(){}[]':;./,<>*&^%$#@!?~".toCharArray();

    public static boolean hasAdvancedCurios(LivingEntity entity) {
        return SuperpositionHandler.getAdvancedCurios(entity).size() > 0;
    }

    public static boolean unlockSpecialSlot(String slot, Player player) {
        if (!(slot.equals("scroll") || slot.equals("spellstone") || slot.equals("ring") || slot.equals("charm"))) {
            throw new IllegalArgumentException("Slot type '" + slot + "' is not supported!");
        }
        MutableBoolean success = new MutableBoolean(false);
        UUID id = slot.equals("scroll") ? SCROLL_SLOT_UUID : (slot.equals("spellstone") ? SPELLSTONE_SLOT_UUID : (slot.equals("ring") ? RING_SLOT_UUID : CHARM_SLOT_UUID));
        ICuriosHelper apiHelper = CuriosApi.getCuriosHelper();
        apiHelper.getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(slot).ifPresent(stacks -> {
            Map map = stacks.getModifiers();
            if (!stacks.getModifiers().containsKey(id)) {
                stacks.addPermanentModifier(new AttributeModifier(id, "Masterslot", 1.0, AttributeModifier.Operation.ADDITION));
                success.setTrue();
            }
        }));
        return success.getValue();
    }

    public static List<ItemStack> getAdvancedCurios(LivingEntity entity) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(entity).orElse(null);
        if (handler != null) {
            handler.getCurios().values().forEach(stacksHandler -> {
                IDynamicStackHandler soloStackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (soloStackHandler.getStackInSlot(i) == null || !(soloStackHandler.getStackInSlot(i).m_41720_() instanceof ItemSpellstoneCurio)) continue;
                    stackList.add(soloStackHandler.getStackInSlot(i));
                }
            });
        }
        return stackList;
    }

    public static boolean isSlotLocked(String id, LivingEntity livingEntity) {
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).orElse(null);
        if (handler != null) {
            return handler.getLockedSlots().contains(id);
        }
        return true;
    }

    public static boolean hasSpellstone(LivingEntity entity) {
        return SuperpositionHandler.getSpellstone(entity) != null;
    }

    @Nullable
    public static ItemStack getSpellstone(LivingEntity entity) {
        ArrayList spellstoneStack = new ArrayList();
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> {
            IDynamicStackHandler soloStackHandler;
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get("spellstone");
            if (stacksHandler != null && (soloStackHandler = stacksHandler.getStacks()) != null) {
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (soloStackHandler.getStackInSlot(i) == null || !(soloStackHandler.getStackInSlot(i).m_41720_() instanceof ISpellstone)) continue;
                    spellstoneStack.add(soloStackHandler.getStackInSlot(i));
                    break;
                }
            }
        });
        return spellstoneStack.isEmpty() ? null : (ItemStack)spellstoneStack.get(0);
    }

    public static boolean hasCurio(LivingEntity entity, Item curio) {
        Optional data = CuriosApi.getCuriosHelper().findEquippedCurio(curio, entity);
        return data.isPresent();
    }

    @Nullable
    public static ItemStack getCurioStack(LivingEntity entity, Item curio) {
        Optional data = CuriosApi.getCuriosHelper().findEquippedCurio(curio, entity);
        if (data.isPresent()) {
            return (ItemStack)((ImmutableTriple)data.get()).getRight();
        }
        return null;
    }

    public static void destroyCurio(LivingEntity entity, Item curio) {
        CuriosApi.getCuriosHelper().getEquippedCurios(entity).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots() - 1; ++i) {
                if (handler.getStackInSlot(i) == null || handler.getStackInSlot(i).m_41720_() != curio) continue;
                handler.setStackInSlot(i, ItemStack.f_41583_);
            }
        });
    }

    public static boolean tryForceEquip(LivingEntity entity, ItemStack curio) {
        if (!(curio.m_41720_() instanceof ICurioItem)) {
            throw new IllegalArgumentException("I fear for now this only works with ICurioItem");
        }
        MutableBoolean equipped = new MutableBoolean(false);
        ICurioItem item = (ICurioItem)curio.m_41720_();
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> {
            if (!entity.f_19853_.f_46443_) {
                Map curios = handler.getCurios();
                block0: for (Map.Entry entry : curios.entrySet()) {
                    IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack present = stackHandler.getStackInSlot(i);
                        Set tags = CuriosApi.getCuriosHelper().getCurioTags(curio.m_41720_());
                        String id = (String)entry.getKey();
                        SlotContext context = new SlotContext(id, entity, i, false, ((ICurioStacksHandler)entry.getValue()).isVisible());
                        if (!present.m_41619_() || !tags.contains(id) && !tags.contains("curio") || !item.canEquip(context, curio)) continue;
                        stackHandler.setStackInSlot(i, curio);
                        item.playRightClickEquipSound(entity, curio);
                        equipped.setTrue();
                        break block0;
                    }
                }
            }
        });
        return equipped.booleanValue();
    }

    public static void registerCurioType(String identifier, int slots, boolean isHidden, @Nullable ResourceLocation icon) {
        SlotTypeMessage.Builder message = new SlotTypeMessage.Builder(identifier);
        message.size(slots);
        if (isHidden) {
            message.hide();
        }
        if (icon != null) {
            message.icon(icon);
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> message.build());
    }

    public static SoundEvent registerSound(String soundName) {
        ResourceLocation location = new ResourceLocation("enigmaticlegacy", soundName);
        SoundEvent event = new SoundEvent(location);
        ForgeRegistries.SOUND_EVENTS.register(location, (Object)event);
        return event;
    }

    public static AABB getBoundingBoxAroundEntity(Entity entity, double radius) {
        return new AABB(entity.m_20185_() - radius, entity.m_20186_() - radius, entity.m_20189_() - radius, entity.m_20185_() + radius, entity.m_20186_() + radius, entity.m_20189_() + radius);
    }

    public static void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector = finalVector.normalize();
        }
        entity.m_20334_(finalVector.x * (double)modifier, finalVector.y * (double)modifier, finalVector.z * (double)modifier);
    }

    @Nullable
    public static LivingEntity getObservedEntity(Player player, Level world, float range, int maxDist) {
        List<LivingEntity> entities = SuperpositionHandler.getObservedEntities(player, world, range, maxDist, true);
        return entities.size() > 0 ? entities.get(0) : null;
    }

    public static List<LivingEntity> getObservedEntities(Player player, Level world, float range, int maxDist, boolean stopWhenFound) {
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (int distance = 1; distance < maxDist; ++distance) {
            target = target.add(new Vector3(player.m_20154_()).multiply(distance)).add(0.0, 0.5, 0.0);
            List list = player.f_19853_.m_45976_(LivingEntity.class, new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
            list.removeIf(entity -> entity == player || !player.m_142582_((Entity)entity));
            entities.addAll(list);
            if (stopWhenFound && entities.size() > 0) break;
        }
        return entities;
    }

    @Nullable
    public static <T extends LivingEntity> T getClosestEntity(List<? extends T> entities, Predicate<LivingEntity> predicate, double x, double y, double z) {
        double d0 = -1.0;
        LivingEntity t = null;
        for (LivingEntity t1 : entities) {
            if (!predicate.test(t1)) continue;
            double d1 = t1.m_20275_(x, y, z);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    public static boolean doesObserveEntity(Player player, LivingEntity entity) {
        Vec3 vector3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vector3d1 = new Vec3(entity.m_20185_() - player.m_20185_(), entity.m_20188_() - player.m_20188_(), entity.m_20189_() - player.m_20189_());
        double d0 = vector3d1.m_82553_();
        double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? player.m_142582_((Entity)entity) : false;
    }

    public static int getSpellstoneCooldown(Player player) {
        return TransientPlayerData.get(player).getSpellstoneCooldown();
    }

    public static void setSpellstoneCooldown(Player playerIn, int value) {
        TransientPlayerData.get(playerIn).setSpellstoneCooldown(value);
    }

    public static void tickSpellstoneCooldown(Player player, int decrementedTicks) {
        TransientPlayerData data = TransientPlayerData.get(player);
        data.spellstoneCooldown = data.getSpellstoneCooldown() - decrementedTicks;
    }

    public static boolean hasSpellstoneCooldown(Player player) {
        return TransientPlayerData.get(player).getSpellstoneCooldown() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lookAt(double px, double py, double pz, LocalPlayer me) {
        double dirx = me.m_20185_() - px;
        double diry = me.m_20186_() - py;
        double dirz = me.m_20189_() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.m_146926_((float)pitch);
        me.m_146922_((float)(yaw += 90.0));
    }

    public static boolean validTeleport(Entity entity, double x_init, double y_init, double z_init, Level world, int checkAxis) {
        int x = (int)x_init;
        int y = (int)y_init;
        int z = (int)z_init;
        BlockState block = world.m_8055_(new BlockPos(x, y - 1, z));
        if (!world.m_46859_(new BlockPos(x, y - 1, z)) && block.m_60815_()) {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (world.m_46859_(new BlockPos(x, y + counter - 1, z)) || !world.m_8055_(new BlockPos(x, y + counter - 1, z)).m_60815_() || !world.m_46859_(new BlockPos(x, y + counter, z)) || !world.m_46859_(new BlockPos(x, y + counter + 1, z))) continue;
                world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 128.0, entity.f_19853_.m_46472_())), (Object)new PacketPortalParticles(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 72, 1.0, false));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.m_6021_((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).m_6021_((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                }
                world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 128.0, entity.f_19853_.m_46472_())), (Object)new PacketRecallParticles(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 48, false));
                return true;
            }
        } else {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (world.m_46859_(new BlockPos(x, y - counter - 1, z)) || !world.m_8055_(new BlockPos(x, y - counter - 1, z)).m_60815_() || !world.m_46859_(new BlockPos(x, y - counter, z)) || !world.m_46859_(new BlockPos(x, y - counter + 1, z))) continue;
                world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 128.0, entity.f_19853_.m_46472_())), (Object)new PacketRecallParticles(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 48, false));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.m_6021_((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).m_6021_((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                }
                world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 128.0, entity.f_19853_.m_46472_())), (Object)new PacketRecallParticles(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 48, false));
                return true;
            }
        }
        return false;
    }

    public static boolean validTeleportRandomly(Entity entity, Level world, int radius) {
        int d = radius * 2;
        double x = entity.m_20185_() + (Math.random() - 0.5) * (double)d;
        double y = entity.m_20186_() + (Math.random() - 0.5) * (double)d;
        double z = entity.m_20189_() + (Math.random() - 0.5) * (double)d;
        return SuperpositionHandler.validTeleport(entity, x, y, z, world, radius);
    }

    public static LootPool constructLootPool(String poolName, float minRolls, float maxRolls, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder poolBuilder = LootPool.m_79043_();
        poolBuilder.name(poolName);
        poolBuilder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls));
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            if (entry == null) continue;
            poolBuilder.m_79076_(entry);
        }
        LootPool constructedPool = poolBuilder.m_79082_();
        return constructedPool;
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight, float minCount, float maxCount) {
        if (!OmniconfigHandler.isItemEnabled(item)) {
            return null;
        }
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minCount, (float)maxCount)));
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight) {
        if (!OmniconfigHandler.isItemEnabled(item)) {
            return null;
        }
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    public static LootPoolSingletonContainer.Builder<?> itemEntryBuilderED(Item item, int weight, float enchantLevelMin, float enchantLevelMax, float damageMin, float damageMax) {
        LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)item);
        builder.m_79707_(weight);
        builder.m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)damageMax, (float)damageMin)));
        builder.m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)enchantLevelMin, (float)enchantLevelMax)).m_80499_());
        return builder;
    }

    public static List<ResourceLocation> getEarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78742_);
        lootChestList.add(BuiltInLootTables.f_78759_);
        lootChestList.add(BuiltInLootTables.f_78745_);
        return lootChestList;
    }

    public static List<ResourceLocation> getWaterDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78691_);
        lootChestList.add(BuiltInLootTables.f_78690_);
        lootChestList.add(BuiltInLootTables.f_78695_);
        lootChestList.add(BuiltInLootTables.f_78692_);
        return lootChestList;
    }

    public static List<ResourceLocation> getLibraries() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78761_);
        lootChestList.add(BuiltInLootTables.f_78693_);
        return lootChestList;
    }

    public static List<ResourceLocation> getBastionChests() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78697_);
        lootChestList.add(BuiltInLootTables.f_78698_);
        lootChestList.add(BuiltInLootTables.f_78699_);
        lootChestList.add(BuiltInLootTables.f_78700_);
        return lootChestList;
    }

    public static List<ResourceLocation> getNetherDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78760_);
        lootChestList.add(BuiltInLootTables.f_78697_);
        lootChestList.add(BuiltInLootTables.f_78698_);
        lootChestList.add(BuiltInLootTables.f_78699_);
        lootChestList.add(BuiltInLootTables.f_78700_);
        lootChestList.add(BuiltInLootTables.f_78701_);
        return lootChestList;
    }

    public static List<ResourceLocation> getAirDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78753_);
        return lootChestList;
    }

    public static List<ResourceLocation> getEnderDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78741_);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedAir$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78764_);
        lootChestList.add(BuiltInLootTables.f_78686_);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedEnder$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78763_);
        lootChestList.add(BuiltInLootTables.f_78762_);
        return lootChestList;
    }

    public static List<ResourceLocation> getOverworldDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78742_);
        lootChestList.add(BuiltInLootTables.f_78759_);
        lootChestList.add(BuiltInLootTables.f_78762_);
        lootChestList.add(BuiltInLootTables.f_78763_);
        lootChestList.add(BuiltInLootTables.f_78764_);
        lootChestList.add(BuiltInLootTables.f_78686_);
        lootChestList.add(BuiltInLootTables.f_78688_);
        lootChestList.add(BuiltInLootTables.f_78689_);
        lootChestList.add(BuiltInLootTables.f_78690_);
        lootChestList.add(BuiltInLootTables.f_78691_);
        lootChestList.add(BuiltInLootTables.f_78694_);
        lootChestList.add(BuiltInLootTables.f_78696_);
        return lootChestList;
    }

    public static List<ResourceLocation> getVillageChests() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78743_);
        lootChestList.add(BuiltInLootTables.f_78744_);
        lootChestList.add(BuiltInLootTables.f_78745_);
        lootChestList.add(BuiltInLootTables.f_78746_);
        lootChestList.add(BuiltInLootTables.f_78747_);
        lootChestList.add(BuiltInLootTables.f_78748_);
        lootChestList.add(BuiltInLootTables.f_78749_);
        lootChestList.add(BuiltInLootTables.f_78750_);
        lootChestList.add(BuiltInLootTables.f_78751_);
        lootChestList.add(BuiltInLootTables.f_78752_);
        lootChestList.add(BuiltInLootTables.f_78753_);
        lootChestList.add(BuiltInLootTables.f_78754_);
        lootChestList.add(BuiltInLootTables.f_78755_);
        lootChestList.add(BuiltInLootTables.f_78756_);
        lootChestList.add(BuiltInLootTables.f_78757_);
        lootChestList.add(BuiltInLootTables.f_78758_);
        return lootChestList;
    }

    public static Tag getPersistentTag(Player player, String tag, Tag expectedValue) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.m_128365_("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.m_128469_("PlayerPersisted");
        }
        if (persistent.m_128441_(tag)) {
            return persistent.m_128423_(tag);
        }
        return expectedValue;
    }

    public static void removePersistentTag(Player player, String tag) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.m_128365_("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.m_128469_("PlayerPersisted");
        }
        if (persistent.m_128441_(tag)) {
            persistent.m_128473_(tag);
        }
    }

    public static void setPersistentTag(Player player, String tag, Tag value) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.m_128365_("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.m_128469_("PlayerPersisted");
        }
        persistent.m_128365_(tag, value);
    }

    public static void setPersistentBoolean(Player player, String tag, boolean value) {
        SuperpositionHandler.setPersistentTag(player, tag, (Tag)ByteTag.m_128273_((boolean)value));
    }

    public static boolean getPersistentBoolean(Player player, String tag, boolean expectedValue) {
        Tag theTag = SuperpositionHandler.getPersistentTag(player, tag, (Tag)ByteTag.m_128273_((boolean)expectedValue));
        return theTag instanceof ByteTag ? ((ByteTag)theTag).m_7063_() != 0 : expectedValue;
    }

    public static void setPersistentInteger(Player player, String tag, int value) {
        SuperpositionHandler.setPersistentTag(player, tag, (Tag)IntTag.m_128679_((int)value));
    }

    public static int getPersistentInteger(Player player, String tag, int expectedValue) {
        Tag theTag = SuperpositionHandler.getPersistentTag(player, tag, (Tag)IntTag.m_128679_((int)expectedValue));
        return theTag instanceof IntTag ? ((IntTag)theTag).m_7047_() : expectedValue;
    }

    public static boolean hasPersistentTag(Player player, String tag) {
        CompoundTag persistent;
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.m_128365_("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.m_128469_("PlayerPersisted");
        }
        return persistent.m_128441_(tag);
    }

    public static boolean hasAdvancement(@Nonnull ServerPlayer player, @Nonnull ResourceLocation location) {
        try {
            if (player.m_8960_().m_135996_(player.f_8924_.m_129889_().m_136041_(location)).m_8193_()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean doesAdvancementExist(@Nonnull ResourceLocation location) {
        return ServerLifecycleHooks.getCurrentServer().m_129889_().m_136041_(location) != null;
    }

    public static void grantAdvancement(@Nonnull ServerPlayer player, @Nonnull ResourceLocation location) {
        Advancement adv = player.f_8924_.m_129889_().m_136041_(location);
        for (String criterion : player.m_8960_().m_135996_(adv).m_8219_()) {
            player.m_8960_().m_135988_(adv, criterion);
        }
    }

    public static void revokeAdvancement(@Nonnull ServerPlayer player, @Nonnull ResourceLocation location) {
        Advancement adv = player.f_8924_.m_129889_().m_136041_(location);
        for (String criterion : player.m_8960_().m_135996_(adv).m_8220_()) {
            player.m_8960_().m_135998_(adv, criterion);
        }
    }

    public static String generateRandomWorldNumber() {
        String number = "";
        while (number.length() < 4) {
            number = number.concat("" + RANDOM.nextInt(10));
        }
        number = number.concat("-");
        while (number.length() < 7) {
            number = number.concat("" + ALPHABET[RANDOM.nextInt(ALPHABET.length)]);
        }
        while (number.length() < 9) {
            number = number.concat("" + RANDOM.nextInt(10));
        }
        return number;
    }

    public static Player getPlayerByName(Level world, String name) {
        Player player = null;
        for (Player checkedPlayer : world.m_6907_()) {
            if (!checkedPlayer.m_5446_().getString().equals(name)) continue;
            player = checkedPlayer;
        }
        return player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(List<MobEffectInstance> list, ItemStack itemIn, List<Component> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() > 0) {
                    iformattabletextcomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + effectinstance.m_19564_())));
                }
                if (effectinstance.m_19557_() > 20) {
                    iformattabletextcomponent.m_130946_(" (").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectinstance, (float)durationFactor)).m_130946_(")");
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(CommonComponents.f_237098_);
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }

    public static boolean canPickStack(Player player, ItemStack stack) {
        if (player.m_150109_().m_36062_() >= 0) {
            return true;
        }
        ArrayList allInventories = new ArrayList();
        allInventories.addAll(player.m_150109_().f_35974_);
        allInventories.addAll(player.m_150109_().f_35976_);
        for (ItemStack invStack : allInventories) {
            if (!SuperpositionHandler.canMergeStacks(invStack, stack, player.m_150109_().m_6893_())) continue;
            return true;
        }
        return false;
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2, int invStackLimit) {
        return !stack1.m_41619_() && SuperpositionHandler.stackEqualExact(stack1, stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_() && stack1.m_41613_() < invStackLimit;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isPermanentlyDead(Player player) {
        return EnigmaticItems.SOUL_CRYSTAL.getLostCrystals(player) >= 10 && OmniconfigHandler.maxSoulCrystalLoss.getValue() >= 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getParticleMultiplier() {
        if (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) {
            return 0.35f;
        }
        if (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED) {
            return 0.65f;
        }
        return 1.0f;
    }

    public static boolean isInBeaconRange(Player player) {
        if (player.f_19853_.f_46443_) {
            return false;
        }
        ArrayList<BeaconBlockEntity> list = new ArrayList<BeaconBlockEntity>();
        boolean inRange = false;
        ServerLevel level = (ServerLevel)player.f_19853_;
        ServerChunkCache cache = (ServerChunkCache)player.f_19853_.m_7726_();
        for (ChunkHolder holder : cache.f_8325_.f_140130_.values()) {
            LevelChunk chunk;
            ChunkPos pos = holder.m_140092_();
            if (pos == null || (chunk = holder.m_140085_()) == null) continue;
            for (BlockEntity tile : chunk.m_62954_().values()) {
                if (!(tile instanceof BeaconBlockEntity)) continue;
                list.add((BeaconBlockEntity)tile);
            }
        }
        if (list.size() > 0) {
            for (BeaconBlockEntity beacon : list) {
                if (beacon.f_58650_ <= 0) continue;
                try {
                    if (beacon.m_58702_().isEmpty()) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                int range = (beacon.f_58650_ + 1) * 10;
                double distance = Math.sqrt(beacon.m_58899_().m_203198_(player.m_20185_(), (double)beacon.m_58899_().m_123342_(), player.m_20189_()));
                if (!(distance <= (double)range)) continue;
                inRange = true;
            }
        }
        return inRange;
    }

    public static boolean hasItem(Player player, Item item) {
        return player.m_150109_().m_36063_(new ItemStack((ItemLike)item));
    }

    public static boolean hasExactStack(Player player, ItemStack stack) {
        for (List list : player.m_150109_().f_35979_) {
            for (ItemStack inventoryStack : list) {
                if (inventoryStack != stack) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ifDroplistContainsItem(Collection<ItemEntity> drops, Item item) {
        for (ItemEntity drop : drops) {
            if (drop.m_32055_() == null || drop.m_32055_().m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isAffectedBySoulLoss(Player player, boolean hadRing) {
        int dropMode = OmniconfigHandler.soulCrystalsMode.getValue();
        boolean keepInventory = player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_);
        if (dropMode == 0) {
            return hadRing;
        }
        if (dropMode == 1) {
            return hadRing || keepInventory;
        }
        return dropMode == 2;
    }

    public static boolean canDropSoulCrystal(Player player, boolean hadRing) {
        if (SuperpositionHandler.isAffectedBySoulLoss(player, hadRing)) {
            int maxCrystalLoss = OmniconfigHandler.maxSoulCrystalLoss.getValue();
            return EnigmaticItems.SOUL_CRYSTAL.getLostCrystals(player) < maxCrystalLoss;
        }
        return false;
    }

    public static ServerLevel getWorld(ResourceKey<Level> key) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(key);
    }

    public static ServerLevel getOverworld() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.PROXY.getOverworldKey());
    }

    public static ServerLevel getNether() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.PROXY.getNetherKey());
    }

    public static ServerLevel getEnd() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.PROXY.getEndKey());
    }

    public static void sendToDimension(ServerPlayer player, ResourceKey<Level> dimension, ITeleporter teleporter) {
        ServerLevel world;
        if (!player.f_19853_.m_46472_().equals(dimension) && (world = SuperpositionHandler.getWorld(dimension)) != null) {
            player.changeDimension(world, teleporter);
        }
    }

    public static void sendToDimension(ServerPlayer player, ResourceKey<Level> dimension) {
        SuperpositionHandler.sendToDimension(player, dimension, new RealSmoothTeleporter());
    }

    public static ServerLevel backToSpawn(ServerPlayer serverPlayer) {
        ServerLevel destinationWorld;
        ResourceKey<Level> respawnDimension = AdvancedSpawnLocationHelper.getPlayerRespawnDimension(serverPlayer);
        ServerLevel respawnWorld = SuperpositionHandler.getWorld(respawnDimension);
        serverPlayer.f_19853_.m_5594_(null, serverPlayer.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 128.0, serverPlayer.f_19853_.m_46472_())), (Object)new PacketPortalParticles(serverPlayer.m_20185_(), serverPlayer.m_20186_() + (double)(serverPlayer.m_20206_() / 2.0f), serverPlayer.m_20189_(), 100, 1.25, false));
        Optional<Vec3> vec = AdvancedSpawnLocationHelper.getValidSpawn(respawnWorld, serverPlayer);
        ServerLevel serverLevel = destinationWorld = vec.isPresent() ? respawnWorld : serverPlayer.f_8924_.m_129783_();
        if (!serverPlayer.m_9236_().equals(destinationWorld)) {
            serverPlayer.changeDimension(destinationWorld, (ITeleporter)new RealSmoothTeleporter());
        }
        Optional<Object> vec2 = !respawnWorld.equals(destinationWorld) ? AdvancedSpawnLocationHelper.getValidSpawn(destinationWorld, serverPlayer) : Optional.empty();
        if (vec.isPresent()) {
            Vec3 trueVec = vec.get();
            serverPlayer.m_6021_(trueVec.f_82479_, trueVec.f_82480_, trueVec.f_82481_);
        } else if (vec2.isPresent()) {
            Vec3 trueVec = (Vec3)vec2.get();
            serverPlayer.m_6021_(trueVec.f_82479_, trueVec.f_82480_, trueVec.f_82481_);
        } else {
            AdvancedSpawnLocationHelper.fuckBackToSpawn(serverPlayer.m_9236_(), serverPlayer);
        }
        serverPlayer.f_19853_.m_5594_(null, serverPlayer.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 128.0, serverPlayer.f_19853_.m_46472_())), (Object)new PacketRecallParticles(serverPlayer.m_20185_(), serverPlayer.m_20186_() + (double)(serverPlayer.m_20206_() / 2.0f), serverPlayer.m_20189_(), 48, false));
        return destinationWorld;
    }

    public static DimensionalPosition getRespawnPoint(ServerPlayer serverPlayer) {
        Vec3 trueVec;
        ResourceKey<Level> respawnDimension = AdvancedSpawnLocationHelper.getPlayerRespawnDimension(serverPlayer);
        ServerLevel respawnWorld = SuperpositionHandler.getWorld(respawnDimension);
        Optional<Vec3> currentDimensionRespawnCoords = AdvancedSpawnLocationHelper.getValidSpawn(respawnWorld, serverPlayer);
        ServerLevel destinationWorld = currentDimensionRespawnCoords.isPresent() ? respawnWorld : serverPlayer.f_8924_.m_129783_();
        Optional<Object> destinationDimensionRespawnCoords = !respawnWorld.equals(destinationWorld) ? AdvancedSpawnLocationHelper.getValidSpawn(destinationWorld, serverPlayer) : Optional.empty();
        if (currentDimensionRespawnCoords.isPresent()) {
            trueVec = currentDimensionRespawnCoords.get();
        } else if (destinationDimensionRespawnCoords.isPresent()) {
            trueVec = (Vec3)destinationDimensionRespawnCoords.get();
        } else {
            trueVec = new Vec3((double)destinationWorld.m_220360_().m_123341_() + 0.5, (double)destinationWorld.m_220360_().m_123342_() + 0.5, (double)destinationWorld.m_220360_().m_123343_() + 0.5);
            while (!destinationWorld.m_8055_(new BlockPos(trueVec)).m_60795_() && trueVec.f_82480_ < 255.0) {
                trueVec = trueVec.m_82520_(0.0, 1.0, 0.0);
            }
        }
        return new DimensionalPosition(trueVec.f_82479_, trueVec.f_82480_, trueVec.f_82481_, (Level)destinationWorld);
    }

    public static void removeAttributeMap(Player player, Multimap<Attribute, AttributeModifier> attributes) {
        AttributeMap map = player.m_21204_();
        map.m_22161_(attributes);
    }

    public static void applyAttributeMap(Player player, Multimap<Attribute, AttributeModifier> attributes) {
        AttributeMap map = player.m_21204_();
        map.m_22178_(attributes);
    }

    public static boolean isTheCursedOne(Player player) {
        return SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticItems.CURSED_RING);
    }

    public static boolean isTheBlessedOne(Player player) {
        if (EnigmaticLegacy.SOUL_OF_THE_ARCHITECT.equals(player.m_20148_())) {
            return true;
        }
        return DevotedBelieversHandler.isDevotedBeliever(player);
    }

    public static boolean hasArchitectsFavor(Player player) {
        return SuperpositionHandler.isTheBlessedOne(player) && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticItems.COSMIC_SCROLL);
    }

    public static boolean isTheWorthyOne(Player player) {
        if (SuperpositionHandler.isTheCursedOne(player)) {
            IPlaytimeCounter counter = IPlaytimeCounter.get(player);
            long timeWithRing = counter.getTimeWithCurses();
            long timeWithoutRing = counter.getTimeWithoutCurses();
            if (timeWithRing <= 0L) {
                return false;
            }
            if (timeWithoutRing <= 0L) {
                return true;
            }
            return timeWithRing / timeWithoutRing >= 199L;
        }
        return false;
    }

    public static String getSufferingTime(@Nullable Player player) {
        if (player == null) {
            return "0%";
        }
        IPlaytimeCounter counter = IPlaytimeCounter.get(player);
        long timeWithRing = counter.getTimeWithCurses();
        long timeWithoutRing = counter.getTimeWithoutCurses();
        if (timeWithRing <= 0L) {
            return "0%";
        }
        if (timeWithoutRing <= 0L) {
            return "100%";
        }
        if (timeWithRing > 100000L || timeWithoutRing > 100000L) {
            timeWithoutRing /= 100L;
            if ((timeWithRing /= 100L) <= 0L) {
                return "0%";
            }
            if (timeWithoutRing <= 0L) {
                return "100%";
            }
        }
        double total = timeWithRing + timeWithoutRing;
        double ringPercent = (double)timeWithRing / total * 100.0;
        ringPercent = (double)Math.round(ringPercent * 10.0) / 10.0;
        Object text = "";
        text = ringPercent - (double)Math.round(ringPercent) == 0.0 ? (String)text + (int)ringPercent + "%" : (String)text + ringPercent + "%";
        if ("99.5%".equals(text) && !SuperpositionHandler.isTheWorthyOne(player)) {
            text = "99.4%";
        }
        return text;
    }

    public static float getMissingHealthPool(Player player) {
        return (player.m_21233_() - Math.min(player.m_21223_(), player.m_21233_())) / player.m_21233_();
    }

    public static int getCurseAmount(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int totalCurses = 0;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!enchantment.m_6589_() || (Integer)enchantments.get(enchantment) <= 0) continue;
            ++totalCurses;
        }
        if (stack.m_41720_() == EnigmaticItems.CURSED_RING) {
            totalCurses += 7;
        }
        return totalCurses;
    }

    public static int getCurseAmount(Player player) {
        int count = 0;
        boolean ringCounted = false;
        for (ItemStack theStack : SuperpositionHandler.getFullEquipment(player)) {
            if (theStack == null || theStack.m_41720_() == EnigmaticItems.CURSED_RING && ringCounted) continue;
            count += SuperpositionHandler.getCurseAmount(theStack);
            if (theStack.m_41720_() != EnigmaticItems.CURSED_RING) continue;
            ringCounted = true;
        }
        return count;
    }

    public static List<ItemStack> getFullEquipment(Player player) {
        ArrayList equipmentStacks = Lists.newArrayList();
        equipmentStacks.add(player.m_21205_());
        equipmentStacks.add(player.m_21206_());
        equipmentStacks.addAll(player.m_150109_().f_35975_);
        if (CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    equipmentStacks.add(stack);
                }
            }
        }
        return equipmentStacks;
    }

    public static double sinFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        coef *= 90.0;
        coef = Math.toRadians(coef);
        double func = Math.pow(Math.sin(coef), -1.0);
        return Math.pow(Math.sin(coef), -1.0);
    }

    public static double parabolicFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        double func = Math.pow(coef, 2.0);
        return func;
    }

    public static double flippedParabolicFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        double func = Math.pow(coef - 1.0, 2.0);
        return 1.0 - func;
    }

    public static boolean hasAnyArmor(LivingEntity entity) {
        int armorAmount = 0;
        for (ItemStack stack : entity.m_6168_()) {
            if (stack.m_41619_()) continue;
            if (GolemHeart.EXCLUDED_ARMOR.stream().anyMatch(arg_0 -> ((ItemStack)stack).m_150930_(arg_0))) continue;
            ++armorAmount;
        }
        return armorAmount != 0;
    }

    public static boolean areWeDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static boolean areWeRemoteServer(Player player) {
        if (SuperpositionHandler.areWeDedicatedServer()) {
            return true;
        }
        return player.m_20194_() != null && !player.m_20194_().m_7779_(player.m_36316_());
    }

    public static void executeOnServer(Consumer<MinecraftServer> action) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            action.accept(ServerLifecycleHooks.getCurrentServer());
        }
    }

    public static List<ModFileScanData.AnnotationData> retainAnnotations(String modid, Class<?> annotationClass) {
        ModFileScanData modFileInfo = ModList.get().getModFileById(modid).getFile().getScanResult();
        ArrayList<ModFileScanData.AnnotationData> list = new ArrayList<ModFileScanData.AnnotationData>();
        for (ModFileScanData.AnnotationData annotation : modFileInfo.getAnnotations()) {
            if (!annotation.annotationType().getClassName().equals(annotationClass.getName())) continue;
            list.add(annotation);
        }
        return list;
    }

    public static List<ModFileScanData.AnnotationData> retainConfigurableItemAnnotations(String modid) {
        return SuperpositionHandler.retainAnnotations(modid, ConfigurableItem.class);
    }

    public static List<ModFileScanData.AnnotationData> retainConfigHolderAnnotations(String modid) {
        return SuperpositionHandler.retainAnnotations(modid, SubscribeConfig.class);
    }

    public static void dispatchWrapperToHolders(String modid, OmniconfigWrapper wrapper) {
        for (ModFileScanData.AnnotationData annotationData : SuperpositionHandler.retainConfigHolderAnnotations(modid)) {
            try {
                Class<?> retainerClass = Class.forName(annotationData.clazz().getClassName());
                String methodName = annotationData.memberName().split("\\(")[0];
                boolean receiveClient = annotationData.annotationData().get("receiveClient") != null ? (Boolean)annotationData.annotationData().get("receiveClient") : false;
                Method method = retainerClass.getDeclaredMethod(methodName, OmniconfigWrapper.class);
                if (wrapper.config.getSidedType() == Configuration.SidedConfigType.CLIENT && !receiveClient) continue;
                method.invoke(null, wrapper);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Multimap<String, Field> retainAccessibilityGeneratorMap(String modid) {
        HashMultimap accessibilityGeneratorMap = HashMultimap.create();
        for (ModFileScanData.AnnotationData annotationData : SuperpositionHandler.retainConfigurableItemAnnotations(modid)) {
            try {
                Class<?> retainerClass = Class.forName(annotationData.clazz().getClassName());
                String itemName = (String)annotationData.annotationData().get("value");
                String fieldName = annotationData.memberName();
                Field field = retainerClass.getDeclaredField(fieldName);
                if (itemName == null || itemName.isEmpty()) continue;
                accessibilityGeneratorMap.put((Object)itemName, (Object)field);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return accessibilityGeneratorMap;
    }

    public static boolean hasAntiInsectAcknowledgement(Player player) {
        ArrayList heldItems = Lists.newArrayList((Object[])new ItemStack[]{player.m_21205_(), player.m_21206_()});
        for (ItemStack held : heldItems) {
            if (held == null || !(held.m_41720_() instanceof TheAcknowledgment) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)held) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaringAt(Player player, LivingEntity living) {
        Vec3 vector3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vector3d1 = new Vec3(living.m_20185_() - player.m_20185_(), living.m_20188_() - player.m_20188_(), living.m_20189_() - player.m_20189_());
        double d0 = vector3d1.m_82553_();
        double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? player.m_142582_((Entity)living) : false;
    }

    public static double getRandomNegative() {
        return (Math.random() - 0.5) * 2.0;
    }

    public static String minimizeNumber(double num) {
        int intg = (int)num;
        if (num - (double)intg == 0.0) {
            return "" + intg;
        }
        return "" + num;
    }

    public static Optional<Tuple<UUID, BlockPos>> updateSoulCompass(ServerPlayer player) {
        Optional<Tuple<UUID, BlockPos>> optional = SoulArchive.getInstance().findNearest(player.f_19853_, player.m_20183_());
        boolean noValid = optional.isEmpty();
        BlockPos pos = noValid ? BlockPos.f_121853_ : (BlockPos)optional.get().m_14419_();
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketUpdateCompass(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), noValid));
        EnigmaticEventHandler.LAST_SOUL_COMPASS_UPDATE.put((Player)player, player.f_19797_);
        return optional;
    }

    public static ItemStack mergeEnchantments(ItemStack input, ItemStack mergeFrom, boolean overmerge, boolean onlyTreasure) {
        ItemStack returnedStack = input.m_41777_();
        Map inputEnchants = EnchantmentHelper.m_44831_((ItemStack)returnedStack);
        Map mergedEnchants = EnchantmentHelper.m_44831_((ItemStack)mergeFrom);
        for (Enchantment mergedEnchant : mergedEnchants.keySet()) {
            if (mergedEnchant == null) continue;
            int inputEnchantLevel = inputEnchants.getOrDefault(mergedEnchant, 0);
            int mergedEnchantLevel = (Integer)mergedEnchants.get(mergedEnchant);
            if (!overmerge) {
                mergedEnchantLevel = inputEnchantLevel == mergedEnchantLevel ? (mergedEnchantLevel + 1 > mergedEnchant.m_6586_() ? mergedEnchant.m_6586_() : mergedEnchantLevel + 1) : Math.max(mergedEnchantLevel, inputEnchantLevel);
            } else {
                mergedEnchantLevel = inputEnchantLevel > 0 ? Math.max(mergedEnchantLevel, inputEnchantLevel) + 1 : Math.max(mergedEnchantLevel, inputEnchantLevel);
                mergedEnchantLevel = Math.min(mergedEnchantLevel, 10);
            }
            boolean compatible = mergedEnchant.m_6081_(input);
            if (input.m_41720_() instanceof EnchantedBookItem) {
                compatible = true;
            }
            for (Enchantment originalEnchant : inputEnchants.keySet()) {
                if (originalEnchant == mergedEnchant || mergedEnchant.m_44695_(originalEnchant)) continue;
                compatible = false;
            }
            if (!compatible || onlyTreasure && !mergedEnchant.m_6591_() && !mergedEnchant.m_6589_()) continue;
            inputEnchants.put(mergedEnchant, mergedEnchantLevel);
        }
        EnchantmentHelper.m_44865_((Map)inputEnchants, (ItemStack)returnedStack);
        return returnedStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int greatestWidth(Font font, String[] lines) {
        return Arrays.stream(lines).mapToInt(arg_0 -> ((Font)font).m_92895_(arg_0)).reduce((num1, num2) -> num1 > num2 ? num1 : num2).getAsInt();
    }

    public static boolean hasEnigmaticElytra(LivingEntity living) {
        return SuperpositionHandler.getEnigmaticElytra(living) != null;
    }

    @Nullable
    public static ItemStack getEnigmaticElytra(LivingEntity living) {
        ItemStack stack = living.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_150930_((Item)EnigmaticItems.ENIGMATIC_ELYTRA)) {
            return stack;
        }
        return SuperpositionHandler.getCurioStack(living, EnigmaticItems.ENIGMATIC_ELYTRA);
    }

    public static ItemStack maybeApplyEternalBinding(ItemStack stack) {
        if (Math.random() < 0.5 && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44975_, (ItemStack)stack) > 0) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
            map.remove(Enchantments.f_44963_);
            int level = (Integer)map.remove(Enchantments.f_44975_);
            map.put(EnigmaticEnchantments.ETERNAL_BINDING, level);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
        }
        return stack;
    }

    public static boolean canUnequipBoundRelics(Player player) {
        return player.m_7500_() || EnigmaticLegacy.SOUL_OF_THE_ARCHITECT.equals(player.m_20148_());
    }

    public static void onDamageSourceBlocking(LivingEntity blocker, ItemStack useItem, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        if (blocker instanceof Player) {
            boolean blocking;
            Player player = (Player)blocker;
            if (useItem != null && (blocking = ((IProperShieldUser)blocker).isActuallyReallyBlocking()) && useItem.m_41720_() instanceof InfernalShield) {
                Vec3 sourcePos;
                AbstractArrow abstractarrow;
                boolean piercingArrow = false;
                Entity entity = source.m_7640_();
                if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_36796_() > 0) {
                    piercingArrow = true;
                }
                piercingArrow = false;
                if (!source.m_19376_() && ((IProperShieldUser)blocker).isActuallyReallyBlocking() && !piercingArrow && (sourcePos = source.m_7270_()) != null) {
                    Vec3 lookVec = blocker.m_20252_(1.0f);
                    Vec3 sourceToSelf = sourcePos.m_82505_(blocker.m_20182_()).m_82541_();
                    sourceToSelf = new Vec3(sourceToSelf.f_82479_, 0.0, sourceToSelf.f_82481_);
                    if (sourceToSelf.m_82526_(lookVec) < 0.0) {
                        StackTraceElement[] stacktrace;
                        LivingEntity living;
                        info.setReturnValue((Object)true);
                        int strength = -1;
                        if (player.m_21023_((MobEffect)EnigmaticEffects.BLAZING_STRENGTH)) {
                            MobEffectInstance effectInstance = player.m_21124_((MobEffect)EnigmaticEffects.BLAZING_STRENGTH);
                            strength = effectInstance.m_19564_();
                            player.m_21195_((MobEffect)EnigmaticEffects.BLAZING_STRENGTH);
                            strength = strength > 2 ? 2 : strength;
                        }
                        player.m_7292_(new MobEffectInstance((MobEffect)EnigmaticEffects.BLAZING_STRENGTH, 1200, strength + 1, true, true));
                        Entity entity2 = source.m_7640_();
                        if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).m_6084_() && !living.m_5825_() && !(living instanceof Guardian) && Arrays.stream(stacktrace = Thread.currentThread().getStackTrace()).filter(element -> SuperpositionHandler.class.getName().equals(element.getClassName())).count() < 2L) {
                            living.f_19802_ = 0;
                            living.m_6469_((DamageSource)new EntityDamageSource(DamageSource.f_19307_.f_19326_, (Entity)player), 4.0f);
                            living.m_20254_(4);
                            EnigmaticEventHandler.KNOCKBACK_THAT_BASTARD.remove(living);
                        }
                        return;
                    }
                }
                info.setReturnValue((Object)false);
                return;
            }
        }
    }

    public static <K, V extends Comparable<? super V>> void sortByKey(Map<K, V> map) {
        ArrayList list = new ArrayList(map.entrySet());
        list.sort(Map.Entry.comparingByKey());
        map.clear();
        for (Map.Entry entry : list) {
            map.put(entry.getKey(), (Comparable)entry.getValue());
        }
    }

    private static boolean contains(char[] array, char ch) {
        for (char ach : array) {
            if (ach != ch) continue;
            return true;
        }
        return false;
    }

    public static String obscureString(String string) {
        char[] oldArray = string.toCharArray();
        char[] newArray = new char[oldArray.length];
        boolean code = false;
        for (int i = 0; i < oldArray.length; ++i) {
            char ch;
            newArray[i] = ch = oldArray[i];
            if (ch == '\u00a7') {
                code = true;
                continue;
            }
            if (code) {
                code = false;
                continue;
            }
            if (ch == ' ') continue;
            char[] replacements = null;
            replacements = SuperpositionHandler.contains(UPPERCASE_LETTERS, ch) ? UPPERCASE_LETTERS : (SuperpositionHandler.contains(LOWERCASE_LETTERS, ch) ? LOWERCASE_LETTERS : (SuperpositionHandler.contains(NUMBERS, ch) ? NUMBERS : SPECIAL_SYMBOLS));
            newArray[i] = ch = replacements[RANDOM.nextInt(replacements.length)];
        }
        return new String(newArray);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void obscureTooltip(List<Component> tooltip) {
        tooltip.replaceAll(component -> Component.m_237113_((String)SuperpositionHandler.obscureString(component.getString())).m_130948_(component.m_7383_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String[] wrapString(String string, Font font, int width) {
        List list = font.m_92865_().m_92432_(string, width, Style.f_131099_);
        String[] lines = new String[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            FormattedText text = (FormattedText)list.get(i);
            lines[i] = text.getString();
        }
        return lines;
    }

    @SafeVarargs
    public static <T> T getRandomElement(List<T> list, T ... excluding) {
        ArrayList<T> filtered = new ArrayList<T>(list);
        Arrays.stream(excluding).forEach(filtered::remove);
        if (filtered.size() <= 0) {
            throw new IllegalArgumentException("List has no valid elements to choose");
        }
        if (filtered.size() == 1) {
            return (T)filtered.get(0);
        }
        return (T)filtered.get(RANDOM.nextInt(filtered.size()));
    }

    public static String getMD5Hash(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(string.getBytes());
            return SuperpositionHandler.bytesToHex(md.digest()).toUpperCase();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderInsigniaNameplate(Entity entity, Component name, PoseStack stack, MultiBufferSource buffer, int packedLight, EntityRenderDispatcher entityRenderDispatcher, Font font) {
        double d0 = entityRenderDispatcher.m_114471_(entity);
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)d0)) {
            boolean render = font.m_92852_((FormattedText)name) > 0;
            boolean override = false;
            if (!render && entity != Minecraft.m_91087_().f_91074_ && EnigmaticItems.INSIGNIA.canSeeTrueName((Player)Minecraft.m_91087_().f_91074_)) {
                name = entity.m_5446_();
                override = true;
                render = true;
            }
            boolean discrete = !entity.m_20163_();
            float f = entity.m_20206_() + 0.5f;
            int i = 0;
            stack.m_85836_();
            stack.m_85837_(0.0, (double)f, 0.0);
            stack.m_85845_(entityRenderDispatcher.m_114470_());
            stack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = stack.m_85850_().m_85861_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            float f2 = -font.m_92852_((FormattedText)name) / 2;
            if (render) {
                font.m_92841_(name, f2, (float)i, 0x20FFFFFF, false, matrix4f, buffer, discrete, j, packedLight);
                if (discrete) {
                    font.m_92841_(name, f2, (float)i, -1, false, matrix4f, buffer, false, 0, packedLight);
                }
            }
            if (!override && entity != Minecraft.m_91087_().f_91074_ && EnigmaticItems.INSIGNIA.canSeeTrueName((Player)Minecraft.m_91087_().f_91074_)) {
                stack.m_85836_();
                name = Component.m_237113_((String)("(" + entity.m_5446_().getString() + ")"));
                f2 = -font.m_92852_((FormattedText)name) / 2;
                float scale = 0.4f;
                int offset = (int)(-10.0f * (1.0f / scale));
                stack.m_85841_(scale, scale, scale);
                matrix4f = stack.m_85850_().m_85861_();
                font.m_92841_(name, f2, (float)(i - offset), 0x20FFFFFF, false, matrix4f, buffer, discrete, j, packedLight);
                if (discrete) {
                    font.m_92841_(name, f2, (float)(i - offset), -1, false, matrix4f, buffer, false, 0, packedLight);
                }
                stack.m_85849_();
            }
            stack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static File getSaveFolder(LevelSummary summary) {
        LevelStorageSource levels = Minecraft.m_91087_().m_91392_();
        return new File(levels.m_78257_().toFile(), summary.m_78358_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Component getAltInfo(LevelSummary summary) {
        Component info = summary.m_78376_();
        File world = SuperpositionHandler.getSaveFolder(summary);
        boolean fractured = SuperpositionHandler.isWorldFractured(world);
        if (summary.m_78367_() == GameType.SURVIVAL || fractured) {
            Object key = "gameMode.enigmaticlegacy.";
            if (fractured) {
                key = (String)key + "fractured";
            } else if (SuperpositionHandler.isWorldCursed(world)) {
                key = (String)key + "cursed";
                if (summary.m_78368_()) {
                    key = (String)key + "Hardcore";
                }
            } else {
                return info;
            }
            MutableComponent tcn = Component.m_237115_((String)key);
            tcn.m_130948_(info.m_7383_());
            if (info instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)info;
                if (mutable.m_214077_() instanceof TranslatableContents) {
                    info.m_7360_().forEach(arg_0 -> ((MutableComponent)tcn).m_7220_(arg_0));
                } else if (mutable.m_214077_() instanceof LiteralContents) {
                    for (int i = 1; i < info.m_7360_().size(); ++i) {
                        tcn.m_7220_((Component)info.m_7360_().get(i));
                    }
                }
            }
            return tcn;
        }
        return info;
    }

    public static Item findItem(String namespace, String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, name));
    }

    public static Optional<MinecraftServer> getSingleplayerServer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_129792_() && Objects.equal((Object)server.m_236731_().getName(), (Object)EnigmaticLegacy.PROXY.getClientUsername())) {
            return Optional.of(server);
        }
        return Optional.empty();
    }

    public static void setCurrentWorldCursed(boolean cursed) {
        SuperpositionHandler.getSingleplayerServer().ifPresent(server -> {
            File saveFolder = server.m_129843_(LevelResource.f_78182_).toFile();
            EnigmaticTransience transience = EnigmaticTransience.read(saveFolder);
            transience.setCursed(cursed);
            transience.write(saveFolder);
        });
    }

    public static void setCurrentWorldFractured(boolean fractured) {
        SuperpositionHandler.getSingleplayerServer().ifPresent(server -> {
            File saveFolder = server.m_129843_(LevelResource.f_78182_).toFile();
            EnigmaticTransience transience = EnigmaticTransience.read(saveFolder);
            transience.setPermanentlyDead(fractured);
            transience.write(saveFolder);
        });
    }

    public static boolean isWorldCursed(File world) {
        return EnigmaticTransience.read(world).isCursed();
    }

    public static boolean isWorldFractured(File world) {
        return EnigmaticTransience.read(world).isPermanentlyDead();
    }
}

