/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.etherium.core;

import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.etherium.core.IEtheriumConfig;
import com.aizistral.etherium.items.EtheriumArmor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EtheriumEventHandler {
    private final IEtheriumConfig config;
    private final Item etheriumOre;

    public EtheriumEventHandler(IEtheriumConfig config, Item etheriumOre) {
        this.config = config;
        this.etheriumOre = etheriumOre;
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getAmount() > 0.0f && EtheriumArmor.hasShield(player)) {
                if (event.getSource().m_7640_() instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
                    Vector3 vec = Vector3.fromEntityCenter((Entity)player).subtract(Vector3.fromEntityCenter(event.getSource().m_7639_())).normalize();
                    attacker.m_147240_(0.75, vec.x, vec.z);
                    player.f_19853_.m_5594_(null, player.m_20183_(), this.config.getShieldTriggerSound(), SoundSource.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                    player.f_19853_.m_5594_(null, player.m_20183_(), this.config.getShieldTriggerSound(), SoundSource.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                }
                event.setAmount(event.getAmount() * this.config.getShieldReduction().asModifierInverted());
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if ((event.getSource().m_7640_() instanceof AbstractHurtingProjectile || event.getSource().m_7640_() instanceof AbstractArrow) && EtheriumArmor.hasShield(player)) {
                event.setCanceled(true);
                player.f_19853_.m_5594_(null, player.m_20183_(), this.config.getShieldTriggerSound(), SoundSource.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTablesLoaded(LootTableLoadEvent event) {
        if (!this.config.isStandalone()) {
            return;
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78741_)) {
            LootPool epic = EtheriumEventHandler.constructLootPool("etherium", -11.0f, 2.0f, new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)this.etheriumOre).m_79707_(60).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))});
            LootTable modified = event.getTable();
            modified.addPool(epic);
            event.setTable(modified);
        }
    }

    private static LootPool constructLootPool(String poolName, float minRolls, float maxRolls, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder poolBuilder = LootPool.m_79043_();
        poolBuilder.name(poolName);
        poolBuilder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minRolls, (float)maxRolls));
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            if (entry == null) continue;
            poolBuilder.m_79076_(entry);
        }
        LootPool constructedPool = poolBuilder.m_79082_();
        return constructedPool;
    }
}

