/*
 * Decompiled with CFR 0.152.
 */
package de.isuewo.euphoria_patcher;

import com.mojang.logging.LogUtils;
import de.isuewo.euphoria_patcher.ArchiveUtils;
import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@Mod(value="euphoria_patcher")
public class EuphoriaPatcher {
    public static final String MODID = "euphoria_patcher";
    public static final Logger LOGGER = LogUtils.getLogger();

    public EuphoriaPatcher() {
        Path temp;
        boolean isAlreadyInstalled;
        boolean styleUnbound;
        boolean styleReimagined;
        Path baseFile;
        Path shaderpacks;
        block58: {
            shaderpacks = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
            String downloadURL = "https://www.complementary.dev/";
            String brandName = "ComplementaryShaders";
            String version = "_r5.1.1";
            String patchName = "EuphoriaPatches";
            String patchVersion = "_1.2";
            String commonLocation = "shaders/lib/common.glsl";
            baseFile = null;
            styleReimagined = false;
            styleUnbound = false;
            isAlreadyInstalled = false;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, path -> {
                String name = path.getFileName().toString();
                return name.matches("Complementary.+?(?=_r5.1.1)_r5.1.1(?!\\.[0-9]).*") && name.endsWith(".zip") && !name.contains("EuphoriaPatches");
            });){
                for (Path path2 : stream) {
                    String name = path2.getFileName().toString();
                    if (!name.endsWith(".zip")) continue;
                    if (name.contains("Reimagined")) {
                        styleReimagined = true;
                        if (baseFile == null) {
                            baseFile = path2;
                        }
                    } else if (name.contains("Unbound")) {
                        styleUnbound = true;
                        if (baseFile == null) {
                            baseFile = path2;
                        }
                    }
                    if (baseFile != null && Files.exists(shaderpacks.resolve(baseFile.getFileName().toString().replace(".zip", "") + " + EuphoriaPatches_1.2"), new LinkOption[0])) {
                        baseFile = null;
                        isAlreadyInstalled = true;
                    }
                    if (!styleReimagined || !styleUnbound) continue;
                    break;
                }
                if (styleReimagined || styleUnbound) break block58;
                try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(shaderpacks, path -> {
                    String name = path.getFileName().toString();
                    return name.matches("Complementary.+?(?=_r5.1.1)_r5.1.1(?!\\.[0-9]).*") && Files.isDirectory(path, new LinkOption[0]);
                });){
                    for (Path potentialFile : stream2) {
                        String name = potentialFile.getFileName().toString();
                        if (name.contains("EuphoriaPatches")) {
                            if (!name.contains("EuphoriaPatches_1.2")) continue;
                            isAlreadyInstalled = true;
                            continue;
                        }
                        if (name.contains("Reimagined")) {
                            styleReimagined = true;
                            if (baseFile == null) {
                                baseFile = potentialFile;
                            }
                        } else if (name.contains("Unbound")) {
                            styleUnbound = true;
                            if (baseFile == null) {
                                baseFile = potentialFile;
                            }
                        }
                        if (!styleReimagined || !styleUnbound) continue;
                        break;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading shaderpacks directory" + e.getMessage());
                return;
            }
        }
        if (baseFile == null) {
            if (!isAlreadyInstalled) {
                LOGGER.info("You need to have ComplementaryShaders_r5.1.1 installed. Please download it from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
            }
            return;
        }
        try {
            temp = Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error creating temporary directory" + e.getMessage());
            return;
        }
        String baseName = baseFile.getFileName().toString().replace(".zip", "");
        String string = baseName + " + EuphoriaPatches_1.2";
        Path baseExtracted = temp.resolve(baseName);
        if (!Files.isDirectory(baseFile, new LinkOption[0])) {
            try {
                ArchiveUtils.extract(baseFile, baseExtracted);
            }
            catch (IOException | ArchiveException e) {
                LOGGER.error("Error extracting shaderpack" + e.getMessage());
                return;
            }
        } else {
            baseExtracted = baseFile;
        }
        try {
            Path commons = baseExtracted.resolve("shaders/lib/common.glsl");
            String config = FileUtils.readFileToString((File)commons.toFile(), (String)"UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile((File)commons.toFile(), (String)config, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error("Error extracting style information from " + baseName + e.getMessage());
            return;
        }
        String baseTarHash = "b5493f3d688e26814a04c6b1708adeb0";
        int baseTarSize = 0x115000;
        Path baseArchived = temp.resolve(baseName + ".tar");
        try {
            ArchiveUtils.archive(baseExtracted, baseArchived);
        }
        catch (IOException e) {
            LOGGER.info("Error archiving shaderpack" + e.getMessage());
            return;
        }
        Path patchedFile = shaderpacks.resolve(string);
        try {
            String hash = DigestUtils.md5Hex((byte[])Arrays.copyOf(Files.readAllBytes(baseArchived), 0x115000));
            if (!hash.equals("b5493f3d688e26814a04c6b1708adeb0")) {
                LOGGER.info("The version of ComplementaryShaders that was found in your shaderpacks can't be used as a base for EuphoriaPatches. Please download ComplementaryShaders_r5.1.1 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
                return;
            }
        }
        catch (IOException e) {
            LOGGER.info("The version of ComplementaryShaders that was found in your shaderpacks can't be used as a base for EuphoriaPatches. Please download ComplementaryShaders_r5.1.1 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft." + e.getMessage());
            return;
        }
        Path patchedArchive = temp.resolve(string + ".tar");
        Path patchFile = temp.resolve(string + ".patch");
        try (InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream("EuphoriaPatches_1.2.patch");){
            FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(patchStream), (File)patchFile.toFile());
            FileUI.patch(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
            ArchiveUtils.extract(patchedArchive, patchedFile);
        }
        catch (InvalidHeaderException | IOException | ArchiveException | CompressorException e) {
            LOGGER.error("Error applying patch file." + e.getMessage());
            return;
        }
        if (styleUnbound) {
            try {
                File commons = new File(patchedFile.toFile(), "shaders/lib/common.glsl");
                String UnboundConfig = FileUtils.readFileToString((File)commons, (String)"UTF-8").replaceFirst("SHADER_STYLE 1", "SHADER_STYLE 4");
                if (!styleReimagined) {
                    FileUtils.writeStringToFile((File)commons, (String)UnboundConfig, (String)"UTF-8");
                } else if (baseName.contains("Reimagined")) {
                    File unbound = new File(shaderpacks.toFile(), string.replace("Reimagined", "Unbound"));
                    FileUtils.copyDirectory((File)patchedFile.toFile(), (File)unbound);
                    FileUtils.writeStringToFile((File)new File(unbound, "shaders/lib/common.glsl"), (String)UnboundConfig, (String)"UTF-8");
                } else {
                    File reimagined = new File(shaderpacks.toFile(), string.replace("Unbound", "Reimagined"));
                    FileUtils.copyDirectory((File)patchedFile.toFile(), (File)reimagined);
                    FileUtils.writeStringToFile((File)commons, (String)UnboundConfig, (String)"UTF-8");
                }
            }
            catch (IOException e) {
                LOGGER.error("Error applying style settings." + e.getMessage());
                return;
            }
        }
        LOGGER.info("EuphoriaPatches was successfully installed. Enjoy! -SpacEagle17 & isuewo");
    }
}

