/*
 * Decompiled with CFR 0.152.
 */
package de.isuewo.euphoria_patcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ArchiveUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extract(Path in, Path out) {
        try (ArchiveInputStream ai = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(in, new OpenOption[0])));){
            ArchiveEntry entry;
            while ((entry = ai.getNextEntry()) != null) {
                if (!ai.canReadEntryData(entry)) continue;
                Path targetFilePath = out.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(targetFilePath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                OutputStream o = Files.newOutputStream(targetFilePath, new OpenOption[0]);
                try {
                    IOUtils.copy((InputStream)ai, (OutputStream)o);
                }
                finally {
                    if (o == null) continue;
                    o.close();
                }
            }
            return;
        }
        catch (IOException | ArchiveException e) {
            e.printStackTrace();
        }
    }

    public static void archive(Path sourceDir, Path archive) {
        try (TarArchiveOutputStream o = new TarArchiveOutputStream(Files.newOutputStream(archive, new OpenOption[0]));){
            try (Stream<Path> walk = Files.walk(sourceDir, new FileVisitOption[0]);){
                walk.sorted(Comparator.comparing(Path::toUri)).forEach(f -> {
                    String fileName = sourceDir.relativize((Path)f).toString().replace(File.separatorChar, '/');
                    TarArchiveEntry entry = new TarArchiveEntry(f.toFile(), fileName);
                    entry.setModTime(0L);
                    entry.setIds(0, 0);
                    entry.setNames("", "");
                    try {
                        o.putArchiveEntry((ArchiveEntry)entry);
                        if (Files.isRegularFile(f, new LinkOption[0])) {
                            try (InputStream i = Files.newInputStream(f, new OpenOption[0]);){
                                IOUtils.copy((InputStream)i, (OutputStream)o);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        o.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            o.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

