/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import umpaz.farmersrespite.client.gui.KettleRecipeBookComponent;
import umpaz.farmersrespite.common.block.entity.container.KettleMenu;
import umpaz.farmersrespite.common.utility.FRTextUtils;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
public class KettleScreen
extends AbstractContainerScreen<KettleMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("farmersrespite", "textures/gui/kettle.png");
    private static final Rectangle HEAT_ICON = new Rectangle(41, 55, 17, 15);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(62, 25, 0, 17);
    private static final Rectangle WATER_BAR1 = new Rectangle(34, 38, 5, 11);
    private static final Rectangle WATER_BAR2 = new Rectangle(34, 28, 5, 10);
    private static final Rectangle WATER_BAR3 = new Rectangle(34, 17, 5, 12);
    private final KettleRecipeBookComponent recipeBookComponent = new KettleRecipeBookComponent();
    private boolean widthTooNarrow;

    public KettleScreen(KettleMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.f_97728_ = 35;
        this.recipeBookComponent.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrow, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
        if (((Boolean)Configuration.ENABLE_RECIPE_BOOK_COOKING_POT.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 8, this.f_96544_ / 2 - 48, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, button -> {
                this.recipeBookComponent.m_100384_();
                this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
                ((ImageButton)button).m_94278_(this.f_97735_ + 8, this.f_96544_ / 2 - 48);
            }));
        } else {
            this.recipeBookComponent.hide();
            this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
        }
        this.m_7787_((GuiEventListener)this.recipeBookComponent);
        this.m_94718_((GuiEventListener)this.recipeBookComponent);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBookComponent.m_100386_();
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        if (this.recipeBookComponent.m_100385_() && this.widthTooNarrow) {
            this.m_7286_(ms, partialTicks, mouseX, mouseY);
            this.recipeBookComponent.m_6305_(ms, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBookComponent.m_6305_(ms, mouseX, mouseY, partialTicks);
            super.m_6305_(ms, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.m_6545_(ms, this.f_97735_, this.f_97736_, false, partialTicks);
        }
        this.renderMealDisplayTooltip(ms, mouseX, mouseY);
        this.renderHeatIndicatorTooltip(ms, mouseX, mouseY);
        this.renderWaterBarIndicatorTooltip(ms, mouseX, mouseY);
        this.recipeBookComponent.m_100361_(ms, this.f_97735_, this.f_97736_, mouseX, mouseY);
    }

    private void renderHeatIndicatorTooltip(PoseStack ms, int mouseX, int mouseY) {
        if (this.m_6774_(KettleScreen.HEAT_ICON.x, KettleScreen.HEAT_ICON.y, KettleScreen.HEAT_ICON.width, KettleScreen.HEAT_ICON.height, mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            String key = "container.cooking_pot." + (((KettleMenu)this.f_97732_).isHeated() ? "heated" : "not_heated");
            tooltip.add(TextUtils.getTranslation((String)key, (Object[])new Object[]{this.f_97732_}));
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        }
    }

    private void renderWaterBarIndicatorTooltip(PoseStack ms, int mouseX, int mouseY) {
        if (this.m_6774_(35, 18, 3, 31, mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            MutableComponent key = null;
            if (((KettleMenu)this.f_97732_).waterLevel() == 0) {
                key = FRTextUtils.getTranslation("container.kettle.no_water", new Object[0]);
            }
            if (((KettleMenu)this.f_97732_).waterLevel() == 1) {
                key = FRTextUtils.getTranslation("container.kettle.has_single_water", new Object[0]);
            }
            if (((KettleMenu)this.f_97732_).waterLevel() > 1) {
                key = FRTextUtils.getTranslation("container.kettle.has_many_water", ((KettleMenu)this.f_97732_).waterLevel());
            }
            tooltip.add(key);
            this.m_96597_(ms, tooltip, mouseX, mouseY);
        }
    }

    protected void renderMealDisplayTooltip(PoseStack ms, int mouseX, int mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && ((KettleMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ == 2) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                ItemStack mealStack = this.f_97734_.m_7993_();
                tooltip.add(((MutableComponent)mealStack.m_41720_().m_41466_()).m_130940_(mealStack.m_41791_().f_43022_));
                ItemStack containerStack = ((KettleMenu)this.f_97732_).tileEntity.getContainer();
                String container = !containerStack.m_41619_() ? containerStack.m_41720_().m_41466_().getString() : "";
                tooltip.add(TextUtils.getTranslation((String)"container.cooking_pot.served_on", (Object[])new Object[]{container}).m_130940_(ChatFormatting.GRAY));
                this.m_96597_(ms, tooltip, mouseX, mouseY);
            } else {
                this.m_6057_(ms, this.f_97734_.m_7993_(), mouseX, mouseY);
            }
        }
    }

    protected void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        super.m_7027_(ms, mouseX, mouseY);
        this.f_96547_.m_92889_(ms, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        this.m_93228_(ms, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((KettleMenu)this.f_97732_).isHeated()) {
            this.m_93228_(ms, this.f_97735_ + KettleScreen.HEAT_ICON.x, this.f_97736_ + KettleScreen.HEAT_ICON.y, 176, 0, KettleScreen.HEAT_ICON.width, KettleScreen.HEAT_ICON.height);
        }
        int l = ((KettleMenu)this.f_97732_).getBrewProgressionScaled();
        this.m_93228_(ms, this.f_97735_ + KettleScreen.PROGRESS_ARROW.x, this.f_97736_ + KettleScreen.PROGRESS_ARROW.y, 176, 15, l + 1, KettleScreen.PROGRESS_ARROW.height);
        if (((KettleMenu)this.f_97732_).waterLevel() == 1) {
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR1.x, this.f_97736_ + KettleScreen.WATER_BAR1.y, 176, 53, KettleScreen.WATER_BAR1.width, KettleScreen.WATER_BAR1.height);
        }
        if (((KettleMenu)this.f_97732_).waterLevel() == 2) {
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR1.x, this.f_97736_ + KettleScreen.WATER_BAR1.y, 176, 53, KettleScreen.WATER_BAR1.width, KettleScreen.WATER_BAR1.height);
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR2.x, this.f_97736_ + KettleScreen.WATER_BAR2.y, 176, 43, KettleScreen.WATER_BAR2.width, KettleScreen.WATER_BAR2.height);
        }
        if (((KettleMenu)this.f_97732_).waterLevel() == 3) {
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR1.x, this.f_97736_ + KettleScreen.WATER_BAR1.y, 176, 53, KettleScreen.WATER_BAR1.width, KettleScreen.WATER_BAR1.height);
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR2.x, this.f_97736_ + KettleScreen.WATER_BAR2.y, 176, 43, KettleScreen.WATER_BAR2.width, KettleScreen.WATER_BAR2.height);
            this.m_93228_(ms, this.f_97735_ + KettleScreen.WATER_BAR3.x, this.f_97736_ + KettleScreen.WATER_BAR3.y, 176, 32, KettleScreen.WATER_BAR3.width, KettleScreen.WATER_BAR3.height);
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.m_100385_()) && super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
        if (this.recipeBookComponent.m_6375_(mouseX, mouseY, buttonId)) {
            this.m_7522_((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.m_100385_() || super.m_6375_(mouseX, mouseY, buttonId);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int x, int y, int buttonIdx) {
        boolean flag = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + this.f_97726_) || mouseY >= (double)(y + this.f_97727_);
        return flag && this.recipeBookComponent.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, buttonIdx);
    }

    protected void m_6597_(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.m_6597_(slot, mouseX, mouseY, clickType);
        this.recipeBookComponent.m_6904_(slot);
    }

    public void m_6916_() {
        this.recipeBookComponent.m_100387_();
    }

    public void m_7861_() {
        this.recipeBookComponent.m_100373_();
        super.m_7861_();
    }

    @Nonnull
    public RecipeBookComponent m_5564_() {
        return this.recipeBookComponent;
    }
}

