/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.models;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.goodending.entities.MarshEntity;

@OnlyIn(value=Dist.CLIENT)
public class MarshEntityModel<T extends MarshEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public MarshEntityModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.tail = this.body.m_171324_("tail");
        this.leftFin = this.body.m_171324_("left_fin");
        this.rightFin = this.body.m_171324_("right_fin");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, -10.0f, -7.0f, 12.0f, 10.0f, 12.0f).m_171514_(0, 15).m_171481_(0.0f, -14.0f, 2.0f, 0.0f, 12.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 38).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)5.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftFin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(0.0f, -4.5f, 0.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171423_((float)6.0f, (float)-1.5f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightFin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171555_(true).m_171481_(-5.0f, -4.5f, 0.0f, 5.0f, 6.0f, 0.0f), PartPose.m_171423_((float)-6.0f, (float)-1.5f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(28, 22).m_171481_(-1.5f, 0.0f, -3.0f, 4.0f, 5.0f, 6.0f), PartPose.m_171423_((float)3.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(28, 22).m_171555_(true).m_171481_(-2.5f, 0.0f, -3.0f, 4.0f, 5.0f, 6.0f), PartPose.m_171423_((float)-3.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)48, (int)48);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float limb = Mth.m_14036_((float)limbDistance, (float)-0.45f, (float)0.45f);
        float tilt = Math.min(limbDistance / 0.3f, 1.0f);
        float speed = 0.75f;
        float degree = 0.5f;
        this.leftFin.f_104204_ = -tilt * 0.65f;
        this.rightFin.f_104204_ = tilt * 0.65f;
        this.tail.f_104203_ = -0.7854f + tilt;
        this.rightFin.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.3f + (float)Math.PI)) * degree * 0.2f * 0.5f + 0.7854f;
        this.leftFin.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.3f)) * degree * 0.2f * 0.5f - 0.7854f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.6f)) * 1.4f * limb;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.6f + (float)Math.PI)) * 1.4f * limb;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.3f + 1.5707964f)) * 1.4f * limb;
        this.body.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 0.3f)) * 0.35f * limb;
        this.body.f_104201_ = Mth.m_14089_((float)(limbAngle * speed * 1.2f + 1.5707964f)) * limb + 19.0f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

