/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireflyParticle
extends SimpleAnimatedParticle {
    private boolean lock = false;
    private int litTicks;

    public FireflyParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, 0.0125f);
        this.f_107215_ = velocityX;
        this.f_107216_ = velocityY;
        this.f_107217_ = velocityZ;
        this.f_107663_ *= 1.5f;
        this.f_107225_ = world.m_213780_().m_188503_(60) + 20;
        this.litTicks = 240;
        this.f_107219_ = true;
        this.m_108339_(spriteProvider);
    }

    public void m_6257_(double dx, double dy, double dz) {
        this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
        this.m_107275_();
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.lock && this.litTicks > 0) {
            this.litTicks -= 30;
            if (this.litTicks == 0) {
                this.lock = true;
            }
        }
        if (this.lock && this.litTicks >= 0) {
            this.litTicks += 30;
            if (this.litTicks == 240) {
                this.lock = false;
            }
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternion quaternion;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_90591_();
        } else {
            quaternion = new Quaternion(camera.m_90591_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(i));
        }
        Vector3f vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        vec3f.m_122251_(quaternion);
        Vector3f[] vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f vec3f2 = vec3fs[k];
            vec3f2.m_122251_(quaternion);
            vec3f2.m_122261_(j);
            vec3f2.m_122272_(f, g, h);
        }
        float l = this.m_5970_();
        float m = this.m_5952_();
        float n = this.m_5951_();
        float o = this.m_5950_();
        int p = this.litTicks;
        vertexConsumer.m_5483_((double)vec3fs[0].m_122239_(), (double)vec3fs[0].m_122260_(), (double)vec3fs[0].m_122269_()).m_7421_(m, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vec3fs[1].m_122239_(), (double)vec3fs[1].m_122260_(), (double)vec3fs[1].m_122269_()).m_7421_(m, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vec3fs[2].m_122239_(), (double)vec3fs[2].m_122260_(), (double)vec3fs[2].m_122269_()).m_7421_(l, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
        vertexConsumer.m_5483_((double)vec3fs[3].m_122239_(), (double)vec3fs[3].m_122260_(), (double)vec3fs[3].m_122269_()).m_7421_(l, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FireflyParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

