/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.goodending.entities.GoodEndingBoatEntity;
import net.orcinus.goodending.init.GoodEndingModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class GoodEndingBoatEntityRenderer
extends EntityRenderer<GoodEndingBoatEntity> {
    private final Map<GoodEndingBoatEntity.BoatType, Pair<ResourceLocation, BoatModel>> texturesAndModels;

    public GoodEndingBoatEntityRenderer(EntityRendererProvider.Context ctx, boolean chest) {
        super(ctx);
        this.f_114477_ = 0.8f;
        this.texturesAndModels = (Map)Stream.of(GoodEndingBoatEntity.BoatType.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("goodending", GoodEndingBoatEntityRenderer.getTexture(type, chest)), (Object)this.createModel(ctx, (GoodEndingBoatEntity.BoatType)((Object)type), chest))));
    }

    private BoatModel createModel(EntityRendererProvider.Context ctx, GoodEndingBoatEntity.BoatType type, boolean chest) {
        ModelLayerLocation entityModelLayer = chest ? GoodEndingModelLayers.createChestBoat(type) : GoodEndingModelLayers.createBoat(type);
        return new BoatModel(ctx.m_174023_(entityModelLayer), chest);
    }

    private static String getTexture(GoodEndingBoatEntity.BoatType type, boolean chest) {
        if (chest) {
            return "textures/entity/chest_boat/" + type.getName() + ".png";
        }
        return "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(GoodEndingBoatEntity boatEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
        float h = (float)boatEntity.m_38385_() - g;
        float j = boatEntity.m_38384_() - g;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boatEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)boatEntity.m_38352_(g), (float)0.0f)) {
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boatEntity.m_38352_(g), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.texturesAndModels.get((Object)boatEntity.getGoodEndingBoatType());
        ResourceLocation identifier = (ResourceLocation)pair.getFirst();
        BoatModel boatEntityModel = (BoatModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatEntityModel.m_6973_((Boat)boatEntity, g, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(boatEntityModel.m_103119_(identifier));
        boatEntityModel.m_7695_(matrixStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boatEntity.m_5842_()) {
            VertexConsumer vertexConsumer2 = vertexConsumerProvider.m_6299_(RenderType.m_110478_());
            boatEntityModel.m_102282_().m_104301_(matrixStack, vertexConsumer2, i, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)boatEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTextureLocation(GoodEndingBoatEntity boatEntity) {
        return (ResourceLocation)this.texturesAndModels.get((Object)boatEntity.getGoodEndingBoatType()).getFirst();
    }
}

