/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.renderer;

import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.goodending.client.models.MarshEntityModel;
import net.orcinus.goodending.client.renderer.layer.MarshEffectRenderer;
import net.orcinus.goodending.entities.MarshEntity;
import net.orcinus.goodending.init.GoodEndingModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class MarshRenderer
extends MobRenderer<MarshEntity, MarshEntityModel<MarshEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("goodending", "textures/entity/marsh/marsh.png");
    private static final ResourceLocation TEXTURE_BREWING = new ResourceLocation("goodending", "textures/entity/marsh/marsh_brewing.png");
    private static final ResourceLocation TEXTURE_READY = new ResourceLocation("goodending", "textures/entity/marsh/marsh_ready.png");

    public MarshRenderer(EntityRendererProvider.Context context) {
        super(context, new MarshEntityModel(context.m_174023_(GoodEndingModelLayers.MARSH)), 0.5f);
        this.m_115326_(new MarshEffectRenderer((RenderLayerParent<MarshEntity, MarshEntityModel<MarshEntity>>)this));
    }

    public ResourceLocation getTextureLocation(MarshEntity entity) {
        if (entity.getBurpingTicks() > 0) {
            return TEXTURE_BREWING;
        }
        if (entity.getStoredPotion() != Potions.f_43598_) {
            return entity.getBrewingTicks() == 0 ? TEXTURE_READY : TEXTURE_BREWING;
        }
        return TEXTURE;
    }
}

