/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.goodending.client.models.MarshEntityModel;
import net.orcinus.goodending.entities.MarshEntity;

@OnlyIn(value=Dist.CLIENT)
public class MarshEffectRenderer
extends RenderLayer<MarshEntity, MarshEntityModel<MarshEntity>> {
    private static final ResourceLocation TEXTURE_BREWING = new ResourceLocation("goodending", "textures/entity/marsh/marsh_brewing_overlay.png");
    private static final ResourceLocation TEXTURE_READY = new ResourceLocation("goodending", "textures/entity/marsh/marsh_ready_overlay.png");

    public MarshEffectRenderer(RenderLayerParent<MarshEntity, MarshEntityModel<MarshEntity>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, MarshEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (entity.getStoredPotion() != Potions.f_43598_) {
            int color = PotionUtils.m_43559_((Potion)entity.getStoredPotion());
            int d = (color >> 16 & 0xFF) / 100;
            int e = (color >> 8 & 0xFF) / 100;
            int f = (color & 0xFF) / 100;
            int brewingTicks = entity.getBrewingTicks();
            ResourceLocation texture = brewingTicks == 0 ? TEXTURE_READY : TEXTURE_BREWING;
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(brewingTicks == 0 ? RenderType.m_110458_((ResourceLocation)texture) : RenderType.m_110488_((ResourceLocation)texture));
            ((MarshEntityModel)this.m_117386_()).m_7695_(matrices, vertexConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), d, e, f, 1.0f);
        }
    }
}

