/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.orcinus.goodending.entities.ai.FlyAroundGoal;
import net.orcinus.goodending.init.GoodEndingCriteriaTriggers;
import net.orcinus.goodending.init.GoodEndingItems;
import net.orcinus.goodending.init.GoodEndingParticleTypes;
import net.orcinus.goodending.init.GoodEndingSoundEvents;
import org.jetbrains.annotations.Nullable;

public class FireflyEntity
extends PathfinderMob
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> COUNT = SynchedEntityData.m_135353_(FireflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(FireflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FireflyEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setCount(this.m_217043_().m_216332_(1, 3));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COUNT, (Object)1);
        this.f_19804_.m_135372_(FROM_BOTTLE, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Count", this.getCount());
        nbt.m_128379_("FromBottle", this.isFromBottle());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setCount(nbt.m_128451_("Count"));
        this.setFromBottle(nbt.m_128471_("FromBottle"));
    }

    public boolean isFromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    public void setFromBottle(boolean fromBottle) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)fromBottle);
    }

    public void setCount(int count) {
        this.f_19804_.m_135381_(COUNT, (Object)count);
    }

    public int getCount() {
        return (Integer)this.f_19804_.m_135370_(COUNT);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(true);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FlyAroundGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
    }

    public boolean m_20229_(double p_20230_, double p_20231_, double p_20232_) {
        return true;
    }

    protected void m_6731_(LivingEntity target) {
        target.m_147240_(0.0, this.m_20185_(), this.m_20189_());
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42590_) && this.getCount() > 0) {
            this.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)GoodEndingSoundEvents.ITEM_FIREFLY_BOTTLE_FILL.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            if (!this.f_19853_.m_5776_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    GoodEndingCriteriaTriggers.CAPTURE_FIREFLY.trigger(serverPlayer);
                }
                this.setCount(this.getCount() - 1);
                this.m_146850_(GameEvent.f_223708_);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)GoodEndingItems.FIREFLY_BOTTLE.get())));
                if (this.getCount() == 0) {
                    this.m_146870_();
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)GoodEndingItems.FIREFLY_BOTTLE.get()) && this.getCount() < 3 && !this.f_19853_.m_5776_()) {
            if (!this.f_19853_.m_5776_()) {
                this.setCount(this.getCount() + 1);
                this.m_146850_(GameEvent.f_223708_);
                this.setFromBottle(true);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            }
            this.f_19853_.m_5594_(null, this.m_20183_(), (SoundEvent)GoodEndingSoundEvents.ITEM_FIREFLY_BOTTLE_EMPTY.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_46461_() && !this.f_19853_.f_46443_) {
            this.f_19853_.m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_(16.0)).stream().filter(Objects::isNull).forEach(player -> this.m_146870_());
        }
    }

    public void m_8119_() {
        block5: {
            super.m_8119_();
            int count = this.getCount();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            float width = 1.0f + (float)(count - 1) * 0.5f;
            RandomSource random = this.m_9236_().f_46441_;
            double j = random.m_188583_() * 0.025;
            double k = random.m_188583_() * 0.025;
            double l = random.m_188583_() * 0.025;
            if (!this.m_6084_()) break block5;
            if (this.f_19853_.m_46468_() < 12000L && this.f_19853_.m_46468_() > 0L) {
                mutable.m_122169_(this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.25f, (float)0.25f), (double)this.m_20183_().m_123342_(), this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.25f, (float)0.25f));
                int i = 0;
                while ((double)i < 0.5) {
                    if (this.f_19796_.m_188501_() < 0.01f) {
                        this.addParticle(mutable, random, j, k, l);
                    }
                    ++i;
                }
            } else {
                mutable.m_122169_(this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)(-width), (float)width), (double)this.m_20183_().m_123342_(), this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)(-width), (float)width));
                for (int i = 0; i < count; ++i) {
                    if (!(this.f_19796_.m_188501_() < 0.1f)) continue;
                    this.addParticle(mutable, random, j, k, l);
                }
            }
        }
    }

    private void addParticle(BlockPos.MutableBlockPos mutable, RandomSource random, double j, double k, double l) {
        this.f_19853_.m_7106_((ParticleOptions)GoodEndingParticleTypes.FIREFLY.get(), (double)mutable.m_123341_() + random.m_188500_(), this.m_20186_() + random.m_188500_(), (double)mutable.m_123343_() + random.m_188500_(), j, k, l);
    }

    public static AttributeSupplier.Builder createFireflyAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static boolean canSpawn(EntityType<FireflyEntity> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_6018_().m_46462_() && world.m_45517_(LightLayer.BLOCK, pos) < UniformInt.m_146622_((int)0, (int)7).m_214085_(random) && world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_);
    }

    protected void m_7324_(Entity p_20971_) {
    }

    protected void m_6138_() {
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    public boolean m_20329_(Entity p_20330_) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return !this.isFromBottle();
    }

    public boolean m_8023_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.f_19853_.m_46468_() < 12000L && this.f_19853_.m_46468_() > 0L) {
            return null;
        }
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_FIREFLY_SWARM_IDLE.get();
    }

    public int m_8100_() {
        return 200;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public boolean m_213854_() {
        return true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }
}

