/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities;

import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.orcinus.goodending.entities.ai.FollowMobWithEffectGoal;
import net.orcinus.goodending.entities.ai.StrangerDangerGoal;
import net.orcinus.goodending.init.GoodEndingCriteriaTriggers;
import net.orcinus.goodending.init.GoodEndingSoundEvents;
import net.orcinus.goodending.init.GoodEndingTags;
import org.jetbrains.annotations.Nullable;

public class MarshEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> TRUSTED = SynchedEntityData.m_135353_(MarshEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BREWING = SynchedEntityData.m_135353_(MarshEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BURPING = SynchedEntityData.m_135353_(MarshEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion = Potions.f_43598_;
    private boolean infinite;

    public MarshEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRUSTED, (Object)false);
        this.f_19804_.m_135372_(BREWING, (Object)0);
        this.f_19804_.m_135372_(BURPING, (Object)0);
    }

    public static AttributeSupplier.Builder createMarshAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new StrangerDangerGoal<Player>(this, Player.class));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new FollowMobWithEffectGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isTrusted() {
        return (Boolean)this.f_19804_.m_135370_(TRUSTED);
    }

    public void setTrusted(boolean trusted) {
        this.f_19804_.m_135381_(TRUSTED, (Object)trusted);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getStoredPotion() != Potions.f_43598_ && this.getBrewingTicks() > 0) {
            List collection = this.getStoredPotion().m_43488_();
            int i = PotionUtils.m_43564_((Collection)collection);
            float f1 = this.m_217043_().m_188501_();
            if (f1 > 0.35f) {
                return;
            }
            double d = (double)(i >> 16 & 0xFF) / 255.0;
            double e = (double)(i >> 8 & 0xFF) / 255.0;
            double f = (double)(i & 0xFF) / 255.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), d, e, f);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.getBrewingTicks() > 0) {
                if (this.getBrewingTicks() == 1) {
                    this.m_5496_((SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_BURP.get(), 1.0f, 1.0f);
                }
                this.setBrewingTicks(this.getBrewingTicks() - 1);
            }
            if (this.getBurpingTicks() > 0) {
                this.setBurping(this.getBurpingTicks() - 1);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_204117_(GoodEndingTags.MARSH_TRUSTED_ITEMS) && !this.isTrusted()) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.setTrusted(true);
            this.f_19853_.m_7605_((Entity)this, (byte)18);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (item instanceof PotionItem && this.getStoredPotion() == Potions.f_43598_ && this.isTrusted() && !PotionUtils.m_43579_((ItemStack)itemStack).m_43491_()) {
            this.setInfinite(item instanceof LingeringPotionItem);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                if (!(item instanceof ThrowablePotionItem)) {
                    this.m_20000_((ItemLike)Items.f_42590_, 1);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GoodEndingCriteriaTriggers.BREW_POTION.trigger(serverPlayer);
            }
            this.setStoredPotion(PotionUtils.m_43579_((ItemStack)itemStack));
            this.setBrewingTicks(1800 + this.m_217043_().m_188503_(1200));
            return InteractionResult.SUCCESS;
        }
        if (item instanceof MilkBucketItem && this.getStoredPotion() != Potions.f_43598_ && this.isTrusted()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, Items.f_42446_.m_7968_());
            }
            this.setStoredPotion(Potions.f_43598_);
            this.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
            this.setBrewingTicks(0);
            return InteractionResult.SUCCESS;
        }
        if (this.getStoredPotion() != Potions.f_43598_ && itemStack.m_41783_() != null && !itemStack.m_41783_().m_128441_("Potion") && this.getValidItems(item) && this.getBrewingTicks() == 0 && itemStack.m_41783_() != null) {
            if (this.isInfinite()) {
                itemStack.m_41783_().m_128379_("Infinite", true);
                this.setInfinite(false);
            } else {
                itemStack.m_41783_().m_128405_("Amount", 20);
            }
            PotionUtils.m_43549_((ItemStack)itemStack, (Potion)this.getStoredPotion());
            this.setBurping(15);
            this.m_5496_((SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_BURP.get(), 1.0f, 1.0f);
            this.setStoredPotion(Potions.f_43598_);
            this.setBrewingTicks(0);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7822_(byte status) {
        if (status == 42) {
            this.spawnParticles(5, ParticleTypes.f_123769_, 1.0);
        } else if (status == 18) {
            this.spawnParticles(7, ParticleTypes.f_123750_, 0.5);
        } else {
            super.m_7822_(status);
        }
    }

    private void spawnParticles(int x, SimpleParticleType splash, double x1) {
        for (int i = 0; i < x; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)splash, this.m_20208_(1.0), this.m_20187_() + x1, this.m_20262_(1.0), d, e, f);
        }
    }

    public boolean getValidItems(Item item) {
        for (MobEffectInstance effectInstance : this.getStoredPotion().m_43488_()) {
            MobEffectCategory category = effectInstance.m_19544_().m_19483_();
            if (category == MobEffectCategory.HARMFUL && item instanceof SwordItem) {
                return true;
            }
            if (category != MobEffectCategory.BENEFICIAL || !(item instanceof ShieldItem)) continue;
            return true;
        }
        return false;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.getStoredPotion()).toString());
        nbt.m_128379_("Infinite", this.isInfinite());
        nbt.m_128379_("Trusted", this.isTrusted());
        nbt.m_128405_("BrewingTicks", this.getBrewingTicks());
        nbt.m_128405_("BurpingTicks", this.getBurpingTicks());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setInfinite(nbt.m_128471_("Infinite"));
        this.setTrusted(nbt.m_128471_("Trusted"));
        this.setStoredPotion(PotionUtils.m_43577_((CompoundTag)nbt));
        this.setBrewingTicks(nbt.m_128451_("BrewingTicks"));
        this.setBurping(nbt.m_128451_("BurpingTicks"));
    }

    public int getBurpingTicks() {
        return (Integer)this.f_19804_.m_135370_(BURPING);
    }

    public void setBurping(int burpingTicks) {
        this.f_19804_.m_135381_(BURPING, (Object)burpingTicks);
    }

    public int getBrewingTicks() {
        return (Integer)this.f_19804_.m_135370_(BREWING);
    }

    public void setBrewingTicks(int brewingTicks) {
        this.f_19804_.m_135381_(BREWING, (Object)brewingTicks);
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public boolean m_6040_() {
        return true;
    }

    public Potion getStoredPotion() {
        return this.potion;
    }

    public void setStoredPotion(Potion potion) {
        this.potion = potion;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getStoredPotion() != Potions.f_43598_) {
            return (SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_BREWING_IDLE.get();
        }
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)GoodEndingSoundEvents.ENTITY_MARSH_DEATH.get();
    }
}

