/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.entities.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.orcinus.goodending.entities.WoodpeckerEntity;

public class FindWoodGoal
extends Goal {
    private final WoodpeckerEntity woodpecker;
    private BlockPos pos;

    public FindWoodGoal(WoodpeckerEntity woodpecker) {
        this.woodpecker = woodpecker;
    }

    public boolean m_8036_() {
        if (this.woodpecker.getAttachedFace() != Direction.UP && this.woodpecker.getAttachedFace() != Direction.DOWN) {
            return false;
        }
        return this.findNearestBlock() && this.woodpecker.getWoodPos() == null;
    }

    public void m_8056_() {
        if (this.pos != null) {
            this.woodpecker.setWoodPos(this.pos);
        }
    }

    protected boolean findNearestBlock() {
        ArrayList poses = Lists.newArrayList();
        int range = 8;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -range; y <= range; ++y) {
                    BlockPos pos = new BlockPos(this.woodpecker.m_20185_() + (double)x, this.woodpecker.m_20186_() + (double)y, this.woodpecker.m_20189_() + (double)z);
                    BlockState state = this.woodpecker.f_19853_.m_8055_(pos);
                    if (!state.m_204336_(BlockTags.f_13106_)) continue;
                    poses.add(pos);
                }
            }
        }
        if (!poses.isEmpty()) {
            poses.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.woodpecker.m_20183_()).m_123331_(arg_0)));
            for (BlockPos pos : poses) {
                double x = (double)((float)pos.m_123341_() + 0.5f) - this.woodpecker.m_20185_();
                double z = (double)((float)pos.m_123343_() + 0.5f) - this.woodpecker.m_20189_();
                double distance = x * x + z * z;
                Vec3 blockVec = Vec3.m_82512_((Vec3i)pos);
                BlockHitResult result = this.woodpecker.f_19853_.m_45547_(new ClipContext(this.woodpecker.m_146892_(), blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.woodpecker));
                List woodpeckerEntities = this.woodpecker.f_19853_.m_45976_(WoodpeckerEntity.class, new AABB(result.m_82425_().m_121945_(result.m_82434_())));
                if (!this.woodpecker.f_19853_.m_8055_(result.m_82425_()).m_204336_(BlockTags.f_13106_) || !this.woodpecker.f_19853_.m_8055_(result.m_82425_().m_121945_(result.m_82434_())).m_60795_() || result.m_6662_() == HitResult.Type.MISS || !(distance > 4.0) || result.m_82434_().m_122434_() == Direction.Axis.Y || woodpeckerEntities.size() != 0) continue;
                this.pos = result.m_82425_();
                this.woodpecker.setAttachedFace(result.m_82434_());
                return true;
            }
        }
        return false;
    }
}

