/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.events;

import java.util.Arrays;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.orcinus.goodending.client.gui.tooltip.PotionApplicationTooltipComponent;
import net.orcinus.goodending.client.gui.tooltip.PotionApplicationTooltipData;
import net.orcinus.goodending.client.models.MarshEntityModel;
import net.orcinus.goodending.client.models.WoodPeckerEntityModel;
import net.orcinus.goodending.client.particles.FireflyParticle;
import net.orcinus.goodending.client.particles.LeafParticle;
import net.orcinus.goodending.client.renderer.FireflyRenderer;
import net.orcinus.goodending.client.renderer.GoodEndingBoatEntityRenderer;
import net.orcinus.goodending.client.renderer.MarshRenderer;
import net.orcinus.goodending.client.renderer.WoodpeckerRenderer;
import net.orcinus.goodending.entities.GoodEndingBoatEntity;
import net.orcinus.goodending.init.GoodEndingBlockEntityTypes;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.init.GoodEndingEntityTypes;
import net.orcinus.goodending.init.GoodEndingModelLayers;
import net.orcinus.goodending.init.GoodEndingParticleTypes;
import net.orcinus.goodending.init.GoodEndingSignTypes;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="goodending", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.ALGAE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.BIRCH_MUSHROOM.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.CATTAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.LARGE_LILY_PAD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.PURPLE_FLOWERING_LILY_PAD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.PINK_FLOWERING_LILY_PAD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.YELLOW_FLOWERING_LILY_PAD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.PASTEL_WILDFLOWERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.TWILIGHT_WILDFLOWERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.SPICY_WILDFLOWERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.BALMY_WILDFLOWERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.DUCKWEED.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.FIREFLY_LANTERN.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.HANGING_OAK_LEAVES.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.HANGING_OAK_LEAVES_PLANT.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES_PLANT.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.MUDDY_OAK_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.CYPRESS_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.CYPRESS_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.CYPRESS_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.POTTED_CYPRESS_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GoodEndingBlocks.POLLENFLAKE.get()), (RenderType)RenderType.m_110463_());
        event.enqueueWork(GoodEndingSignTypes::init);
    }

    @SubscribeEvent
    public static void renderTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(PotionApplicationTooltipData.class, PotionApplicationTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerEntityModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(GoodEndingModelLayers.MARSH, MarshEntityModel::getLayerDefinition);
        event.registerLayerDefinition(GoodEndingModelLayers.WOODPECKER, WoodPeckerEntityModel::getLayerDefinition);
        Arrays.stream(GoodEndingBoatEntity.BoatType.values()).forEach(type -> {
            event.registerLayerDefinition(GoodEndingModelLayers.createBoat(type), () -> BoatModel.m_233347_((boolean)false));
            event.registerLayerDefinition(GoodEndingModelLayers.createChestBoat(type), () -> BoatModel.m_233347_((boolean)true));
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)GoodEndingBlockEntityTypes.GE_SIGN.get(), SignRenderer::new);
        event.registerEntityRenderer((EntityType)GoodEndingEntityTypes.FIREFLY_SWARM.get(), FireflyRenderer::new);
        event.registerEntityRenderer((EntityType)GoodEndingEntityTypes.MARSH.get(), MarshRenderer::new);
        event.registerEntityRenderer((EntityType)GoodEndingEntityTypes.WOODPECKER.get(), WoodpeckerRenderer::new);
        event.registerEntityRenderer((EntityType)GoodEndingEntityTypes.BOAT.get(), ctx -> new GoodEndingBoatEntityRenderer(ctx, false));
        event.registerEntityRenderer((EntityType)GoodEndingEntityTypes.CHEST_BOAT.get(), ctx -> new GoodEndingBoatEntityRenderer(ctx, true));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return FoliageColor.m_46113_();
            }
            return BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
        }, new Block[]{(Block)GoodEndingBlocks.CYPRESS_LEAVES.get(), (Block)GoodEndingBlocks.HANGING_OAK_LEAVES.get(), (Block)GoodEndingBlocks.HANGING_OAK_LEAVES_PLANT.get(), (Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES.get(), (Block)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES_PLANT.get(), (Block)GoodEndingBlocks.DENSE_DARK_OAK_LEAVES.get(), Blocks.f_50196_, (Block)GoodEndingBlocks.LARGE_LILY_PAD.get(), (Block)GoodEndingBlocks.PURPLE_FLOWERING_LILY_PAD.get(), (Block)GoodEndingBlocks.PINK_FLOWERING_LILY_PAD.get(), (Block)GoodEndingBlocks.YELLOW_FLOWERING_LILY_PAD.get()});
        event.register((state, world, pos, tintIndex) -> FoliageColor.m_46112_(), new Block[]{(Block)GoodEndingBlocks.DENSE_BIRCH_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)GoodEndingBlocks.DENSE_BIRCH_LEAVES.get(), (ItemLike)GoodEndingBlocks.DENSE_DARK_OAK_LEAVES.get(), (ItemLike)GoodEndingBlocks.LARGE_LILY_PAD.get(), Blocks.f_50196_, (ItemLike)GoodEndingBlocks.CYPRESS_LEAVES.get(), (ItemLike)GoodEndingBlocks.HANGING_OAK_LEAVES.get(), (ItemLike)GoodEndingBlocks.HANGING_DARK_OAK_LEAVES.get()});
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return tintIndex > 0 ? -1 : event.getBlockColors().m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)GoodEndingBlocks.PURPLE_FLOWERING_LILY_PAD.get(), (ItemLike)GoodEndingBlocks.PINK_FLOWERING_LILY_PAD.get(), (ItemLike)GoodEndingBlocks.YELLOW_FLOWERING_LILY_PAD.get()});
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)GoodEndingParticleTypes.FIREFLY.get(), FireflyParticle.Factory::new);
        event.register((ParticleType)GoodEndingParticleTypes.BIRCH_LEAF.get(), LeafParticle.Factory::new);
        event.register((ParticleType)GoodEndingParticleTypes.DARK_OAK_LEAF.get(), LeafParticle.Factory::new);
    }
}

