/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.orcinus.goodending.init.GoodEndingTags;
import net.orcinus.goodending.world.gen.features.config.BoulderConfig;

public class BoulderFeature
extends Feature<BoulderConfig> {
    public BoulderFeature(Codec<BoulderConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<BoulderConfig> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        BoulderConfig config = (BoulderConfig)context.m_159778_();
        if (world.m_8055_(origin.m_7495_()).m_204336_(GoodEndingTags.BASE_BOULDER) && world.m_7433_(origin, DripstoneUtils::m_159664_)) {
            float size = config.size().m_214084_(random);
            this.generateBoulder(world, origin.m_7494_(), random, config, size);
            this.modifyGrass(world, origin, random, size, config);
            return true;
        }
        return false;
    }

    private void generateBoulder(WorldGenLevel world, BlockPos origin, RandomSource random, BoulderConfig config, float size) {
        for (float x = -size; x < size; x += 1.0f) {
            for (float y = -size; y < size; y += 1.0f) {
                for (float z = -size; z < size; z += 1.0f) {
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)(size * ((size - y) / 4.0f)))) continue;
                    BlockPos pos = origin.m_7637_((double)x, (double)y, (double)z);
                    BlockState state = y + 1.0f > 0.0f && random.m_188501_() > 0.25f ? config.stone().m_213972_(random, pos) : config.secondaryStone().m_213972_(random, pos);
                    world.m_7731_(pos, state, 3);
                }
            }
        }
    }

    private void modifyGrass(WorldGenLevel world, BlockPos origin, RandomSource random, float size, BoulderConfig config) {
        int radius = (int)(size * 1.5f);
        BlockPos.m_121985_((BlockPos)origin, (int)radius, (int)3, (int)radius).forEach(pos -> {
            if ((world.m_8055_(pos).m_60713_(Blocks.f_50440_) || world.m_8055_(pos).m_60713_(Blocks.f_50599_)) && random.m_188499_() && config.coarseDirt().booleanValue()) {
                world.m_7731_(pos, Blocks.f_50546_.m_49966_(), 3);
            }
        });
    }
}

