/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.orcinus.goodending.init.GoodEndingBlocks;
import net.orcinus.goodending.init.GoodEndingTags;
import net.orcinus.goodending.world.gen.features.DuckweedFeature;
import net.orcinus.goodending.world.gen.features.config.WaterTreeFeatureConfig;

public class CypressTreeFeature
extends Feature<WaterTreeFeatureConfig> {
    public CypressTreeFeature(Codec<WaterTreeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<WaterTreeFeatureConfig> context) {
        boolean initialFlag1;
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        ArrayList list = Lists.newArrayList();
        ArrayList leavePoses = Lists.newArrayList();
        ArrayList branchPoses = Lists.newArrayList();
        int height = Mth.m_216271_((RandomSource)random, (int)10, (int)15);
        Block cypressLog = (Block)GoodEndingBlocks.CYPRESS_LOG.get();
        boolean isPlanted = ((WaterTreeFeatureConfig)context.m_159778_()).isPlanted;
        boolean initialFlag = !isPlanted && !world.m_8055_(blockPos).m_60713_(Blocks.f_49990_) || !world.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_144274_);
        boolean bl = initialFlag1 = isPlanted && !this.canGrow(world, blockPos.m_7495_());
        if (initialFlag || initialFlag1) {
            return false;
        }
        BlockState cypressLogDefaultState = cypressLog.m_49966_();
        for (int i = 0; i <= height; ++i) {
            if (!world.m_8055_(blockPos.m_6630_(i)).m_60767_().m_76336_() && !world.m_8055_(blockPos.m_6630_(i)).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES) && !world.m_8055_(blockPos.m_6630_(i)).m_60713_(Blocks.f_220864_)) continue;
            world.m_7731_(blockPos.m_6630_(i), cypressLogDefaultState, 19);
            if (random.m_188503_(3) != 0 || i >= height - 3 || i <= 3) continue;
            branchPoses.add(blockPos.m_6630_(i));
        }
        Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockState leaveState = (BlockState)((Block)GoodEndingBlocks.CYPRESS_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        branchPoses.stream().map(position -> position.m_121945_(randomDirection)).forEach(brancingPos -> {
            if (world.m_8055_(brancingPos).m_60767_().m_76336_() || world.m_8055_(brancingPos).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES)) {
                world.m_7731_(brancingPos, (BlockState)cypressLogDefaultState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)randomDirection.m_122434_()), 2);
                Arrays.stream(Direction.values()).forEach(direction -> {
                    for (int i = 0; i <= Mth.m_216271_((RandomSource)random, (int)1, (int)4); ++i) {
                        BlockPos relativeOffset = brancingPos.m_121945_(direction).m_6625_(i);
                        if (!world.m_7433_(relativeOffset, DripstoneUtils::m_159664_) && !world.m_8055_(relativeOffset).m_60767_().m_76336_() && !world.m_8055_(brancingPos).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES)) continue;
                        world.m_7731_(relativeOffset, (BlockState)leaveState.m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(world.m_8055_(relativeOffset).m_60713_(Blocks.f_49990_))), 2);
                        leavePoses.add(relativeOffset);
                    }
                });
            }
        });
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (world.m_8055_(blockPos.m_121945_(direction)).m_60767_().m_76336_() || world.m_8055_(blockPos.m_121945_(direction)).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES)) {
                world.m_7731_(blockPos.m_121945_(direction), cypressLogDefaultState, 19);
            }
            this.branchingRoot(world, blockPos.m_121945_(direction), cypressLog, random, direction, 0);
        }
        if (world.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_49990_) && world.m_8055_(blockPos).m_60795_()) {
            DuckweedFeature.generateDuckweed(world, blockPos, random);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            for (int length = 0; length < Mth.m_216271_((RandomSource)random, (int)2, (int)5); ++length) {
                BlockPos dirPos = blockPos.m_6630_(height).m_5484_(direction, length);
                if (!world.m_8055_(dirPos).m_60767_().m_76336_() && !world.m_8055_(dirPos).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES)) continue;
                world.m_7731_(dirPos, (BlockState)cypressLogDefaultState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 19);
                list.add(blockPos.m_6630_(height));
                list.add(dirPos);
            }
        }
        list.forEach(pos -> {
            for (Direction direction : Direction.values()) {
                if (!world.m_7433_(pos.m_121945_(direction), DripstoneUtils::m_159664_)) continue;
                for (int t = 0; t < Mth.m_216271_((RandomSource)random, (int)2, (int)5); ++t) {
                    BlockPos leavePose = pos.m_121945_(direction).m_6625_(t);
                    if (!world.m_8055_(leavePose).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES) && !world.m_8055_(leavePose).m_60767_().m_76336_() && !world.m_8055_(leavePose).m_204336_(BlockTags.f_13035_)) continue;
                    world.m_7731_(leavePose, (BlockState)leaveState.m_61124_((Property)LeavesBlock.f_221367_, (Comparable)Boolean.valueOf(world.m_8055_(leavePose).m_60713_(Blocks.f_49990_))), 19);
                    leavePoses.add(leavePose);
                }
            }
        });
        this.generateVines(world, 0.25f, random, leavePoses);
        return true;
    }

    public boolean canGrow(WorldGenLevel world, BlockPos blockPos) {
        int range = 3;
        boolean flag = false;
        for (int x = -range; x <= range; ++x) {
            BlockPos pos;
            for (int z = -range; z <= range && !world.m_7433_(pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_(), blockPos.m_123343_() + z), DripstoneUtils::m_159666_); ++z) {
                flag = true;
            }
        }
        return flag;
    }

    public boolean branchingRoot(WorldGenLevel world, BlockPos blockPos, Block block, RandomSource random, Direction direction, int tries) {
        BlockPos finalPos;
        BlockPos belowPos = blockPos.m_7495_();
        if (tries == 2) {
            return this.repeatPlace(world, blockPos, block);
        }
        BlockPos blockPos2 = finalPos = random.m_188503_(3) != 0 ? belowPos : blockPos.m_121945_(direction);
        if ((world.m_8055_(finalPos).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES) || world.m_8055_(finalPos).m_60767_().m_76336_() || world.m_8055_(finalPos).m_60713_(Blocks.f_49990_)) && tries < 2) {
            world.m_7731_(finalPos, block.m_49966_(), 19);
            return this.branchingRoot(world, finalPos, block, random, direction, ++tries);
        }
        return true;
    }

    public boolean repeatPlace(WorldGenLevel world, BlockPos blockPos, Block block) {
        BlockPos belowPos = blockPos.m_7495_();
        if (world.m_8055_(belowPos).m_204336_(GoodEndingTags.CYPRESS_REPLACEABLES) || world.m_8055_(belowPos).m_60713_(Blocks.f_49990_) || world.m_8055_(belowPos).m_60767_().m_76336_()) {
            world.m_7731_(belowPos, block.m_49966_(), 19);
            return this.repeatPlace(world, belowPos, block);
        }
        return true;
    }

    public void generateVines(WorldGenLevel world, float probability, RandomSource random, List<BlockPos> leavePositions) {
        leavePositions.forEach(pos -> {
            BlockPos blockPos;
            if (random.m_188501_() < probability && world.m_46859_(blockPos = pos.m_122024_())) {
                CypressTreeFeature.placeVines(blockPos, VineBlock.f_57835_, world);
            }
            if (random.m_188501_() < probability && world.m_46859_(blockPos = pos.m_122029_())) {
                CypressTreeFeature.placeVines(blockPos, VineBlock.f_57837_, world);
            }
            if (random.m_188501_() < probability && world.m_46859_(blockPos = pos.m_122012_())) {
                CypressTreeFeature.placeVines(blockPos, VineBlock.f_57836_, world);
            }
            if (random.m_188501_() < probability && world.m_46859_(blockPos = pos.m_122019_())) {
                CypressTreeFeature.placeVines(blockPos, VineBlock.f_57834_, world);
            }
        });
    }

    private static void placeVines(BlockPos pos, BooleanProperty faceProperty, WorldGenLevel world) {
        world.m_7731_(pos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)faceProperty, (Comparable)Boolean.valueOf(true)), 19);
        pos = pos.m_7495_();
        for (int i = 4; world.m_46859_(pos) && i > 0; --i) {
            world.m_7731_(pos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)faceProperty, (Comparable)Boolean.valueOf(true)), 19);
            pos = pos.m_7495_();
        }
    }
}

