/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.goodending.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.orcinus.goodending.blocks.BirchMushroomPlantBlock;
import net.orcinus.goodending.init.GoodEndingBlocks;

public class TallBirchTreeFeature
extends Feature<TreeConfiguration> {
    public TallBirchTreeFeature(Codec<TreeConfiguration> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        int height = UniformInt.m_146622_((int)6, (int)12).m_214085_(random);
        if (random.m_188503_(3) == 0 && height <= 10) {
            height = (int)((double)height * 1.25);
        }
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        ArrayList decorationPoses = Lists.newArrayList();
        ArrayList branchPoses = Lists.newArrayList();
        ArrayList leavePoses = Lists.newArrayList();
        if (!world.m_46859_(blockPos) && !world.m_8055_(blockPos).m_60713_(Blocks.f_50748_)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            if (!world.m_7433_(blockPos.m_6630_(i), blockState -> blockState.m_60713_(Blocks.f_50748_) || blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_204336_(BlockTags.f_13035_))) continue;
            world.m_7731_(blockPos.m_6630_(i), config.f_68185_.m_213972_(random, blockPos.m_6630_(i)), 19);
            decorationPoses.add(blockPos.m_6630_(i));
            if (i < height / 2) continue;
            branchPoses.add(blockPos.m_6630_(i));
        }
        for (int y = -3; y <= 2; ++y) {
            int radius = y <= -2 ? 1 : (y >= 1 ? 1 : 2);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean flag;
                    BlockPos leavePos = blockPos.m_7918_(x, y + height, z);
                    if (!world.m_7433_(leavePos, DripstoneUtils::m_159664_)) continue;
                    boolean bl = flag = !(x != radius && x != -radius || z != radius && z != -radius);
                    if (flag && (y >= -1 && y < 1 || y == 2 || y == -3)) continue;
                    world.m_7731_(leavePos, (BlockState)config.f_161213_.m_213972_(random, leavePos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 19);
                    leavePoses.add(leavePos);
                }
            }
        }
        world.m_7731_((BlockPos)leavePoses.get(world.m_213780_().m_188503_(leavePoses.size())), (BlockState)((Block)GoodEndingBlocks.DENSE_BIRCH_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 19);
        decorationPoses.forEach(pos -> {
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            BlockPos offset = pos.m_121945_(direction);
            if (random.m_188503_(10) == 0 && world.m_46859_(offset)) {
                world.m_7731_(offset, (BlockState)((Block)GoodEndingBlocks.BIRCH_MUSHROOM.get()).m_49966_().m_61124_((Property)BirchMushroomPlantBlock.FACING, (Comparable)direction), 2);
            }
        });
        branchPoses.forEach(branchPos -> {
            Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
            BlockPos offsetPos = branchPos.m_121945_(randomDirection);
            if (random.m_188503_(3) == 0 && world.m_46859_(offsetPos) && world.m_46859_(offsetPos.m_7495_())) {
                world.m_7731_(offsetPos, (BlockState)config.f_68185_.m_213972_(random, offsetPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)randomDirection.m_122434_()), 19);
                if (world.m_46859_(offsetPos.m_7495_()) && random.m_188501_() < 0.02f) {
                    this.setBeehive(world, random, offsetPos, randomDirection);
                }
            }
        });
        return true;
    }

    private void setBeehive(WorldGenLevel world, RandomSource random, BlockPos offsetPos, Direction direction) {
        if (world.m_8055_(offsetPos.m_121945_(direction)).m_204336_(BlockTags.f_13106_)) {
            direction = direction.m_122424_();
        }
        world.m_7731_(offsetPos.m_7495_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)direction), 2);
        world.m_141902_(offsetPos.m_7495_(), BlockEntityType.f_58912_).ifPresent(blockEntity -> {
            int i = 2 + random.m_188503_(2);
            for (int j = 0; j < i; ++j) {
                CompoundTag nbtCompound = new CompoundTag();
                nbtCompound.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                blockEntity.m_155157_(nbtCompound, random.m_188503_(599), false);
            }
        });
    }
}

