/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.forge;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.zeith.api.level.IBlockEntityLevel;
import org.zeith.hammerlib.api.tiles.ISidedTickableTile;
import org.zeith.hammerlib.mixins.BlockEntityAccessor;
import org.zeith.hammerlib.tiles.TileSyncableTickable;

public class BlockAPI {
    public static <T extends BlockEntity> BlockEntityTicker<T> ticker() {
        return (level, pos, state, entity) -> {
            if (entity instanceof TileSyncableTickable) {
                TileSyncableTickable t = (TileSyncableTickable)entity;
                t.m_155252_(level, pos, state, entity);
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> ticker(Level lvl) {
        return lvl.f_46443_ ? (level, pos, state, entity) -> {
            if (entity instanceof ISidedTickableTile) {
                ISidedTickableTile t = (ISidedTickableTile)entity;
                t.clientTick(level, pos, state, entity);
            }
        } : (level, pos, state, entity) -> {
            if (entity instanceof ISidedTickableTile) {
                ISidedTickableTile t = (ISidedTickableTile)entity;
                t.serverTick(level, pos, state, entity);
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityType.BlockEntitySupplier<T> generator, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(generator, (Block[])blocks).m_58966_(null);
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(DynamicBlockEntitySupplier<T> generator, Block ... blocks) {
        AtomicReference<BlockEntityType> typeRef = new AtomicReference<BlockEntityType>();
        typeRef.set(BlockEntityType.Builder.m_155273_((pos, state) -> generator.create((BlockEntityType)typeRef.get(), pos, state), (Block[])blocks).m_58966_(null));
        return (BlockEntityType)typeRef.get();
    }

    public static List<BlockEntity> getAllLoadedBlockEntities(Level level) {
        return IBlockEntityLevel.getLoadedBlockEntities(level);
    }

    public static <T extends BlockEntity> void spoofBlockEntityType(T be, BlockEntityType<T> type) {
        ((BlockEntityAccessor)be).setType_HammerLib(type);
    }

    @FunctionalInterface
    public static interface DynamicBlockEntitySupplier<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

