/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.PropertyBase;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyBaseCodec<T>
extends PropertyBase<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type, DirectStorage<T> value) {
        super(type, value);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type) {
        super(type);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        Object value = this.value.get();
        Optional res = value == null ? Optional.empty() : this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).result().flatMap(tag -> Cast.optionally(tag, CompoundTag.class));
        buf.writeBoolean(res.isPresent());
        if (res.isPresent()) {
            buf.m_130079_((CompoundTag)res.orElseThrow());
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.value.set(this.codec.decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).result().map(Pair::getFirst).orElseGet(this.defaultValue));
        } else {
            this.value.set(this.defaultValue.get());
        }
    }
}

