/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigElement;

public class ConfigBoolean
extends ConfigElement<ConfigBoolean> {
    protected boolean defaultValue;
    protected Boolean value;

    public ConfigBoolean(Runnable onChanged, ConfigToken<ConfigBoolean> token, String name) {
        super(onChanged, token, name);
        this.nameTerminator = c -> c == 61;
    }

    public ConfigBoolean withDefault(boolean value) {
        this.defaultValue = value;
        return this;
    }

    @Override
    public Boolean getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        reader.mark(5);
        char[] buf = new char[5];
        int r = reader.read(buf);
        if (r == 5 && new String(buf).equalsIgnoreCase("false")) {
            this.value = false;
            return true;
        }
        reader.reset();
        reader.mark(4);
        buf = new char[4];
        r = reader.read(buf);
        if (r == 4 && new String(buf).equalsIgnoreCase("true")) {
            this.value = true;
            return true;
        }
        reader.reset();
        throw new IOException(new IllegalArgumentException("Unexpected input: \"" + new String(buf) + "\" at " + readerStack));
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        writer.write("" + this.getValue());
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeByte(this.getValue() != false ? 1 : 0);
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.value = buf.readByte() > 0;
    }

    public String toString() {
        return "ConfigBoolean{defaultValue=" + this.defaultValue + ", value=" + this.value + ", name='" + this.name + "', comment='" + this.getEscapedComment() + "'}";
    }
}

