/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class IEContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    private final ResettableLazy<List<InfoArea>> infoAreas;
    protected final ResourceLocation background;

    public IEContainerScreen(C inventorySlotsIn, Inventory inv, Component title, ResourceLocation background) {
        super(inventorySlotsIn, inv, title);
        this.background = background;
        this.infoAreas = new ResettableLazy(this::makeInfoAreas);
        this.f_97731_ = this.f_97727_ - 91;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.infoAreas.reset();
    }

    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of();
    }

    protected void m_7027_(PoseStack transform, int mouseX, int mouseY) {
        this.f_96547_.m_92763_(transform, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, -557004);
        this.f_96547_.m_92763_(transform, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, -557004);
    }

    public void m_6305_(@Nonnull PoseStack transform, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(transform);
        super.m_6305_(transform, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (InfoArea area : this.infoAreas.get()) {
            area.fillTooltip(mouseX, mouseY, tooltip);
        }
        for (GuiEventListener w : this.m_6702_()) {
            if (!w.m_5953_((double)mouseX, (double)mouseY) || !(w instanceof ITooltipWidget)) continue;
            ITooltipWidget ttw = (ITooltipWidget)w;
            ttw.gatherTooltip(mouseX, mouseY, tooltip);
        }
        this.gatherAdditionalTooltips(mouseX, mouseY, tooltip::add, t -> tooltip.add((Component)TextUtils.applyFormat(t, ChatFormatting.GRAY)));
        if (!tooltip.isEmpty()) {
            this.m_169388_(transform, tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            this.m_7025_(transform, mouseX, mouseY);
        }
    }

    protected boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.f_97735_ + x && mouseY >= this.f_97736_ + y && mouseX < this.f_97735_ + x + w && mouseY < this.f_97736_ + y + h;
    }

    public void fullInit() {
        super.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected final void m_7286_(@Nonnull PoseStack transform, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
        this.drawBackgroundTexture(transform);
        this.drawContainerBackgroundPre(transform, partialTicks, x, y);
        for (InfoArea area : this.infoAreas.get()) {
            area.draw(transform);
        }
    }

    protected void drawBackgroundTexture(PoseStack transform) {
        this.m_93228_(transform, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawContainerBackgroundPre(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
    }

    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
    }

    public static ResourceLocation makeTextureLocation(String name) {
        return ImmersiveEngineering.rl("textures/gui/" + name + ".png");
    }

    protected void sendUpdateToServer(CompoundTag message) {
        ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageContainerUpdate(this.f_97732_.f_38840_, message));
    }
}

