/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.fluids.ConcreteFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IEFluids {
    public static final DeferredRegister<Fluid> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersiveengineering");
    public static final DeferredRegister<FluidType> TYPE_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"immersiveengineering");
    public static final List<FluidEntry> ALL_ENTRIES = new ArrayList<FluidEntry>();
    public static final Set<IEBlocks.BlockEntry<? extends LiquidBlock>> ALL_FLUID_BLOCKS = new HashSet<IEBlocks.BlockEntry<? extends LiquidBlock>>();
    public static final FluidEntry CREOSOTE = FluidEntry.make("creosote", 800, ImmersiveEngineering.rl("block/fluid/creosote_still"), ImmersiveEngineering.rl("block/fluid/creosote_flow"));
    public static final FluidEntry PLANTOIL = FluidEntry.make("plantoil", ImmersiveEngineering.rl("block/fluid/plantoil_still"), ImmersiveEngineering.rl("block/fluid/plantoil_flow"));
    public static final FluidEntry ETHANOL = FluidEntry.make("ethanol", ImmersiveEngineering.rl("block/fluid/ethanol_still"), ImmersiveEngineering.rl("block/fluid/ethanol_flow"));
    public static final FluidEntry BIODIESEL = FluidEntry.make("biodiesel", ImmersiveEngineering.rl("block/fluid/biodiesel_still"), ImmersiveEngineering.rl("block/fluid/biodiesel_flow"));
    public static final FluidEntry CONCRETE = FluidEntry.make("concrete", ImmersiveEngineering.rl("block/fluid/concrete_still"), ImmersiveEngineering.rl("block/fluid/concrete_flow"), ConcreteFluid::new, ConcreteFluid.Flowing::new, IEFluid.createBuilder(2400, 4000), ImmutableList.of((Object)IEProperties.INT_32));
    public static final FluidEntry HERBICIDE = FluidEntry.make("herbicide", ImmersiveEngineering.rl("block/fluid/herbicide_still"), ImmersiveEngineering.rl("block/fluid/herbicide_flow"));
    public static final FluidEntry REDSTONE_ACID = FluidEntry.make("redstone_acid", ImmersiveEngineering.rl("block/fluid/redstone_acid_still"), ImmersiveEngineering.rl("block/fluid/redstone_acid_flow"));
    public static final RegistryObject<FluidType> POTION_TYPE = TYPE_REGISTER.register("potion", PotionFluid.PotionFluidType::new);
    public static final RegistryObject<PotionFluid> POTION = REGISTER.register("potion", PotionFluid::new);
    public static final FluidEntry ACETALDEHYDE = FluidEntry.make("acetaldehyde", ImmersiveEngineering.rl("block/fluid/acetaldehyde_still"), ImmersiveEngineering.rl("block/fluid/acetaldehyde_flow"), IEFluid.createBuilder(788, 210));
    public static final FluidEntry PHENOLIC_RESIN = FluidEntry.make("phenolic_resin", ImmersiveEngineering.rl("block/fluid/resin_still"), ImmersiveEngineering.rl("block/fluid/resin_flow"), IEFluid.createBuilder(1100, 2800));

    public record FluidEntry(RegistryObject<IEFluid> flowing, RegistryObject<IEFluid> still, IEBlocks.BlockEntry<IEFluidBlock> block, RegistryObject<BucketItem> bucket, RegistryObject<FluidType> type, List<Property<?>> properties) {
        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, 0, stillTex, flowingTex);
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, buildAttributes);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, null);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidType.Properties> buildAttributes) {
            return FluidEntry.make(name, burnTime, stillTex, flowingTex, IEFluid::new, IEFluid.Flowing::new, buildAttributes, ImmutableList.of());
        }

        private static FluidEntry make(String name, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends IEFluid> makeStill, Function<FluidEntry, ? extends IEFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, ImmutableList<Property<?>> properties) {
            return FluidEntry.make(name, 0, stillTex, flowingTex, makeStill, makeFlowing, buildAttributes, properties);
        }

        private static FluidEntry make(String name, int burnTime, ResourceLocation stillTex, ResourceLocation flowingTex, Function<FluidEntry, ? extends IEFluid> makeStill, Function<FluidEntry, ? extends IEFluid> makeFlowing, @Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            FluidType.Properties builder = FluidType.Properties.create();
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            RegistryObject type = TYPE_REGISTER.register(name, () -> FluidEntry.makeTypeWithTextures(builder, stillTex, flowingTex));
            MutableObject thisMutable = new MutableObject();
            RegistryObject still = REGISTER.register(name, () -> FluidEntry.lambda$make$1(makeStill, (Mutable)thisMutable));
            RegistryObject flowing = REGISTER.register(name + "_flowing", () -> FluidEntry.lambda$make$2(makeFlowing, (Mutable)thisMutable));
            IEBlocks.BlockEntry<IEFluidBlock> block = new IEBlocks.BlockEntry<IEFluidBlock>(name + "_fluid_block", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_), arg_0 -> FluidEntry.lambda$make$4((Mutable)thisMutable, arg_0));
            RegistryObject bucket = IEItems.REGISTER.register(name + "_bucket", () -> FluidEntry.makeBucket((RegistryObject<IEFluid>)still, burnTime));
            FluidEntry entry = new FluidEntry((RegistryObject<IEFluid>)flowing, (RegistryObject<IEFluid>)still, block, (RegistryObject<BucketItem>)bucket, (RegistryObject<FluidType>)type, properties);
            thisMutable.setValue((Object)entry);
            ALL_FLUID_BLOCKS.add(block);
            ALL_ENTRIES.add(entry);
            return entry;
        }

        private static FluidType makeTypeWithTextures(FluidType.Properties builder, final ResourceLocation stillTex, final ResourceLocation flowingTex) {
            return new FluidType(builder){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return stillTex;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return flowingTex;
                        }
                    });
                }
            };
        }

        public IEFluid getFlowing() {
            return (IEFluid)((Object)this.flowing.get());
        }

        public IEFluid getStill() {
            return (IEFluid)((Object)this.still.get());
        }

        public IEFluidBlock getBlock() {
            return this.block.get();
        }

        public BucketItem getBucket() {
            return (BucketItem)this.bucket.get();
        }

        private static BucketItem makeBucket(RegistryObject<IEFluid> still, final int burnTime) {
            return new BucketItem((Supplier)still, new Item.Properties().m_41487_(1).m_41491_(ImmersiveEngineering.ITEM_GROUP).m_41495_(Items.f_42446_)){

                public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
                    return new FluidBucketWrapper(stack);
                }

                public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
                    return burnTime;
                }
            };
        }

        public RegistryObject<IEFluid> getStillGetter() {
            return this.still;
        }

        private static /* synthetic */ IEFluidBlock lambda$make$4(Mutable thisMutable, BlockBehaviour.Properties p) {
            return new IEFluidBlock((FluidEntry)thisMutable.getValue(), p);
        }

        private static /* synthetic */ IEFluid lambda$make$2(Function makeFlowing, Mutable thisMutable) {
            return IEFluid.makeFluid(makeFlowing, (FluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ IEFluid lambda$make$1(Function makeStill, Mutable thisMutable) {
            return IEFluid.makeFluid(makeStill, (FluidEntry)thisMutable.getValue());
        }
    }
}

