/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.client.gui.DerrickScreen;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.network.MessageDerrick;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;

public class DerrickSettingsScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick_settings.png");
    private final int xSize = 158;
    private final int ySize = 176;
    private int guiLeft;
    private int guiTop;
    private PipeConfig pipeConfig;
    final DerrickScreen derrickScreen;

    public DerrickSettingsScreen(DerrickScreen derrickScreen) {
        super((Component)Component.m_237113_((String)"DerrickSettings"));
        this.derrickScreen = derrickScreen;
    }

    protected void m_7856_() {
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.pipeConfig = new PipeConfig(this.derrickScreen.tile, this.guiLeft + 10, this.guiTop + 10, 138, 138, 69, 69, 2);
        this.m_142416_((GuiEventListener)this.pipeConfig);
        MutableComponent set = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.set");
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize / 2 - 65, this.guiTop + this.ySize - 25, 40, 20, (Component)set, b -> MessageDerrick.sendToServer(this.derrickScreen.tile.m_58899_(), this.pipeConfig.getGrid()), (button, matrix, mx, my) -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.set.desc"));
            this.m_169388_(matrix, list, Optional.empty(), mx, my);
        }));
        MutableComponent reset = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.reset");
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize / 2 - 20, this.guiTop + this.ySize - 25, 40, 20, (Component)reset, b -> this.pipeConfig.reset(this.derrickScreen.tile), (button, matrix, mx, my) -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.reset.desc"));
            this.m_169388_(matrix, list, Optional.empty(), mx, my);
        }));
        MutableComponent close = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.close");
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize / 2 + 25, this.guiTop + this.ySize - 25, 40, 20, (Component)close, b -> this.m_7379_(), (button, matrix, mx, my) -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.close.desc"));
            this.m_169388_(matrix, list, Optional.empty(), mx, my);
        }));
    }

    public void m_6305_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTick) {
        this.background(matrix, mouseX, mouseY, partialTick);
        super.m_6305_(matrix, mouseX, mouseY, partialTick);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (mouseX >= this.pipeConfig.f_93620_ && mouseX < this.pipeConfig.f_93620_ + this.pipeConfig.m_5711_() && mouseY >= this.pipeConfig.f_93621_ && mouseY < this.pipeConfig.f_93621_ + this.pipeConfig.m_93694_()) {
            int x = (mouseX - this.pipeConfig.f_93620_) / this.pipeConfig.getGridScale();
            int y = (mouseY - this.pipeConfig.f_93621_) / this.pipeConfig.getGridScale();
            int px = x - this.pipeConfig.getGrid().getWidth() / 2;
            int py = y - this.pipeConfig.getGrid().getHeight() / 2;
            if (px >= -2 && px <= 2 && py >= -2 && py <= 2) {
                tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.derrickishere"));
            } else {
                MutableComponent d = Component.m_237119_();
                if (py < 0) {
                    d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.north"));
                } else if (py > 0) {
                    d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.south"));
                }
                if (px != 0) {
                    if (py != 0) {
                        d.m_7220_((Component)Component.m_237113_((String)"-"));
                    }
                    if (px < 0) {
                        d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.west"));
                    } else if (px > 0) {
                        d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.east"));
                    }
                }
                tooltip.add(d.m_130940_(ChatFormatting.UNDERLINE));
            }
            ColumnPos tilePos = Utils.toColumnPos(this.derrickScreen.tile.m_58899_());
            tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "X: %d \u00c2\u00a77(%d)", tilePos.f_140723_() + px, px)));
            tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "Z: %d \u00c2\u00a77(%d)", tilePos.f_140724_() + py, py)));
            int i = this.pipeConfig.getGrid().get(x, y);
            if (i > 0) {
                switch (i) {
                    case 1: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.normal"));
                        break;
                    }
                    case 2: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated"));
                        break;
                    }
                    case 3: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated_fixed"));
                    }
                }
            }
            int xa = this.pipeConfig.f_93620_ + x * this.pipeConfig.getGridScale();
            int ya = this.pipeConfig.f_93621_ + y * this.pipeConfig.getGridScale();
            GuiComponent.m_93172_((PoseStack)matrix, (int)xa, (int)ya, (int)(xa + this.pipeConfig.getGridScale()), (int)(ya + this.pipeConfig.getGridScale()), (int)Integer.MAX_VALUE);
        }
        if (!tooltip.isEmpty()) {
            this.m_96597_(matrix, tooltip, mouseX, mouseY);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.derrickScreen);
        this.pipeConfig.dispose();
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int width, int height) {
        PipeConfig oldGrid = this.pipeConfig;
        super.m_6574_(minecraft, width, height);
        this.pipeConfig.copyDataFrom(oldGrid);
        oldGrid.dispose();
    }

    private void background(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        ClientUtils.bindTexture((ResourceLocation)GUI_TEXTURE);
        this.m_93228_(matrix, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }
}

