/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.dyn;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureWrapper {
    public static final Cache<UUID, DynamicTextureWrapper> DYN_TEXTURE_CACHE = CacheBuilder.newBuilder().removalListener(s -> {
        DynamicTextureWrapper wrapper = (DynamicTextureWrapper)s.getValue();
        wrapper.dispose();
        ImmersivePetroleum.log.debug("Disposed survey result texture {}", (Object)wrapper.rl);
    }).expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(50L).build();
    public final int width;
    public final int height;
    @Nonnull
    public final UUID uuid;
    public final DynamicTexture texture;
    public final RenderType renderType;
    private final ResourceLocation rl;

    @Nullable
    public static DynamicTextureWrapper getOrCreate(int width, int height, @Nonnull SurveyScan scan) {
        if (scan == null || scan.getUuid() == null) {
            return null;
        }
        DynamicTextureWrapper tex = (DynamicTextureWrapper)DYN_TEXTURE_CACHE.getIfPresent((Object)scan.getUuid());
        if (tex == null || tex.texture.m_117991_() == null) {
            tex = new DynamicTextureWrapper(width, height, scan.getUuid());
            DYN_TEXTURE_CACHE.invalidate((Object)scan.getUuid());
            DYN_TEXTURE_CACHE.put((Object)scan.getUuid(), (Object)tex);
            tex.write(scan.getData());
            ImmersivePetroleum.log.debug("Created survey result texture {}", (Object)tex.rl);
        }
        return tex;
    }

    public static void clearCache() {
        DYN_TEXTURE_CACHE.invalidateAll();
        DYN_TEXTURE_CACHE.cleanUp();
    }

    private DynamicTextureWrapper(int width, int height, @Nonnull UUID uuid) {
        Objects.requireNonNull(uuid, "Non-null UUID expected.");
        this.width = width;
        this.height = height;
        this.uuid = uuid;
        this.texture = new DynamicTexture(width, height, true);
        this.rl = ResourceUtils.ip("dyntexture/" + uuid);
        MCUtil.getTextureManager().m_118495_(this.rl, (AbstractTexture)this.texture);
        this.renderType = RenderType.m_110497_((ResourceLocation)this.rl);
    }

    public void write(byte[] mapData) {
        if (mapData == null || mapData.length != this.width * this.height) {
            return;
        }
        if (this.texture.m_117991_() != null) {
            NativeImage image = this.texture.m_117991_();
            for (int y = 0; y < this.width; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int b = mapData[y * this.height + x] & 0xFF;
                    int rgba = b << 16 | b << 8 | b;
                    image.m_84988_(x, y, 0xFF000000 | rgba);
                }
            }
            this.texture.m_117985_();
        }
    }

    public boolean isDisposed() {
        return this.texture.m_117991_() == null;
    }

    public void dispose() {
        this.texture.close();
    }
}

