/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.FlarestackTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FlarestackBlock
extends IPBlockBase
implements EntityBlock {
    private static final Material material = new Material(MaterialColor.f_76404_, false, false, true, true, false, false, PushReaction.BLOCK);
    public static final BooleanProperty SLAVE = BooleanProperty.m_61465_((String)"slave");
    static VoxelShape SHAPE_SLAVE;
    static VoxelShape SHAPE_MASTER;

    public FlarestackBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(3.0f, 15.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new FlarestackBlockItem(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLAVE});
    }

    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    @Override
    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (Utils.isScrewdriver((ItemStack)player.m_21120_(handIn))) {
            BlockEntity te;
            if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
                pos = pos.m_121945_(Direction.DOWN);
            }
            if (!worldIn.f_46443_ && (te = worldIn.m_7702_(pos)) instanceof FlarestackTileEntity) {
                FlarestackTileEntity flare = (FlarestackTileEntity)te;
                flare.invertRedstone();
                ChatUtils.sendServerNoSpamMessages((Player)player, (Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (flare.isRedstoneInverted() ? "invertedOn" : "invertedOff"))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(@Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            worldIn.m_46961_(pos.m_7918_(0, -1, 0), !player.m_7500_());
        } else {
            worldIn.m_46961_(pos.m_7918_(0, 1, 0), false);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Override
    public void m_6402_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (!worldIn.f_46443_) {
            worldIn.m_46597_(pos.m_121945_(Direction.UP), (BlockState)state.m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void m_7892_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue() && !entityIn.m_5825_()) {
            entityIn.m_6469_(DamageSource.f_19309_, 1.0f);
        }
    }

    @Nonnull
    public List<ItemStack> m_7381_(BlockState state, @Nonnull LootContext.Builder builder) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            return Collections.emptyList();
        }
        return super.m_7381_(state, builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            if (SHAPE_SLAVE == null) {
                VoxelShape s0 = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
                VoxelShape s1 = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375);
                SHAPE_SLAVE = Shapes.m_83113_((VoxelShape)s0, (VoxelShape)s1, (BooleanOp)BooleanOp.f_82695_);
            }
            return SHAPE_SLAVE;
        }
        if (SHAPE_MASTER == null) {
            VoxelShape s0 = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
            VoxelShape s1 = Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
            SHAPE_MASTER = Shapes.m_83113_((VoxelShape)s0, (VoxelShape)s1, (BooleanOp)BooleanOp.f_82695_);
        }
        return SHAPE_MASTER;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)SLAVE)).booleanValue()) {
            return null;
        }
        return ((BlockEntityType)IPTileTypes.FLARE.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            return null;
        }
        return FlarestackBlock.createCommonTicker(level.f_46443_, type, IPTileTypes.FLARE);
    }

    public static class FlarestackBlockItem
    extends IPBlockItemBase {
        public FlarestackBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().m_41491_(ImmersivePetroleum.creativeTab));
        }

        protected boolean m_40610_(@Nonnull BlockPlaceContext con, @Nonnull BlockState state) {
            if (super.m_40610_(con, state)) {
                BlockPos otherPos = con.m_8083_().m_121945_(Direction.UP);
                BlockState otherState = con.m_43725_().m_8055_(otherPos);
                return otherState.m_60795_();
            }
            return false;
        }
    }
}

