/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.fluids;

import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.fluids.IPFluid;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class NapalmFluid
extends IPFluid {
    public NapalmFluid(IPFluid.IPFluidEntry entry) {
        super(entry);
    }

    @Override
    public int m_6718_(@Nonnull LevelReader p_205569_1_) {
        return 10;
    }

    @Override
    public boolean hasCustomSlowdown() {
        return true;
    }

    @Override
    public double getEntitySlowdown() {
        return 0.7;
    }

    public static void processFire(IPFluid.IPFluidEntry entry, Level world, BlockPos pos) {
        ResourceLocation d = world.m_46472_().m_135782_();
        List list = CommonEventHandler.napalmPositions.computeIfAbsent(d, f -> new ArrayList());
        list.add(pos);
        world.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
        for (Direction facing : Direction.values()) {
            BlockPos notifyPos = pos.m_121945_(facing);
            if (!world.m_8055_(notifyPos).m_60713_((Block)entry.block().get())) continue;
            list.add(notifyPos);
        }
    }

    public static class NapalmFluidBlock
    extends IPFluid.IPFluidBlock {
        public NapalmFluidBlock(IPFluid.IPFluidEntry entry, BlockBehaviour.Properties props) {
            super(entry, props);
        }

        public void m_6807_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
            for (Direction facing : Direction.values()) {
                BlockPos notifyPos = pos.m_121945_(facing);
                if (!(world.m_8055_(notifyPos).m_60734_() instanceof FireBlock) && world.m_8055_(notifyPos).m_60767_() != Material.f_76309_) continue;
                world.m_46597_(pos, Blocks.f_50083_.m_49966_());
                break;
            }
            super.m_6807_(state, world, pos, oldState, isMoving);
        }

        public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
            ResourceLocation d;
            if (!(!(world.m_8055_(fromPos).m_60734_() instanceof FireBlock) && world.m_8055_(fromPos).m_60767_() != Material.f_76309_ || CommonEventHandler.napalmPositions.containsKey(d = world.m_46472_().m_135782_()) && CommonEventHandler.napalmPositions.get(d).contains(fromPos))) {
                NapalmFluid.processFire(this.entry, world, pos);
            }
            super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        }
    }
}

