/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageProjectorSync
implements INetMessage {
    boolean forServer;
    CompoundTag nbt;
    InteractionHand hand;

    public static void sendToServer(Settings settings, InteractionHand hand) {
        IPPacketHandler.sendToServer(new MessageProjectorSync(settings, hand, true));
    }

    public static void sendToClient(Player player, Settings settings, InteractionHand hand) {
        IPPacketHandler.sendToPlayer(player, new MessageProjectorSync(settings, hand, false));
    }

    public MessageProjectorSync(Settings settings, InteractionHand hand, boolean toServer) {
        this(settings.toNbt(), hand, toServer);
    }

    public MessageProjectorSync(CompoundTag nbt, InteractionHand hand, boolean toServer) {
        this.nbt = nbt;
        this.forServer = toServer;
        this.hand = hand;
    }

    public MessageProjectorSync(FriendlyByteBuf buf) {
        this.nbt = buf.m_130260_();
        this.forServer = buf.readBoolean();
        this.hand = InteractionHand.values()[buf.readByte()];
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.writeBoolean(this.forServer);
        buf.writeByte(this.hand.ordinal());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player;
            ItemStack held;
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == this.getSide() && con.getSender() != null && (held = (player = con.getSender()).m_21120_(this.hand)).m_150930_((Item)IPContent.Items.PROJECTOR.get())) {
                Settings settings = new Settings(this.nbt);
                settings.applyTo(held);
            }
        });
    }

    LogicalSide getSide() {
        return this.forServer ? LogicalSide.SERVER : LogicalSide.CLIENT;
    }
}

