/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.zeith.hammerlib.client.utils.Scissors;
import org.zeith.hammerlib.client.utils.TexturePixelGetter;
import org.zeith.hammerlib.client.utils.UV;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.improvableskills.ImprovableSkills;
import org.zeith.improvableskills.api.IGuiSkillDataConsumer;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.SkillTex;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.client.gui.GuiSkillViewer;
import org.zeith.improvableskills.client.gui.GuiSkillsBook;
import org.zeith.improvableskills.client.gui.base.GuiTabbable;
import org.zeith.improvableskills.client.rendering.OnTopEffects;
import org.zeith.improvableskills.client.rendering.ote.OTEFadeOutUV;
import org.zeith.improvableskills.client.rendering.ote.OTESparkle;
import org.zeith.improvableskills.client.rendering.ote.OTETooltip;
import org.zeith.improvableskills.custom.pagelets.PageletAbilities;
import org.zeith.improvableskills.init.SoundsIS;

public class GuiAbilityBook
extends GuiTabbable<PageletAbilities>
implements IGuiSkillDataConsumer {
    public final UV gui1;
    public final UV inactivity = GuiSkillViewer.CROSS;
    public double scrolledPixels;
    public double prevScrolledPixels;
    public int row = 6;
    public Map<SkillTex<PlayerAbilityBase>, Tuple2.Mutable2<Integer, Integer>> hoverAnims = new HashMap<SkillTex<PlayerAbilityBase>, Tuple2.Mutable2<Integer, Integer>>();
    public int cHover;
    public PlayerSkillData data;
    public List<SkillTex<PlayerAbilityBase>> texes = new ArrayList<SkillTex<PlayerAbilityBase>>();
    protected double dWheel;

    public GuiAbilityBook(PageletAbilities pagelet, PlayerSkillData data) {
        super(pagelet);
        this.data = data;
        this.xSize = 195;
        this.ySize = 168;
        this.gui1 = new UV(GuiSkillsBook.PAPER_TEXTURE, 0.0f, 0.0f, (float)this.xSize, (float)this.ySize);
        ImprovableSkills.ABILITIES().getValues().stream().sorted(Comparator.comparing(t -> t.getLocalizedName(data).getString())).filter(data::hasAbility).forEach(skill -> this.texes.add(skill.tex));
    }

    @Override
    protected void drawBack(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        this.setWhiteColor();
        this.gui1.render(pose, (float)this.guiLeft, (float)this.guiTop);
        int co = this.texes.size();
        RenderSystem.m_69478_();
        Scissors.begin((int)this.guiLeft, (int)(this.guiTop + 5), (int)this.xSize, (int)(this.ySize - 10));
        int cht = 0;
        int chtni = 0;
        boolean singleHover = false;
        for (int i = 0; i < co; ++i) {
            boolean hover;
            int j = i % co;
            SkillTex<PlayerAbilityBase> tex = this.texes.get(j);
            Tuple2.Mutable2 hovt = this.hoverAnims.get(tex);
            if (hovt == null) {
                hovt = new Tuple2.Mutable2((Object)0, (Object)0);
                this.hoverAnims.put(tex, (Tuple2.Mutable2<Integer, Integer>)hovt);
            }
            int cHoverTime = (Integer)hovt.a();
            int cHoverTimePrev = (Integer)hovt.b();
            double x = i % this.row * 28 + this.guiLeft + 16;
            double y = (double)(i / this.row * 28) - (this.prevScrolledPixels + (this.scrolledPixels - this.prevScrolledPixels) * (double)partialTicks);
            if (y < -24.0) continue;
            if (y > (double)(this.ySize - 14)) break;
            boolean bl = hover = (double)mouseX >= x && (double)mouseX < x + 24.0 && (double)mouseY >= (y += (double)(this.guiTop + 9)) && (double)mouseY < y + 24.0;
            if (hover) {
                this.cHover = i;
                singleHover = true;
                chtni = cHoverTime;
            }
            if (cHoverTime > 0) {
                cht = (int)((float)cHoverTimePrev + (float)(cHoverTime - cHoverTimePrev) * partialTicks);
                UV norm = tex.toUV(false);
                UV hov = tex.toUV(true);
                norm.render(pose, x, y, 24.0f, 24.0f);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.sin(Math.toRadians((float)cht / 255.0f * 90.0f))));
                hov.render(pose, x, y, 24.0f, 24.0f);
                this.setWhiteColor();
            } else {
                tex.toUV(false).render(pose, x, y, 24.0f, 24.0f);
            }
            if (!((PlayerAbilityBase)tex.owner).showDisabledIcon(this.data)) continue;
            this.inactivity.render(pose, x + 9.5, y + 21.0, 5.0f, 5.0f);
        }
        if (!singleHover) {
            this.cHover = -1;
        }
        Scissors.end();
        this.setBlueColor();
        this.gui2.render(pose, (double)this.guiLeft, (double)this.guiTop, (float)this.xSize, (float)this.ySize);
        this.setWhiteColor();
        if (this.cHover >= 0 && chtni >= 200) {
            SkillTex<PlayerAbilityBase> tex = this.texes.get(this.cHover % co);
            OTETooltip.showTooltip(new Component[]{((PlayerAbilityBase)tex.owner).getLocalizedName(this.data)});
        }
    }

    public boolean m_6050_(double x, double y, double dWheel) {
        this.dWheel += dWheel;
        return true;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.prevScrolledPixels = this.scrolledPixels;
        int co = this.texes.size();
        float maxPixels = 28 * (co / this.row) - 196;
        int dw = (int)this.dWheel * 120;
        if (dw != 0) {
            this.dWheel = 0.0;
            this.scrolledPixels -= (double)((float)dw / 15.0f);
            this.scrolledPixels = Math.max(Math.min(this.scrolledPixels, (double)maxPixels), 0.0);
        }
        for (int i = 0; i < co; ++i) {
            int cHoverTime;
            int j = i % co;
            SkillTex<PlayerAbilityBase> tex = this.texes.get(j);
            Tuple2.Mutable2 hovt = this.hoverAnims.get(tex);
            if (hovt == null) {
                hovt = new Tuple2.Mutable2((Object)0, (Object)0);
                this.hoverAnims.put(tex, (Tuple2.Mutable2<Integer, Integer>)hovt);
            }
            int pht = cHoverTime = ((Integer)hovt.a()).intValue();
            if (this.cHover == i) {
                cHoverTime = Math.min(cHoverTime + 55, 255);
                double x = i % this.row * 28 + this.guiLeft + 16;
                double y = (double)(i / this.row * 28) - this.scrolledPixels;
                y += (double)(this.guiTop + 9);
                Random r = new Random();
                if (r.nextInt(5) == 0) {
                    int[] rgbs = TexturePixelGetter.getAllColors((ResourceLocation)tex.toUV((boolean)true).path);
                    int col = rgbs[r.nextInt(rgbs.length)];
                    double tx = x + 2.0 + (double)(r.nextFloat() * 20.0f);
                    double ty = y + 2.0 + (double)(r.nextFloat() * 20.0f);
                    OnTopEffects.effects.add(new OTESparkle(tx, ty, tx, ty, 11, col));
                }
            } else {
                cHoverTime = Math.max(cHoverTime - 15, 0);
            }
            hovt.setA((Object)cHoverTime);
            hovt.setB((Object)pht);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.cHover >= 0) {
            PlayerAbilityBase skill = (PlayerAbilityBase)this.texes.get((int)(this.cHover % this.texes.size())).owner;
            skill.onClickClient((Player)this.f_96541_.f_91074_, mouseButton);
            int co = this.texes.size();
            for (int i = 0; i < co; ++i) {
                int j = i % co;
                SkillTex<PlayerAbilityBase> tex = this.texes.get(j);
                double x = i % this.row * 28 + this.guiLeft + 16;
                double y = (double)(i / this.row * 28) - (this.prevScrolledPixels + (this.scrolledPixels - this.prevScrolledPixels) * (double)this.f_96541_.getPartialTick());
                if (tex != skill.tex) continue;
                new OTEFadeOutUV(tex.toUV(true), 24.0f, 24.0f, x, y + (double)this.guiTop + 9.0, 2);
            }
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundsIS.PAGE_TURNS, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void applySkillData(PlayerSkillData data) {
        this.data = data;
    }
}

