/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.compat.jei;

import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.zeith.improvableskills.api.RecipeParchmentFragment;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.client.gui.abil.anvil.AnvilMenuPortable;
import org.zeith.improvableskills.client.gui.abil.crafting.CraftingMenuPortable;
import org.zeith.improvableskills.compat.jei.parchf.ParchmentFusionCategory;
import org.zeith.improvableskills.custom.items.ItemAbilityScroll;
import org.zeith.improvableskills.custom.items.ItemSkillScroll;
import org.zeith.improvableskills.init.GuiHooksIS;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.init.RecipeTypesIS;

@JeiPlugin
public class JeiIS3
implements IModPlugin {
    public static final ResourceLocation JEI = new ResourceLocation("improvableskills", "jei");
    public static final RecipeType<RecipeParchmentFragment> PARCHMENTS = RecipeType.create((String)"improvableskills", (String)"parcment_fusion", RecipeParchmentFragment.class);

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Minecraft.m_91087_();
        ErrorUtil.checkNotNull((Object)minecraft, (String)"minecraft");
        ClientLevel world = minecraft.f_91073_;
        ErrorUtil.checkNotNull((Object)world, (String)"minecraft world");
        RecipeManager recipeManager = world.m_7465_();
        registration.addRecipes(PARCHMENTS, recipeManager.m_44013_(RecipeTypesIS.PARCHMENT_FRAGMENT_TYPE));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsIS.SKILLS_BOOK), new RecipeType[]{PARCHMENTS});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AnvilMenuPortable.class, GuiHooksIS.REPAIR, RecipeTypes.ANVIL, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(CraftingMenuPortable.class, GuiHooksIS.CRAFTING, RecipeTypes.CRAFTING, 1, 9, 10, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ParchmentFusionCategory(registry.getJeiHelpers())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemsIS.ABILITY_SCROLL, (itemStack, context) -> Optional.ofNullable(ItemAbilityScroll.getAbilityFromScroll(itemStack)).map(PlayerAbilityBase::getRegistryName).map(ResourceLocation::toString).orElse("null"));
        registration.registerSubtypeInterpreter((Item)ItemsIS.SKILL_SCROLL, (itemStack, context) -> Optional.ofNullable(ItemSkillScroll.getSkillFromScroll(itemStack)).map(PlayerSkillBase::getRegistryName).map(ResourceLocation::toString).orElse("null"));
    }

    public ResourceLocation getPluginUid() {
        return JEI;
    }
}

