/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.items.ConsumableItem;
import org.zeith.improvableskills.init.RecipeTypesIS;

public class RecipeParchmentFragment
implements Recipe<Container> {
    public final ResourceLocation id;
    public final List<Ingredient> ingredients;
    public final ItemStack result;

    public RecipeParchmentFragment(ResourceLocation id, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.result = result;
        this.ingredients = ingredients;
    }

    public List<ConsumableItem> getConsumableIngredients() {
        return this.ingredients.stream().map(i -> new ConsumableItem(1, new Ingredient[]{i})).toList();
    }

    public boolean m_5818_(Container ctr, Level lvl) {
        return false;
    }

    public ItemStack m_5874_(Container ctr) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeTypesIS.PARCHMENT_FRAGMENT_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypesIS.PARCHMENT_FRAGMENT_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeParchmentFragment> {
        public RecipeParchmentFragment fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> items = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (items.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new RecipeParchmentFragment(id, result, items);
        }

        @Nullable
        public RecipeParchmentFragment fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int i = buf.m_130242_();
            NonNullList items = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < items.size(); ++j) {
                items.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            return new RecipeParchmentFragment(id, result, (NonNullList<Ingredient>)items);
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeParchmentFragment r) {
            buf.m_130130_(r.ingredients.size());
            for (Ingredient ingredient : r.ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(r.result);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray arr) {
            NonNullList lst = NonNullList.m_122779_();
            for (int i = 0; i < arr.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)arr.get(i));
                if (ingredient.m_43947_()) continue;
                lst.add((Object)ingredient);
            }
            return lst;
        }
    }
}

