/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.client.utils.TexturePixelGetter;
import org.zeith.hammerlib.client.utils.UV;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.XPUtil;
import org.zeith.improvableskills.api.IGuiSkillDataConsumer;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.client.gui.GuiCentered;
import org.zeith.improvableskills.client.gui.GuiSkillsBook;
import org.zeith.improvableskills.client.gui.base.GuiCustomButton;
import org.zeith.improvableskills.client.rendering.OnTopEffects;
import org.zeith.improvableskills.client.rendering.ote.OTEFadeOutButton;
import org.zeith.improvableskills.client.rendering.ote.OTEFadeOutUV;
import org.zeith.improvableskills.client.rendering.ote.OTESparkle;
import org.zeith.improvableskills.client.rendering.ote.OTETooltip;
import org.zeith.improvableskills.init.SoundsIS;
import org.zeith.improvableskills.net.PacketLvlDownSkill;
import org.zeith.improvableskills.net.PacketLvlUpSkill;
import org.zeith.improvableskills.net.PacketSetSkillActivity;

public class GuiSkillViewer
extends GuiCentered
implements IGuiSkillDataConsumer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("improvableskills", "textures/gui/skills_gui_overlay.png");
    public static final UV CROSS = new UV(TEXTURE, 196.0f, 24.0f, 20.0f, 20.0f);
    public static final UV TICK = new UV(TEXTURE, 196.0f, 44.0f, 20.0f, 20.0f);
    final GuiSkillsBook parent;
    public PlayerSkillData data;
    final Style fontStyle;
    final PlayerSkillBase skill;
    int mouseX;
    int mouseY;
    boolean forbidden;
    private static final ResourceLocation ALT_FONT = new ResourceLocation("minecraft", "alt");
    GuiCustomButton btnUpgrade;
    GuiCustomButton btnDegrade;
    GuiCustomButton btnBack;
    GuiCustomButton btnToggle;

    public GuiSkillViewer(GuiSkillsBook parent, PlayerSkillBase skill) {
        this.parent = parent;
        this.skill = skill;
        this.data = parent.data;
        this.f_96541_ = Minecraft.m_91087_();
        this.fontStyle = skill.isVisible(parent.data) ? Style.f_131099_ : Style.f_131099_.m_131150_(ALT_FONT);
        this.xSize = 200;
        this.ySize = 150;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.parent.m_7856_();
        int gl = this.guiLeft;
        int gt = this.guiTop;
        this.btnUpgrade = (GuiCustomButton)this.m_142416_((GuiEventListener)new GuiCustomButton(0, gl + 10, gt + 124, 75, 20, (Component)Component.m_237115_((String)"button.improvableskills:upgrade"), this::actionPerformed));
        this.btnDegrade = (GuiCustomButton)this.m_142416_((GuiEventListener)new GuiCustomButton(1, gl + 116, gt + 124, 75, 20, (Component)Component.m_237115_((String)"button.improvableskills:degrade"), this::actionPerformed));
        this.btnBack = (GuiCustomButton)this.m_142416_((GuiEventListener)new GuiCustomButton(2, gl + (this.xSize - 20) / 2, gt + 124, 20, 20, " ", this::actionPerformed).setCustomClickSound(SoundsIS.PAGE_TURNS));
        this.btnToggle = (GuiCustomButton)this.m_142416_((GuiEventListener)new GuiCustomButton(3, gl + this.xSize - 30, gt + 14, 20, 20, " ", this::actionPerformed).setCustomClickSound(SoundsIS.PAGE_TURNS));
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.forbidden = !this.skill.isVisible(this.parent.data);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        short nextSkillLevel = (short)(this.data.getSkillLevel(this.skill) + 1);
        int xp = this.skill.getXPToUpgrade(this.data, nextSkillLevel);
        int xp2 = this.skill.getXPToDowngrade(this.data, (short)(nextSkillLevel - 2));
        this.btnToggle.f_93623_ = nextSkillLevel > 1;
        boolean notMaxedOut = nextSkillLevel <= this.skill.getMaxLevel() && !this.forbidden;
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        FXUtils.bindTexture((ResourceLocation)TEXTURE);
        pose.m_85836_();
        pose.m_85837_((double)(this.guiLeft + (this.xSize - 20) / 2 + 2), (double)(this.guiTop + 126), 200.0);
        pose.m_85841_(1.5f, 1.5f, 1.0f);
        RenderUtils.drawTexturedModalRect((PoseStack)pose, (float)0.0f, (float)0.0f, (float)195.0f, (float)10.0f, (float)10.0f, (float)11.0f);
        pose.m_85849_();
        boolean active = this.data.isSkillActive(this.skill);
        pose.m_85836_();
        pose.m_85837_((double)(this.btnToggle.f_93620_ + 1), (double)(this.btnToggle.f_93621_ + 1), 200.0);
        pose.m_85841_(0.9f, 0.9f, 0.9f);
        RenderUtils.drawTexturedModalRect((PoseStack)pose, (float)0.0f, (float)0.0f, (float)GuiSkillViewer.CROSS.posX, (float)(GuiSkillViewer.CROSS.posY + (float)(active ? 20 : 0)), (float)20.0f, (float)20.0f);
        pose.m_85849_();
        GuiSkillViewer.m_93208_((PoseStack)pose, (Font)(this.forbidden ? this.f_96541_.f_243022_ : this.f_96547_), (String)I18n.m_118938_((String)"text.improvableskills:totalXP", (Object[])new Object[]{XPUtil.getXPTotal((Player)this.f_96541_.f_91074_)}), (int)(this.guiLeft + this.xSize / 2), (int)(this.guiTop + this.ySize + 2), (int)0x88FF00);
        this.btnUpgrade.f_93623_ = true;
        if (this.btnUpgrade.m_5953_(mouseX, mouseY) && notMaxedOut) {
            OTETooltip.showTooltip(new Component[]{Component.m_237113_((String)("-" + xp + " XP"))});
        }
        if (this.btnDegrade.m_5953_(mouseX, mouseY)) {
            OTETooltip.showTooltip(new Component[]{Component.m_237113_((String)("+" + xp2 + " XP"))});
        }
        this.btnUpgrade.f_93623_ = notMaxedOut && this.skill.canUpgrade(this.data);
        boolean bl = this.btnDegrade.f_93623_ = this.data.getSkillLevel(this.skill) > 0 && !this.forbidden;
        if (this.btnBack.m_5953_(mouseX, mouseY)) {
            OTETooltip.showTooltip(new Component[]{Component.m_237115_((String)"gui.back")});
        }
        if (this.btnToggle.m_5953_(mouseX, mouseY)) {
            OTETooltip.showTooltip(new Component[]{Component.m_237110_((String)("gui.improvableskills.toggle_skill." + (active ? "enabled" : "disabled")), (Object[])new Object[]{this.skill.getLocalizedName()})});
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        MutableComponent name = this.skill.getLocalizedName(this.data);
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        pose.m_85837_((double)this.guiLeft, (double)this.guiTop, 0.0);
        FXUtils.bindTexture((String)"improvableskills", (String)"textures/gui/skill_viewer.png");
        RenderUtils.drawTexturedModalRect((PoseStack)pose, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)this.xSize, (float)this.ySize);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.skill.tex.toUV(false).render(pose, 10.0, 6.0, 32.0f, 32.0f);
        short lev = this.data.getSkillLevel(this.skill);
        if (lev > 0) {
            UV hov = this.skill.tex.toUV(true);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)lev / (float)this.skill.getMaxLevel()));
            hov.render(pose, 10.0, 6.0, 32.0f, 32.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.f_96547_.m_92883_(pose, I18n.m_118938_((String)"text.improvableskills:level", (Object[])new Object[]{this.data.getSkillLevel(this.skill), this.skill.getMaxLevel()}), 44.0f, 30.0f, 0x555555);
        float scale = Math.min((float)((this.xSize - 48) / this.f_96547_.m_92852_((FormattedText)name)), 1.5f);
        Objects.requireNonNull(this.f_96547_);
        double flh = 9.0f * scale;
        pose.m_85837_(44.0, 6.0 + (24.0 - flh) / 2.0, 0.0);
        pose.m_85841_(scale, scale, 1.0f);
        this.f_96547_.m_92889_(pose, (Component)name, 0.0f, 0.0f, 0x555555);
        pose.m_85849_();
        int maxWid = 176;
        pose.m_85836_();
        pose.m_85837_(0.0, 2.0, 0.0);
        for (FormattedCharSequence formattedcharsequence : this.f_96547_.m_92923_((FormattedText)this.skill.getLocalizedDesc(this.data), maxWid)) {
            this.f_96547_.m_92877_(pose, formattedcharsequence, (float)(this.guiLeft + 12), (float)(this.guiTop + 42), 0xFFFFFF);
            pose.m_85837_(0.0, 9.0, 0.0);
        }
        pose.m_85849_();
    }

    protected void actionPerformed(Button button) {
        double ty;
        double tx;
        int col;
        int[] rgbs;
        if (!(button instanceof GuiCustomButton)) {
            return;
        }
        GuiCustomButton b = (GuiCustomButton)button;
        new OTEFadeOutButton(b, b.id == 2 ? 2 : 20);
        if (b.id == 2) {
            this.f_96541_.m_91152_((Screen)this.parent);
            new OTEFadeOutUV(new UV(TEXTURE, 195.0f, 10.0f, 10.0f, 11.0f), 15.0f, 16.5f, this.guiLeft + (this.xSize - 20) / 2 + 2, this.guiTop + 126, 2);
        }
        if (b.id == 3) {
            boolean newState = !this.data.isSkillActive(this.skill);
            this.data.setSkillState(this.skill, newState);
            new OTEFadeOutUV(new UV(TEXTURE, GuiSkillViewer.CROSS.posX, GuiSkillViewer.CROSS.posY + (float)(newState ? 20 : 0), 20.0f, 20.0f), 18.0f, 18.0f, b.f_93620_ + 1, b.f_93621_ + 1, 20);
            Network.sendToServer((IPacket)new PacketSetSkillActivity(this.skill.getRegistryName(), newState));
        }
        if (b.id == 0) {
            Random r = new Random();
            rgbs = TexturePixelGetter.getAllColors((ResourceLocation)this.skill.tex.toUV((boolean)true).path);
            col = rgbs[r.nextInt(rgbs.length)];
            tx = (float)(this.guiLeft + 10) + (float)r.nextInt(64) / 2.0f;
            ty = (float)(this.guiTop + 6) + (float)r.nextInt(64) / 2.0f;
            OnTopEffects.effects.add(new OTESparkle(this.mouseX, this.mouseY, tx, ty, 30, col));
            Network.sendToServer((IPacket)new PacketLvlUpSkill(this.skill));
        }
        if (b.id == 1) {
            Random r = new Random();
            rgbs = TexturePixelGetter.getAllColors((ResourceLocation)this.skill.tex.toUV((boolean)true).path);
            col = rgbs[r.nextInt(rgbs.length)];
            tx = (float)(this.guiLeft + 10) + (float)r.nextInt(64) / 2.0f;
            ty = (float)(this.guiTop + 6) + (float)r.nextInt(64) / 2.0f;
            OnTopEffects.effects.add(new OTESparkle(tx, ty, this.mouseX, this.mouseY, 30, col));
            Network.sendToServer((IPacket)new PacketLvlDownSkill(this.skill));
        }
    }

    @Override
    public void applySkillData(PlayerSkillData data) {
        this.data = data;
        this.parent.data = data;
    }

    public void drawHoveringText(PoseStack pose, String text, int x, int y) {
        this.m_96602_(pose, (Component)Component.m_237113_((String)text).m_130948_(this.forbidden ? Style.f_131099_.m_131150_(ALT_FONT) : Style.f_131099_), x, y);
    }
}

