/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.AI.SimpleAnimationGoal;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Boss_monster;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.CMBossInfoServer;
import com.github.L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.projectile.Ancient_Desert_Stele_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.EarthQuake_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import com.github.L_Ender.lionfishapi.server.animation.LegSolver;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;

public class Ancient_Remnant_Entity
extends Boss_monster {
    public static final Animation REMNANT_BITE1 = Animation.create((int)61);
    public static final Animation REMNANT_BITE2 = Animation.create((int)67);
    public static final Animation REMNANT_CHARGE_PREPARE = Animation.create((int)125);
    public static final Animation REMNANT_TAIL_ATTACK1 = Animation.create((int)57);
    public static final Animation REMNANT_TAIL_ATTACK2 = Animation.create((int)55);
    public static final Animation REMNANT_LEFT_STOMP = Animation.create((int)47);
    public static final Animation REMNANT_RIGHT_STOMP = Animation.create((int)47);
    public static final Animation REMNANT_LEFT_STOMP_EXTRA = Animation.create((int)38);
    public static final Animation REMNANT_RIGHT_STOMP_EXTRA = Animation.create((int)38);
    public static final Animation REMNANT_ROAR = Animation.create((int)70);
    public static final Animation REMNANT_ROAR2 = Animation.create((int)100);
    public static final Animation REMNANT_PHASE_ROAR = Animation.create((int)100);
    public static final Animation REMNANT_TAIL_THREE = Animation.create((int)104);
    public static final Animation REMNANT_DEATH = Animation.create((int)158);
    private static final EntityDataAccessor<Boolean> CHARGE = SynchedEntityData.m_135353_(Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ACT = SynchedEntityData.m_135353_(Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> POWER = SynchedEntityData.m_135353_(Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final LegSolver legSolver = new LegSolver(new LegSolver.Leg[]{new LegSolver.Leg(0.0f, 0.75f, 4.0f, false), new LegSolver.Leg(0.0f, -0.75f, 4.0f, false)});
    private AttackMode mode = AttackMode.CIRCLE;
    public float chargeProgress;
    public float prevchargeProgress;
    public float activeProgress;
    public float prevactiveProgress;
    private int hunting_cooldown = 160;
    private int charge_cooldown = 0;
    private int roar_cooldown = 0;
    private int roar2_cooldown = 0;
    private int earthquake_cooldown = 0;
    private int stomp_cooldown = 0;
    public static final int CHARGE_COOLDOWN = 250;
    public static final int ROAR_COOLDOWN = 500;
    public static final int ROAR2_COOLDOWN = 200;
    public static final int EARTHQUAKE_COOLDOWN = 160;
    public static final int STOMP_COOLDOWN = 200;
    private final CMBossInfoServer bossEvent = new CMBossInfoServer(this.m_5446_(), (Mob)this, BossEvent.BossBarColor.WHITE, false, 7);
    public static final int NATURE_HEAL_COOLDOWN = 200;
    private int timeWithoutTarget;
    public int frame;
    public static final int MINE_COOLDOWN = 100;

    public Ancient_Remnant_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 500;
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        Ancient_Remnant_Entity.setConfigattribute((LivingEntity)this, CMConfig.AncientRemnantHealthMultiplier, CMConfig.AncientRemnantDamageMultiplier);
    }

    public float getStepHeight() {
        return 1.5f;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, REMNANT_BITE1, REMNANT_CHARGE_PREPARE, REMNANT_BITE2, REMNANT_TAIL_ATTACK1, REMNANT_TAIL_ATTACK2, REMNANT_LEFT_STOMP, REMNANT_RIGHT_STOMP, REMNANT_ROAR, REMNANT_TAIL_THREE, REMNANT_ROAR2, REMNANT_LEFT_STOMP_EXTRA, REMNANT_RIGHT_STOMP_EXTRA, REMNANT_PHASE_ROAR, REMNANT_DEATH};
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RemnantAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new AwakenGoal());
        this.f_21345_.m_25352_(1, (Goal)new RemnantChargeAttackGoal(this, REMNANT_CHARGE_PREPARE));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE1, 29));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE2, 25));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_LEFT_STOMP, 24));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_RIGHT_STOMP, 24));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_LEFT_STOMP_EXTRA, 19));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_RIGHT_STOMP_EXTRA, 19));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_ATTACK1, 13));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_ATTACK2, 11));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_ROAR, 11));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_THREE, 20));
        this.f_21345_.m_25352_(1, (Goal)new RemnantSteleAttackGoal(this, REMNANT_ROAR2, 29));
        this.f_21345_.m_25352_(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_PHASE_ROAR, 29));
        this.f_21345_.m_25352_(1, new SimpleAnimationGoal<Ancient_Remnant_Entity>(this, REMNANT_DEATH));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 120, true, true, ModEntities.buildPredicateFromTag(ModTag.ANCIENT_REMNANT_TARGET)));
    }

    public static AttributeSupplier.Builder ancient_remnant() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 70.0).m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public boolean m_142066_() {
        return this.getIsAct() && super.m_142066_();
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (this.getAnimation() == REMNANT_PHASE_ROAR && !source.m_19378_()) {
            return false;
        }
        if (range > CMConfig.AncientRemnantLongRangelimit * CMConfig.AncientRemnantLongRangelimit && !source.m_19378_()) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow) {
            return false;
        }
        if (this.activeProgress > 0.0f && !source.m_19378_()) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    @Override
    public float DamageCap() {
        return (float)CMConfig.AncientRemnantDamageCap;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE, (Object)false);
        this.f_19804_.m_135372_(IS_ACT, (Object)true);
        this.f_19804_.m_135372_(POWER, (Object)false);
    }

    public void setIsAct(boolean isAct) {
        this.f_19804_.m_135381_(IS_ACT, (Object)isAct);
    }

    public boolean getIsAct() {
        return (Boolean)this.f_19804_.m_135370_(IS_ACT);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Is_Act", this.getIsAct());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setIsAct(compound.m_128471_("Is_Act"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void setIsCharge(boolean isAnger) {
        this.f_19804_.m_135381_(CHARGE, (Object)isAnger);
    }

    public boolean getIsCharge() {
        return (Boolean)this.f_19804_.m_135370_(CHARGE);
    }

    public void setIsPower(boolean isPower) {
        this.f_19804_.m_135381_(POWER, (Object)isPower);
    }

    public boolean getIsPower() {
        return (Boolean)this.f_19804_.m_135370_(POWER);
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_.m_205070_(FluidTags.f_13131_);
    }

    public boolean m_6063_() {
        return false;
    }

    private void floatRemnant() {
        if (this.m_20069_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevchargeProgress = this.chargeProgress;
        this.prevactiveProgress = this.activeProgress;
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getIsCharge() && this.chargeProgress < 3.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.getIsCharge() && this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (!this.getIsAct() && this.activeProgress < 20.0f) {
            this.activeProgress += 1.0f;
        }
        if (this.getIsAct() && this.activeProgress > 0.0f) {
            this.activeProgress -= 1.0f;
        }
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        if (this.hunting_cooldown > 0) {
            --this.hunting_cooldown;
        }
        if (this.getIsAct() && this.f_19797_ % 4 == 0) {
            this.bossEvent.update();
        }
        if (this.charge_cooldown > 0) {
            --this.charge_cooldown;
        }
        if (this.roar_cooldown > 0) {
            --this.roar_cooldown;
        }
        if (this.roar2_cooldown > 0) {
            --this.roar2_cooldown;
        }
        if (this.earthquake_cooldown > 0) {
            --this.earthquake_cooldown;
        }
        if (this.stomp_cooldown > 0) {
            --this.stomp_cooldown;
        }
        LivingEntity target = this.m_5448_();
        if (!this.f_19853_.f_46443_) {
            if (this.timeWithoutTarget > 0) {
                --this.timeWithoutTarget;
            }
            if (target != null) {
                this.timeWithoutTarget = 200;
            }
            if (this.getAnimation() == NO_ANIMATION && this.timeWithoutTarget <= 0 && !this.m_21525_() && CMConfig.AncientRemnantNatureHealing > 0.0 && this.f_19797_ % 20 == 0) {
                this.m_5634_((float)CMConfig.AncientRemnantNatureHealing);
            }
        }
        if (this.getIsPower() && this.f_19797_ % 20 == 0) {
            this.m_5634_(2.0f);
        }
        this.floatRemnant();
        this.Charge();
        ++this.frame;
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (!this.m_20067_() && this.frame % 8 == 1 && (double)speed > 0.05 && this.getIsCharge() && this.m_20096_()) {
            this.m_5496_((SoundEvent)ModSounds.REMNANT_CHARGE_STEP.get(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
        }
        if (this.m_6084_() && this.getIsAct() && !this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.isPower() && !this.getIsPower()) {
            this.setAnimation(REMNANT_PHASE_ROAR);
        }
    }

    public boolean isPower() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    private void Charge() {
        if (this.getIsCharge()) {
            if (!this.f_19853_.f_46443_) {
                if (CMConfig.AncientRemnantBlockBreaking) {
                    this.ChargeBlockBreaking();
                } else if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                    this.ChargeBlockBreaking();
                }
            }
            if (this.f_19797_ % 4 == 0) {
                for (LivingEntity Lentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.5))) {
                    boolean flag;
                    if (this.m_7307_((Entity)Lentity) || Lentity instanceof Ancient_Remnant_Entity || Lentity == this || !(flag = Lentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((double)((float)this.m_21133_(Attributes.f_22281_) * 1.5f) + Math.min(this.m_21133_(Attributes.f_22281_) * 1.5, (double)Lentity.m_21233_() * CMConfig.RemnantChargeHpDamage)))) || !Lentity.m_20096_()) continue;
                    double d0 = Lentity.m_20185_() - this.m_20185_();
                    double d1 = Lentity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    float f = 1.5f;
                    Lentity.m_5997_(d0 / d2 * (double)f, 0.5, d1 / d2 * (double)f);
                }
            }
        }
    }

    private void ChargeBlockBreaking() {
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate == Blocks.f_50016_.m_49966_() || !blockstate.canEntityDestroy((BlockGetter)this.f_19853_, blockpos, (Entity)this) || blockstate.m_204336_(ModTag.REMNANT_IMMUNE) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            if (this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.f_19853_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, blockstate, 20);
                flag = this.f_19853_.m_46953_(blockpos, false, (Entity)this) || flag;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(this.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + this.f_19796_.m_188500_()) / 3.0, 0.2 + this.m_217043_().m_188583_() * 0.15, (-1.2 + this.f_19796_.m_188500_()) / 3.0)));
                this.f_19853_.m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            flag = this.f_19853_.m_46953_(blockpos, false, (Entity)this) || flag;
        }
    }

    public void m_8107_() {
        float ds;
        int l;
        super.m_8107_();
        if (this.getAnimation() == REMNANT_BITE1) {
            if (this.getAnimationTick() == 5) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 28) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.35f, (float)CMConfig.RemnantHpDamage, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_BITE2) {
            if (this.getAnimationTick() == 1) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 24) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.35f, (float)CMConfig.RemnantHpDamage, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_TAIL_ATTACK1) {
            if (this.getAnimationTick() == 3) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SWING.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (this.getAnimationTick() == 16) {
                this.TailAreaAttack(8.0f, 8.0f, 1.05f, 120.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 200, 100);
            }
        }
        if (this.getAnimation() == REMNANT_TAIL_ATTACK2) {
            if (this.getAnimationTick() == 1) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SWING.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (this.getAnimationTick() == 14) {
                this.TailAreaAttack(8.0f, 8.0f, 1.05f, 120.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 200, 100);
            }
        }
        if (this.getAnimation() == REMNANT_CHARGE_PREPARE) {
            if (this.getAnimationTick() == 1) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_PREPARE.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 15) {
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, -0.75f);
            }
            if (this.getAnimationTick() == 41) {
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, 0.75f);
            }
            if (this.getAnimationTick() == 62) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 132) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BREATHING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == REMNANT_ROAR) {
            if (this.getAnimationTick() == 14) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 60);
            }
            if (this.getAnimationTick() == 55) {
                for (int i = 0; i < 4; ++i) {
                    float angle = (float)i * (float)Math.PI / 2.0f;
                    double sx = this.m_20185_() + (double)(Mth.m_14089_((float)angle) * 8.0f);
                    double sy = this.m_20186_();
                    double sz = this.m_20189_() + (double)(Mth.m_14031_((float)angle) * 8.0f);
                    Sandstorm_Entity projectile = new Sandstorm_Entity(this.f_19853_, sx, sy, sz, 300, angle, this.m_20148_());
                    this.f_19853_.m_7967_((Entity)projectile);
                }
            }
        }
        if (this.getAnimation() == REMNANT_ROAR2 && this.getAnimationTick() == 23) {
            ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 60);
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
        }
        if (this.getAnimation() == REMNANT_PHASE_ROAR && this.getAnimationTick() == 23) {
            ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 60);
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            this.setIsPower(true);
        }
        if (this.getAnimation() == REMNANT_TAIL_THREE) {
            if (this.getAnimationTick() == 1) {
                this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SLAM.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 37) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.f_19796_.m_188503_(10), -0.75f);
            }
            if (this.getAnimationTick() == 55) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.f_19796_.m_188503_(10), -0.75f);
            }
            if (this.getAnimationTick() == 73) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.f_19796_.m_188503_(10), -0.75f);
            }
        }
        if (this.getAnimation() == REMNANT_LEFT_STOMP) {
            if (this.getAnimationTick() == 28) {
                this.StompParticle(0.9f, 1.3f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.m_5496_((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
                if (this.getIsPower()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, REMNANT_LEFT_STOMP_EXTRA);
                }
            }
            for (l = 28; l <= 45; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 26;
                int d2 = l - 25;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, 1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_LEFT_STOMP_EXTRA) {
            for (l = 2; l <= 19; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d2 = l + 1;
                float ds2 = (float)(l + d2) / 2.0f;
                this.StompDamage(0.4f, l, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds2, 1.3f);
            }
            if (this.getAnimationTick() == 19) {
                this.StompParticle(0.9f, 1.3f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.m_5496_((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
            }
            for (l = 19; l <= 36; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 17;
                int d2 = l - 16;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, 1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_RIGHT_STOMP) {
            if (this.getAnimationTick() == 28) {
                this.StompParticle(0.9f, -1.3f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.m_5496_((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
                if (this.getIsPower()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, REMNANT_RIGHT_STOMP_EXTRA);
                }
            }
            for (l = 28; l <= 45; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 26;
                int d2 = l - 25;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, -1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_RIGHT_STOMP_EXTRA) {
            for (l = 2; l <= 19; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d2 = l + 1;
                float ds3 = (float)(l + d2) / 2.0f;
                this.StompDamage(0.4f, l, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds3, -1.3f);
            }
            if (this.getAnimationTick() == 19) {
                this.StompParticle(0.9f, -1.3f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.m_5496_((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
            }
            for (l = 19; l <= 36; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 17;
                int d2 = l - 16;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, -1.3f, 80, 1.0f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 1.0f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, -1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_DEATH && (this.getAnimationTick() == 52 || this.getAnimationTick() == 62 || this.getAnimationTick() == 77)) {
            ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.05f, 0, 8);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == ModItems.NECKLACE_OF_THE_DESERT.get() && !this.getIsAct()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.setIsAct(true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ancient_Remnant_Entity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + Math.min(this.m_21133_(Attributes.f_22281_) * (double)damage, (double)(entityHit.m_21233_() * hpdamage))));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ancient_Remnant_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag || stunticks <= 0) continue;
            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), stunticks));
        }
    }

    private void TailAreaAttack(float range, float height, float height2, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getTailEntityLivingBaseNearby(range, height, height2, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ancient_Remnant_Entity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + Math.min(this.m_21133_(Attributes.f_22281_) * (double)damage, (double)(entityHit.m_21233_() * hpdamage))));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ancient_Remnant_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            if (stunticks > 0) {
                entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), stunticks));
            }
            double d0 = entityHit.m_20185_() - this.m_20185_();
            double d1 = entityHit.m_20189_() - this.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entityHit.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
        }
    }

    private void StompDamage(float spreadarc, int distance, int height, float mxy, float vec, float math, int shieldbreakticks, float damage, float hpdamage, float airborne) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0) + (double)(f * math);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0 + (double)(f1 * math));
            float factor = 1.0f - (float)distance / 12.0f;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY + height, hitZ);
            BlockState block = this.f_19853_.m_8055_(pos);
            while (block.m_60799_() != RenderShape.MODEL) {
                pos = pos.m_7495_();
                block = this.f_19853_.m_8055_(pos);
            }
            this.spawnBlocks(hitX, hitY + height, hitZ, (int)(this.m_20186_() - (double)height), block, px, pz, mxy, vx, vz, factor, shieldbreakticks, damage, hpdamage);
        }
    }

    private void spawnBlocks(int hitX, int hitY, int hitZ, int lowestYCheck, BlockState blockState, double px, double pz, float mxy, double vx, double vz, float factor, int shieldbreakticks, float damage, float hpdamage) {
        BlockPos blockpos = new BlockPos(hitX, hitY, hitZ);
        BlockState block = this.f_19853_.m_8055_(blockpos);
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (this.f_19853_.m_46859_(blockpos) || (voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) break;
            d0 = voxelshape.m_83297_(Direction.Axis.Y);
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14143_((float)lowestYCheck) - 1);
        Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.f_19853_, (double)hitX + 0.5, (double)blockpos.m_123342_() + d0 + 0.5, (double)hitZ + 0.5, blockState, 10);
        fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.04, 0.0);
        this.f_19853_.m_7967_((Entity)fallingBlockEntity);
        AABB selection = new AABB(px - 0.5, (double)blockpos.m_123342_() + d0 - 1.0, pz - 0.5, px + 0.5, (double)blockpos.m_123342_() + d0 + (double)mxy, pz + 0.5);
        List hit = this.f_19853_.m_45976_(LivingEntity.class, selection);
        for (LivingEntity entity : hit) {
            boolean flag;
            if (this.m_7307_((Entity)entity) || entity instanceof Ancient_Remnant_Entity || entity == this) continue;
            if (entity instanceof Player && entity.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK) && shieldbreakticks > 0) {
                Ancient_Remnant_Entity.disableShield(entity, shieldbreakticks);
            }
            if (!(flag = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)(entity.m_21233_() * hpdamage))))) continue;
            double magnitude = -4.0;
            double x = vx * (double)(1.0f - factor) * magnitude;
            double y = 0.0;
            if (entity.m_20096_()) {
                y += 0.15;
            }
            double z = vz * (double)(1.0f - factor) * magnitude;
            entity.m_20256_(entity.m_20184_().m_82520_(x, y, z));
        }
    }

    private void Stompsound(float distance, float math) {
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        this.f_19853_.m_7785_(this.m_20185_() + (double)distance * vecX + (double)(f * math), this.m_20186_(), this.m_20189_() + (double)distance * vecZ + (double)(f1 * math), (SoundEvent)ModSounds.REMNANT_SHOCKWAVE.get(), this.m_5720_(), 1.5f, 0.8f + this.m_217043_().m_188501_() * 0.1f, false);
    }

    public List<LivingEntity> getTailEntityLivingBaseNearby(double distanceX, double distanceMinY, double distanceMaxY, double distanceZ, double radius) {
        return this.getTailEntitiesNearby(LivingEntity.class, distanceX, distanceMinY, distanceMaxY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getTailEntitiesNearby(Class<T> entityClass, double dX, double dY, double pY, double dZ, double r) {
        return this.f_19853_.m_6443_(entityClass, new AABB(this.m_20185_() - dX, this.m_20186_() - dY, this.m_20189_() - dZ, this.m_20185_() + dX, this.m_20186_() + pY, this.m_20189_() + dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void StompParticle(float vec, float math) {
        if (this.f_19853_.f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                double extraX = 0.5 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 0.5 * (double)Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.f_19853_.m_8055_(hit.m_7495_());
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private void EarthQuakeSummon(float vec, int quake, float math) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float angle = 360.0f / (float)quake;
        for (int i = 0; i < quake; ++i) {
            EarthQuake_Entity peq = new EarthQuake_Entity(this.f_19853_, (LivingEntity)this);
            peq.setDamage((float)CMConfig.AncientRemnantEarthQuakeDamage);
            peq.m_37251_((Entity)this, 0.0f, angle * (float)i, 0.0f, 0.45f, 0.0f);
            peq.m_6034_(this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_(), this.m_20189_() + (double)vec * vecZ + (double)(f1 * math));
            this.f_19853_.m_7967_((Entity)peq);
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn.m_6095_().m_204039_(ModTag.TEAM_ANCIENT_REMNANT)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.getIsAct() ? (SoundEvent)ModSounds.REMNANT_IDLE.get() : super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.REMNANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REMNANT_DEATH.get();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)ModSounds.REMNANT_MUSIC.get();
    }

    @Override
    protected boolean canPlayMusic() {
        return super.canPlayMusic() && this.getIsAct();
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return REMNANT_DEATH;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    private static enum AttackMode {
        CIRCLE,
        MELEE;

    }

    class RemnantAttackGoal
    extends Goal {
        private final Ancient_Remnant_Entity mob;
        private LivingEntity target;
        private int circlingTime = 0;
        private final float huntingTime = 0.0f;
        private float circleDistance = 9.0f;
        private boolean clockwise = false;

        public RemnantAttackGoal(Ancient_Remnant_Entity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.target.m_6084_() && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public boolean m_8045_() {
            this.target = this.mob.m_5448_();
            return this.target != null;
        }

        public void m_8056_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0;
            this.circleDistance = 18 + this.mob.f_19796_.m_188503_(10);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0;
            this.circleDistance = 18 + this.mob.f_19796_.m_188503_(10);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.target = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(this.target)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() == null) {
                this.mob.m_21561_(false);
                this.mob.m_21573_().m_26573_();
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                if (this.mob.mode == AttackMode.CIRCLE) {
                    ++this.circlingTime;
                    Ancient_Remnant_Entity.this.circleEntity((Entity)target, this.circleDistance, 1.0f, this.clockwise, this.circlingTime, 0.0f, 1.0f);
                    if (0.0f >= (float)this.mob.hunting_cooldown) {
                        this.mob.mode = AttackMode.MELEE;
                    } else if ((double)this.mob.m_20270_((Entity)target) < 4.0) {
                        this.mob.mode = AttackMode.MELEE;
                    }
                } else if (this.mob.mode == AttackMode.MELEE) {
                    this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    if (this.mob.roar2_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 12.0f && target.m_20186_() >= this.mob.m_20186_() + 8.0 || this.mob.roar2_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 3.0f && (double)this.mob.m_20270_((Entity)target) > 12.0) {
                        this.mob.setAnimation(REMNANT_ROAR2);
                        this.mob.roar2_cooldown = 200;
                    } else if (this.mob.roar_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 3.0f) {
                        this.mob.setAnimation(REMNANT_ROAR);
                        this.mob.roar_cooldown = 500;
                    } else if (this.mob.earthquake_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 7.0f && (double)this.mob.m_20270_((Entity)target) < 12.0 && target.m_20096_()) {
                        this.mob.setAnimation(REMNANT_TAIL_THREE);
                        this.mob.earthquake_cooldown = 160;
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 9.0f && (double)this.mob.m_20270_((Entity)target) > 7.0 && (double)this.mob.m_20270_((Entity)target) < 20.0 && target.m_20186_() <= this.mob.m_20186_() + 1.0) {
                        if (this.mob.f_19796_.m_188499_()) {
                            this.mob.setAnimation(REMNANT_RIGHT_STOMP);
                        } else {
                            this.mob.setAnimation(REMNANT_LEFT_STOMP);
                        }
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 3.0f && (double)this.mob.m_20270_((Entity)target) > 12.0) {
                        this.mob.setAnimation(REMNANT_CHARGE_PREPARE);
                        this.mob.charge_cooldown = 250;
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.m_217043_().m_188501_() * 100.0f < 9.0f && (double)this.mob.m_20270_((Entity)target) > 7.0 && (double)this.mob.m_20270_((Entity)target) < 20.0 && target.m_20186_() <= this.mob.m_20186_() + 4.5) {
                        if (this.mob.f_19796_.m_188499_()) {
                            this.mob.setAnimation(REMNANT_RIGHT_STOMP);
                        } else {
                            this.mob.setAnimation(REMNANT_LEFT_STOMP);
                        }
                        this.mob.stomp_cooldown = 200;
                    } else if (this.mob.m_217043_().m_188501_() * 100.0f < 10.0f && (double)this.mob.m_20270_((Entity)target) < 7.0 && target.m_20186_() < this.mob.m_20186_() + 1.0) {
                        this.mob.setAnimation(REMNANT_TAIL_ATTACK1);
                    } else if (this.mob.m_217043_().m_188501_() * 100.0f < 10.0f && (double)this.mob.m_20270_((Entity)target) < 6.0) {
                        if (this.mob.f_19796_.m_188499_()) {
                            this.mob.setAnimation(REMNANT_BITE1);
                        } else {
                            this.mob.setAnimation(REMNANT_BITE2);
                        }
                    }
                }
            }
        }
    }

    class AwakenGoal
    extends Goal {
        public AwakenGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Ancient_Remnant_Entity.this.activeProgress > 0.0f;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            Ancient_Remnant_Entity.this.m_20334_(0.0, Ancient_Remnant_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }

    static class RemnantChargeAttackGoal
    extends SimpleAnimationGoal<Ancient_Remnant_Entity> {
        public RemnantChargeAttackGoal(Ancient_Remnant_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            ((Ancient_Remnant_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            ((Ancient_Remnant_Entity)this.entity).hunting_cooldown = 100;
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }

        public void m_8037_() {
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < 62 && target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Remnant_Entity)this.entity).m_146922_(((Ancient_Remnant_Entity)this.entity).f_19859_);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < 122 && ((Ancient_Remnant_Entity)this.entity).getAnimationTick() > 62 && ((Ancient_Remnant_Entity)this.entity).m_20096_()) {
                Vec3 vector3d = ((Ancient_Remnant_Entity)this.entity).m_20184_();
                float f = ((Ancient_Remnant_Entity)this.entity).m_146908_() * ((float)Math.PI / 180);
                Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), ((Ancient_Remnant_Entity)this.entity).m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(1.0).m_82549_(vector3d.m_82490_(0.5));
                ((Ancient_Remnant_Entity)this.entity).m_20334_(vector3d1.f_82479_, ((Ancient_Remnant_Entity)this.entity).m_20184_().f_82480_, vector3d1.f_82481_);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() == 62) {
                ((Ancient_Remnant_Entity)this.entity).setIsCharge(true);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() == 122) {
                ((Ancient_Remnant_Entity)this.entity).setIsCharge(false);
            }
        }
    }

    static class RemnantAnimationAttackGoal
    extends SimpleAnimationGoal<Ancient_Remnant_Entity> {
        private final int look;

        public RemnantAnimationAttackGoal(Ancient_Remnant_Entity entity, Animation animation, int look) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.look = look;
        }

        public void m_8056_() {
            ((Ancient_Remnant_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < this.look && target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Remnant_Entity)this.entity).m_146922_(((Ancient_Remnant_Entity)this.entity).f_19859_);
            }
        }
    }

    static class RemnantSteleAttackGoal
    extends SimpleAnimationGoal<Ancient_Remnant_Entity> {
        private final int look;

        public RemnantSteleAttackGoal(Ancient_Remnant_Entity entity, Animation animation, int look) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.look = look;
        }

        public void m_8056_() {
            ((Ancient_Remnant_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < this.look && target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Remnant_Entity)this.entity).m_146922_(((Ancient_Remnant_Entity)this.entity).f_19859_);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() == this.look && target != null) {
                float f4;
                int k;
                double d1 = target.m_20186_();
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - ((Ancient_Remnant_Entity)this.entity).m_20189_()), (double)(target.m_20185_() - ((Ancient_Remnant_Entity)this.entity).m_20185_()));
                for (k = 0; k < 10; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 10.0f + 0.41887903f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, d1, f4, 10);
                }
                for (k = 0; k < 12; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 12.0f + 0.31415927f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 7.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 7.5, d1, f4, 15);
                }
                for (k = 0; k < 14; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 17.0f + 0.20943952f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 10.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 10.5, d1, f4, 20);
                }
                for (k = 0; k < 16; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 16.0f + 0.15707964f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 13.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 13.5, d1, f4, 25);
                }
                for (k = 0; k < 18; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 18.0f + 0.10471976f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 16.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 16.5, d1, f4, 30);
                }
                for (k = 0; k < 20; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 20.0f + 0.07853982f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 19.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 19.5, d1, f4, 35);
                }
                for (k = 0; k < 22; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 22.0f + 0.05235988f;
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f4) * 22.5, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f4) * 22.5, d1, f4, 40);
                }
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = (int)(5.0f + 1.5f * (float)l);
                    this.spawnSpikeLine(((Ancient_Remnant_Entity)this.entity).m_20185_() + (double)Mth.m_14089_((float)f) * d2, ((Ancient_Remnant_Entity)this.entity).m_20189_() + (double)Mth.m_14031_((float)f) * d2, d1, f, j);
                }
            }
        }

        private void spawnSpikeLine(double posX, double posZ, double posY, float rotation, int delay) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = ((Ancient_Remnant_Entity)this.entity).f_19853_.m_8055_(blockpos1 = blockpos.m_7494_())).m_60783_((BlockGetter)((Ancient_Remnant_Entity)this.entity).f_19853_, blockpos1, Direction.DOWN)) continue;
                if (((Ancient_Remnant_Entity)this.entity).f_19853_.m_46859_(blockpos) || (voxelshape = (blockstate1 = ((Ancient_Remnant_Entity)this.entity).f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)((Ancient_Remnant_Entity)this.entity).f_19853_, blockpos)).m_83281_()) break;
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
                break;
            } while ((blockpos = blockpos.m_7494_()).m_123342_() < Math.min(((Ancient_Remnant_Entity)this.entity).f_19853_.m_151558_(), ((Ancient_Remnant_Entity)this.entity).m_146904_() + 20));
            ((Ancient_Remnant_Entity)this.entity).f_19853_.m_7967_((Entity)new Ancient_Desert_Stele_Entity(((Ancient_Remnant_Entity)this.entity).f_19853_, posX, (double)blockpos.m_123342_() + d0 - 3.0, posZ, rotation, delay, (LivingEntity)this.entity));
        }
    }
}

