/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.capabilities;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.init.ModCapabilities;
import com.github.L_Ender.cataclysm.message.MessageGoneWithSandstorm;
import com.github.L_Ender.cataclysm.util.SandstormUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.PacketDistributor;

public class Gone_With_SandstormCapability {
    public static ResourceLocation ID = new ResourceLocation("cataclysm", "sandstorm_cap");

    public static class Gone_With_SandstormCapabilityImp
    implements IGone_With_SandstormCapability {
        public int Timer;
        private boolean Sandstorm;
        private final LivingEntity player;

        public Gone_With_SandstormCapabilityImp(LivingEntity player) {
            this.player = player;
        }

        @Override
        public void tick(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            player.getCapability(ModCapabilities.GONE_WITH_SANDSTORM_CAPABILITY).ifPresent(handler -> {
                if (handler.isSandstorm()) {
                    if (this.getSandstormTimer() < CMConfig.Sandstorm_In_A_Bottle_Timer) {
                        this.setSandstormTimer(this.getSandstormTimer() + 1);
                        SandstormUtils.toggleFlight((LivingEntity)player, true);
                    } else {
                        this.setSandstorm(false);
                        SandstormUtils.toggleFlight((LivingEntity)player, false);
                    }
                } else if (this.getSandstormTimer() > 0) {
                    this.setSandstormTimer(this.getSandstormTimer() - 1);
                }
            });
        }

        public MessageGoneWithSandstorm makeSyncMessage() {
            return new MessageGoneWithSandstorm(this.player.m_19879_(), this, this.Timer);
        }

        public void sendSync() {
            LivingEntity livingEntity = this.player;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                Cataclysm.NETWORK_WRAPPER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)this.makeSyncMessage());
            }
        }

        @Override
        public void setSandstorm(boolean sandstorm) {
            this.Sandstorm = sandstorm;
            SandstormUtils.toggleFlight(this.player, sandstorm);
            this.sendSync();
        }

        @Override
        public boolean isSandstorm() {
            return this.Sandstorm;
        }

        @Override
        public void setSandstormTimer(int timer) {
            this.Timer = timer;
            this.sendSync();
        }

        @Override
        public int getSandstormTimer() {
            return this.Timer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isSandstorm", this.isSandstorm());
            tag.m_128405_("Sandstorm_timer", this.getSandstormTimer());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setSandstorm(nbt.m_128471_("isSandstorm"));
            this.setSandstormTimer(nbt.m_128451_("Sandstorm_timer"));
        }
    }

    public static interface IGone_With_SandstormCapability
    extends INBTSerializable<CompoundTag> {
        public void tick(TickEvent.PlayerTickEvent var1);

        public void setSandstorm(boolean var1);

        public boolean isSandstorm();

        public void setSandstormTimer(int var1);

        public int getSandstormTimer();
    }
}

