/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util.AssetsProtector;

import com.github.L_Ender.cataclysm.util.AssetsProtector.AESTexture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.RandomStringUtils;

@OnlyIn(value=Dist.CLIENT)
public class AESUtil {
    public static ResourceLocation getTexture(ResourceLocation texture) {
        AESUtil.registerTexture(texture);
        return texture;
    }

    public static void registerTexture(ResourceLocation p_172522_) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        AbstractTexture abstracttexture = textureManager.m_174786_(p_172522_, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (abstracttexture == MissingTextureAtlasSprite.m_118080_()) {
            AESTexture texture = new AESTexture(null, p_172522_);
            textureManager.m_118495_(p_172522_, (AbstractTexture)texture);
        }
    }

    private static String generateRandomString() {
        return RandomStringUtils.random((int)16, (boolean)true, (boolean)true);
    }

    private static SecretKey getKey(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        return secret;
    }

    private static IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        return new IvParameterSpec(iv);
    }

    private static SecretKey decryptKey(byte[] array, String algorithm, IvParameterSpec ivParameterSpec) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException, IOException {
        String string = new String(Arrays.copyOfRange(array, array.length - 16, array.length));
        SecretKey key = AESUtil.getKey(string, string);
        String encrypted = new String(Arrays.copyOfRange(array, array.length - 60, array.length - 16));
        String decrypted = AESUtil.decryptString(algorithm, encrypted, key, ivParameterSpec);
        return AESUtil.getKey(decrypted, string);
    }

    public static ByteArrayInputStream decrypt(byte[] array) throws NoSuchAlgorithmException, IOException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeySpecException {
        String algorithm = "AES/CBC/PKCS5Padding";
        IvParameterSpec ivParameterSpec = AESUtil.generateIv();
        SecretKey key = AESUtil.decryptKey(array, algorithm, ivParameterSpec);
        return AESUtil.decryptFile(algorithm, key, ivParameterSpec, array);
    }

    public static void encryptFiles(final String fileExtension) throws NoSuchAlgorithmException, IOException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeySpecException {
        String algorithm = "AES/CBC/PKCS5Padding";
        IvParameterSpec ivParameterSpec = AESUtil.generateIv();
        File directory = AESUtil.makeDirectory("aes");
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(fileExtension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File inputFile = new File(directory, files[i].getName().toLowerCase());
            File encryptedFile = new File(directory, files[i].getName().toLowerCase() + "encrypted");
            String randomString = AESUtil.generateRandomString();
            SecretKey key = AESUtil.getKey(randomString, randomString);
            String encrypted = AESUtil.encryptString(algorithm, AESUtil.generateRandomString(), key, ivParameterSpec);
            String decrypted = AESUtil.decryptString(algorithm, encrypted, key, ivParameterSpec);
            AESUtil.encryptFile(algorithm, AESUtil.getKey(decrypted, randomString), ivParameterSpec, inputFile, encryptedFile, encrypted, randomString);
        }
    }

    private static File makeDirectory(String folderName) {
        Minecraft mc = Minecraft.m_91087_();
        File cacheDirectory = new File(mc.f_91069_.getPath() + "/" + folderName);
        if (!cacheDirectory.exists()) {
            cacheDirectory.mkdir();
        }
        return cacheDirectory;
    }

    private static String encryptString(String algorithm, String input, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)key, iv);
        byte[] cipherText = cipher.doFinal(input.getBytes());
        return Base64.getEncoder().encodeToString(cipherText);
    }

    private static String decryptString(String algorithm, String cipherText, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)key, iv);
        byte[] plainText = cipher.doFinal(Base64.getDecoder().decode(cipherText));
        return new String(plainText);
    }

    private static ByteArrayInputStream decryptFile(String algorithm, SecretKey key, IvParameterSpec iv, byte[] array) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        int bytesRead;
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)key, iv);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Arrays.copyOfRange(array, 0, array.length - 60));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[64];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byte[] output = cipher.update(buffer, 0, bytesRead);
            if (output == null) continue;
            outputStream.write(output);
        }
        byte[] outputBytes = cipher.doFinal();
        if (outputBytes != null) {
            outputStream.write(outputBytes);
        }
        inputStream.close();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static void encryptFile(String algorithm, SecretKey key, IvParameterSpec iv, File inputFile, File outputFile, String encrypted, String string) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        int bytesRead;
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)key, iv);
        FileInputStream inputStream = new FileInputStream(inputFile);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        byte[] buffer = new byte[64];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byte[] output = cipher.update(buffer, 0, bytesRead);
            if (output == null) continue;
            outputStream.write(output);
        }
        byte[] outputBytes = cipher.doFinal();
        if (outputBytes != null) {
            outputStream.write(outputBytes);
            outputStream.write(encrypted.getBytes());
            outputStream.write(string.getBytes());
        }
        inputStream.close();
        outputStream.close();
    }
}

