/*
 * Decompiled with CFR 0.152.
 */
package gg.lunapixel.luna.e4mc_integration;

import gg.lunapixel.luna.e4mc_integration.LunaClient;
import gg.lunapixel.luna.e4mc_integration.QuiclimeHandler;
import gg.lunapixel.luna.e4mc_integration.QuiclimeHandlerState;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\rH\u0002J+\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r2\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0012\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0019\u001a\u00020\nH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lgg/lunapixel/luna/e4mc_integration/ChatHelper;", "", "()V", "isClient", "", "()Z", "isServer", "alertUser", "", "message", "Lnet/minecraft/network/chat/Component;", "createDomainAssignedMessage", "domain", "", "createLiteralMessage", "createTranslatableMessage", "key", "objects", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/network/chat/Component;", "sendCleanLiteral", "msg", "sendDomainAssignment", "sendError", "sendLiteral", "sendStopMessage", "Luna"})
public final class ChatHelper {
    @NotNull
    public static final ChatHelper INSTANCE = new ChatHelper();
    private static final boolean isClient = FMLLoader.getDist().isClient();
    private static final boolean isServer = FMLLoader.getDist().isDedicatedServer();

    private ChatHelper() {
    }

    public final boolean isClient() {
        return isClient;
    }

    public final boolean isServer() {
        return isServer;
    }

    public final void sendLiteral(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.alertUser(this.createLiteralMessage("[Luna] " + msg));
    }

    public final void sendCleanLiteral(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.alertUser(this.createLiteralMessage(String.valueOf(msg)));
    }

    public final void sendError() {
        QuiclimeHandler quiclimeHandler = LunaClient.HANDLER;
        if ((quiclimeHandler != null ? quiclimeHandler.getState() : null) == QuiclimeHandlerState.STARTED) {
            QuiclimeHandler quiclimeHandler2 = LunaClient.HANDLER;
            if (quiclimeHandler2 != null) {
                quiclimeHandler2.setState(QuiclimeHandlerState.UNHEALTHY);
            }
        }
        this.alertUser(this.createTranslatableMessage("text.luna.error", new Object[0]));
    }

    public final void sendDomainAssignment(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        if (isServer) {
            LunaClient.LOGGER.warn("Luna is running on a Dedicated Server! This shouldn't normally happen.");
        }
        LunaClient.LOGGER.info("Domain assigned: " + domain);
        this.alertUser(this.createDomainAssignedMessage(domain));
        this.alertUser(this.sendStopMessage());
    }

    private final void alertUser(Component message) {
        if (isClient) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(message);
        }
    }

    private final Component createLiteralMessage(String message) {
        MutableComponent mutableComponent = Component.m_237113_((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(message)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final Component createTranslatableMessage(@NotNull String key, Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        MutableComponent mutableComponent = Component.m_237110_((String)key, (Object[])Arrays.copyOf(objects, objects.length));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(key, *objects)");
        return (Component)mutableComponent;
    }

    private final Component sendStopMessage() {
        MutableComponent mutableComponent = Component.m_237115_((String)"text.luna.clickToStop").m_130938_(ChatHelper::sendStopMessage$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\"text.luna.\u2026oStop.hover\")))\n        }");
        return (Component)mutableComponent;
    }

    private final Component createDomainAssignedMessage(String domain) {
        Object[] objectArray = new Object[]{Component.m_237113_((String)domain).m_130938_(arg_0 -> ChatHelper.createDomainAssignedMessage$lambda-1(domain, arg_0))};
        MutableComponent mutableComponent = Component.m_237110_((String)"text.luna.domainAssigned", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\n          \u2026)\n            }\n        )");
        return (Component)mutableComponent;
    }

    private static final Style sendStopMessage$lambda-0(Style it) {
        return it.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/luna stop")).m_131140_(ChatFormatting.GRAY).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"text.luna.clickToStop.hover")));
    }

    private static final Style createDomainAssignedMessage$lambda-1(String $domain, Style it) {
        Intrinsics.checkNotNullParameter((Object)$domain, (String)"$domain");
        return it.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, $domain)).m_131140_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click")));
    }
}

