/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public final class ScreenElementPositioner {
    private ScreenElementPositioner() {
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends Widget> widgets, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, false, translationKeys);
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends Widget> widgets, boolean tryPositionRightFirst, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, tryPositionRightFirst, 4, translationKeys);
    }

    public static boolean tryPositionElement(AbstractWidget element, List<? extends Widget> widgets, boolean tryPositionRightFirst, int horizontalOffset, String ... translationKeys) {
        int originalX = element.f_93620_;
        int originalY = element.f_93621_;
        for (String translationKey : translationKeys) {
            AbstractWidget otherElement = ScreenElementPositioner.findElement(widgets, translationKey);
            if (otherElement == null) continue;
            ScreenElementPositioner.moveElementToOther(element, otherElement, tryPositionRightFirst, horizontalOffset);
            if (ScreenElementPositioner.noOverlapWithExisting(widgets, element)) {
                return true;
            }
            ScreenElementPositioner.moveElementToOther(element, otherElement, !tryPositionRightFirst, horizontalOffset);
            if (!ScreenElementPositioner.noOverlapWithExisting(widgets, element)) continue;
            return true;
        }
        element.f_93620_ = originalX;
        element.f_93621_ = originalY;
        return false;
    }

    private static void moveElementToOther(AbstractWidget element, AbstractWidget otherElement, boolean tryPositionRightFirst, int horizontalOffset) {
        if (tryPositionRightFirst) {
            ScreenElementPositioner.moveToRight(element, otherElement, horizontalOffset);
        } else {
            ScreenElementPositioner.moveToLeft(element, otherElement, horizontalOffset);
        }
    }

    private static void moveToLeft(AbstractWidget element, AbstractWidget otherElement, int horizontalOffset) {
        element.f_93620_ = otherElement.f_93620_ - element.m_5711_() - horizontalOffset;
        element.f_93621_ = otherElement.f_93621_;
    }

    private static void moveToRight(AbstractWidget element, AbstractWidget otherElement, int horizontalOffset) {
        element.f_93620_ = otherElement.f_93620_ + otherElement.m_5711_() + horizontalOffset;
        element.f_93621_ = otherElement.f_93621_;
    }

    private static boolean noOverlapWithExisting(List<? extends Widget> widgets, AbstractWidget element) {
        for (Widget widget : widgets) {
            AbstractWidget otherElement;
            if (!(widget instanceof AbstractWidget) || !ScreenElementPositioner.intersection(element, otherElement = (AbstractWidget)widget)) continue;
            return false;
        }
        return true;
    }

    private static boolean intersection(AbstractWidget element, AbstractWidget otherElement) {
        int i = Math.max(element.f_93620_, otherElement.f_93620_);
        int j = Math.max(element.f_93621_, otherElement.f_93621_);
        int k = Math.min(element.f_93620_ + element.m_5711_(), otherElement.f_93620_ + otherElement.m_5711_());
        int l = Math.min(element.f_93621_ + element.m_93694_(), otherElement.f_93621_ + otherElement.m_93694_());
        return i < k && j < l;
    }

    @Nullable
    private static AbstractWidget findElement(List<? extends Widget> widgets, String translationKey) {
        for (Widget widget : widgets) {
            AbstractWidget widget2;
            if (!(widget instanceof AbstractWidget) || !ScreenElementPositioner.matchesTranslationKey(widget2 = (AbstractWidget)widget, translationKey)) continue;
            return widget2;
        }
        return null;
    }

    private static boolean matchesTranslationKey(AbstractWidget widget, String translationKey) {
        TranslatableContents contents;
        ComponentContents message = widget.m_6035_().m_214077_();
        return message instanceof TranslatableContents && (contents = (TranslatableContents)message).m_237508_().equals(translationKey);
    }
}

