/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget.text;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.Tooltip;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.widget.text.AbstractSpruceTextInputWidget;

public class SpruceTextFieldWidget
extends AbstractSpruceTextInputWidget
implements Tooltipable {
    public static final Predicate<String> INTEGER_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FLOAT_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-") || input.equals(".")) {
            return true;
        }
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> DOUBLE_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-") || input.equals(".")) {
            return true;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private final Cursor cursor = new Cursor(true);
    private final Selection selection = new Selection();
    private String text = "";
    private Component tooltip;
    private Consumer<String> changedListener;
    private Predicate<String> textPredicate;
    private BiFunction<String, Integer, FormattedCharSequence> renderTextProvider;
    private int firstCharacterIndex = 0;
    private long editingTime;
    private int tooltipTicks;
    private long lastTick;

    public SpruceTextFieldWidget(Position position, int width, int height, Component title) {
        super(position, width, height, title);
        this.cursor.toStart();
        this.sanitize();
        this.changedListener = input -> {};
        this.textPredicate = Objects::nonNull;
        this.renderTextProvider = (input, firstCharacterIndex) -> FormattedCharSequence.m_13714_((String)input, (Style)Style.f_131099_);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        if (this.textPredicate.test(text)) {
            this.text = text;
            this.setCursorToEnd();
            this.selection.cancel();
            this.sanitize();
            this.onChanged();
        }
    }

    @Override
    public Optional<Component> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable Component tooltip) {
        this.tooltip = tooltip;
    }

    public Consumer<String> getChangedListener() {
        return this.changedListener;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    public Predicate<String> getTextPredicate() {
        return this.textPredicate;
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public BiFunction<String, Integer, FormattedCharSequence> getRenderTextProvider() {
        return this.renderTextProvider;
    }

    public void setRenderTextProvider(BiFunction<String, Integer, FormattedCharSequence> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
    }

    @Override
    public void setCursorToStart() {
        this.cursor.toStart();
    }

    @Override
    public void setCursorToEnd() {
        this.cursor.toEnd();
    }

    @Override
    protected void sanitize() {
        this.cursor.sanitize();
        int textLength = this.text.length();
        if (this.firstCharacterIndex > textLength) {
            this.firstCharacterIndex = textLength;
        }
        int width = this.getInnerWidth();
        String string = this.client.f_91062_.m_92834_(this.text.substring(this.firstCharacterIndex), width);
        int l = string.length() + this.firstCharacterIndex;
        if (this.cursor.column == this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.client.f_91062_.m_92837_(this.text, width, true).length();
        }
        if (this.cursor.column > l) {
            this.firstCharacterIndex += this.cursor.column - l;
        } else if (this.cursor.column <= this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.firstCharacterIndex - this.cursor.column;
        }
        this.firstCharacterIndex = Mth.m_14045_((int)this.firstCharacterIndex, (int)0, (int)textLength);
    }

    private void onChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
        this.editingTime = Util.m_137550_() + 5000L;
    }

    private boolean onSelectionUpdate(Runnable action) {
        this.selection.tryStartSelection();
        action.run();
        this.selection.moveToCursor();
        this.sanitize();
        return true;
    }

    private void insertCharacter(char character) {
        if (this.getText().isEmpty()) {
            this.setText(String.valueOf(character));
            return;
        }
        this.selection.erase();
        if (character == '\n') {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        String newText = cursorPosition >= text.length() ? text + character : text.substring(0, cursorPosition) + character + text.substring(cursorPosition);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.moveRight();
        }
        this.sanitize();
    }

    private void eraseCharacter() {
        int cursorPosition;
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        if (this.cursor.column == 0) {
            return;
        }
        String text = this.getText();
        String newText = text.substring(0, (cursorPosition = this.cursor.getPosition()) - 1) + text.substring(cursorPosition);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.moveLeft();
        }
        this.sanitize();
    }

    private void removeCharacterForward() {
        int cursorPosition;
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        if (this.getText().isEmpty()) {
            this.sanitize();
            return;
        }
        if (this.cursor.column >= this.getText().length()) {
            return;
        }
        String text = this.getText();
        String newText = text.substring(0, cursorPosition = this.cursor.getPosition()) + text.substring(cursorPosition + 1);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
        }
        this.sanitize();
    }

    public void write(String text) {
        if (text.isEmpty()) {
            return;
        }
        if (this.getText().isEmpty()) {
            this.setText(text);
            this.setCursorToEnd();
            return;
        }
        this.selection.erase();
        String oldText = this.getText();
        int position = this.cursor.getPosition();
        String newText = position >= oldText.length() ? oldText + text : oldText.substring(0, position) + text + oldText.substring(position);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.move(text.length());
        }
        this.sanitize();
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (!tab && direction.isHorizontal()) {
            boolean result;
            this.setFocused(true);
            switch (direction) {
                case RIGHT: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveRight);
                    break;
                }
                case LEFT: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveLeft);
                    break;
                }
                default: {
                    boolean bl = result = false;
                }
            }
            if (result) {
                return true;
            }
        }
        return super.onNavigation(direction, tab);
    }

    @Override
    protected boolean onCharTyped(char chr, int keyCode) {
        if (!this.isEditorActive() || !SharedConstants.m_136188_((char)chr)) {
            return false;
        }
        if (this.isActive()) {
            this.insertCharacter(chr);
            this.selection.cancel();
        }
        return true;
    }

    @Override
    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (Screen.m_96634_((int)keyCode)) {
            this.selection.selectAll();
            this.sanitize();
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.write(Minecraft.m_91087_().f_91068_.m_90876_());
            return true;
        }
        if (Screen.m_96632_((int)keyCode) || Screen.m_96628_((int)keyCode)) {
            String selected = this.selection.getSelectedText();
            if (!selected.isEmpty()) {
                Minecraft.m_91087_().f_91068_.m_90911_(selected);
            }
            if (Screen.m_96628_((int)keyCode)) {
                this.selection.erase();
                this.sanitize();
            }
            return true;
        }
        switch (keyCode) {
            case 262: {
                return this.onSelectionUpdate(this.cursor::moveRight);
            }
            case 263: {
                return this.onSelectionUpdate(this.cursor::moveLeft);
            }
            case 269: {
                return this.onSelectionUpdate(this.cursor::toEnd);
            }
            case 268: {
                return this.onSelectionUpdate(this.cursor::toStart);
            }
            case 259: {
                this.eraseCharacter();
                return true;
            }
            case 261: {
                this.removeCharacterForward();
                return true;
            }
            case 68: {
                if (Screen.m_96637_() && !this.text.isEmpty()) {
                    this.setText("");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x = Mth.m_14107_((double)mouseX) - this.getX() - 4;
            this.setFocused(true);
            this.onSelectionUpdate(() -> {
                String displayedText = this.client.f_91062_.m_92834_(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
                this.cursor.lastColumn = this.cursor.column = this.firstCharacterIndex + this.client.f_91062_.m_92834_(displayedText, x).length();
            });
            return true;
        }
        return false;
    }

    @Override
    protected void renderWidget(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.renderWidget(matrices, mouseX, mouseY, delta);
        this.drawText(matrices);
        this.drawCursor(matrices);
        if (!this.dragging && this.editingTime == 0L) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        } else if (this.editingTime < Util.m_137550_()) {
            this.editingTime = 0L;
        }
    }

    protected void drawText(PoseStack matrices) {
        int textColor = this.getTextColor();
        int x = this.getX() + 4;
        int y = this.getY() + this.getHeight() / 2 - 4;
        String displayedText = this.client.f_91062_.m_92834_(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        this.client.f_91062_.m_92744_(matrices, this.renderTextProvider.apply(displayedText, this.firstCharacterIndex), (float)x, (float)y, textColor);
        this.drawSelection(displayedText, y);
    }

    protected void drawSelection(String line, int lineY) {
        if (!this.isFocused() || !this.selection.active) {
            return;
        }
        int startIndex = Math.max(0, this.selection.getStart().column - this.firstCharacterIndex);
        int endIndex = Math.min(line.length(), this.selection.getEnd().column - this.firstCharacterIndex);
        if (startIndex >= line.length()) {
            return;
        }
        int x = this.getX() + 4 + this.client.f_91062_.m_92895_(line.substring(0, startIndex));
        String selected = line.substring(startIndex, endIndex);
        int x2 = x + this.client.f_91062_.m_92895_(selected);
        Objects.requireNonNull(this.client.f_91062_);
        int y2 = lineY + 9;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_5483_((double)x, (double)y2, 0.0).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, 0.0).m_5752_();
        buffer.m_5483_((double)x2, (double)lineY, 0.0).m_5752_();
        buffer.m_5483_((double)x, (double)lineY, 0.0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    protected void drawCursor(PoseStack matrices) {
        if (!this.isFocused()) {
            return;
        }
        int cursorY = this.getY() + this.getHeight() / 2 - 4;
        if (this.text.isEmpty()) {
            SpruceTextFieldWidget.m_93243_((PoseStack)matrices, (Font)this.client.f_91062_, (Component)Component.m_237113_((String)"_"), (int)(this.getX() + 4), (int)cursorY, (int)-2039584);
            return;
        }
        this.cursor.sanitize();
        String cursorLine = this.text.substring(this.firstCharacterIndex);
        int cursorX = this.getX() + 4 + this.client.f_91062_.m_92895_(cursorLine.substring(0, this.cursor.column - this.firstCharacterIndex));
        if (this.cursor.column - this.firstCharacterIndex < cursorLine.length()) {
            SpruceTextFieldWidget.m_93172_((PoseStack)matrices, (int)(cursorX - 1), (int)(cursorY - 1), (int)cursorX, (int)(cursorY + 9), (int)-2039584);
        } else {
            this.client.f_91062_.m_92750_(matrices, "_", (float)cursorX, (float)cursorY, -2039584);
        }
    }

    @Override
    public void m_142291_(NarrationElementOutput builder) {
        super.m_142291_(builder);
        this.getTooltip().ifPresent(text -> builder.m_169146_(NarratedElementType.HINT, text));
    }

    public class Cursor {
        boolean main;
        int column = 0;
        private int lastColumn = 0;

        public Cursor(boolean main) {
            this.main = main;
        }

        public void toStart() {
            this.column = 0;
            this.lastColumn = 0;
        }

        public void moveRight() {
            this.move(1);
        }

        public void moveLeft() {
            this.move(-1);
        }

        public void move(int amount) {
            this.column += amount;
            if (this.column < 0) {
                this.toStart();
            } else if (this.column > SpruceTextFieldWidget.this.text.length()) {
                this.column = SpruceTextFieldWidget.this.text.length();
            }
            this.lastColumn = this.column;
            if (amount < 0 && this.column <= SpruceTextFieldWidget.this.firstCharacterIndex) {
                SpruceTextFieldWidget.this.firstCharacterIndex = this.column - 1;
                SpruceTextFieldWidget.this.firstCharacterIndex = Mth.m_14045_((int)SpruceTextFieldWidget.this.firstCharacterIndex, (int)0, (int)SpruceTextFieldWidget.this.text.length());
            }
        }

        public void toEnd() {
            this.lastColumn = this.column = SpruceTextFieldWidget.this.text.length();
        }

        public void copy(Cursor cursor) {
            this.lastColumn = this.column = cursor.column;
        }

        public void sanitize() {
            if (this.column < 0) {
                this.toStart();
            } else if (this.column > SpruceTextFieldWidget.this.text.length()) {
                this.column = SpruceTextFieldWidget.this.text.length();
            }
        }

        public boolean isSame(Cursor other) {
            return this.column == other.column;
        }

        public int getPosition() {
            return this.column;
        }

        public String toString() {
            return "SpruceTextAreaWidget$Cursor{main=" + this.main + ", column=" + this.column + ", lastColumn=" + this.lastColumn + "}";
        }
    }

    public class Selection {
        private final Cursor anchor;
        private final Cursor follower;
        private boolean active;

        public Selection() {
            this.anchor = new Cursor(false);
            this.follower = new Cursor(false);
            this.active = false;
        }

        public void selectAll() {
            this.anchor.toStart();
            SpruceTextFieldWidget.this.cursor.toEnd();
            this.follower.copy(SpruceTextFieldWidget.this.cursor);
            this.active = true;
        }

        public void cancel() {
            this.anchor.toStart();
            this.follower.toStart();
            this.active = false;
        }

        public void tryStartSelection() {
            if (!this.active && Screen.m_96638_()) {
                this.startSelection();
            }
        }

        public void startSelection() {
            this.anchor.copy(SpruceTextFieldWidget.this.cursor);
            this.follower.copy(SpruceTextFieldWidget.this.cursor);
            this.active = true;
        }

        public void moveToCursor() {
            if (!this.active) {
                return;
            }
            if (Screen.m_96638_()) {
                this.follower.copy(SpruceTextFieldWidget.this.cursor);
            } else {
                this.cancel();
            }
        }

        public boolean erase() {
            Cursor end;
            if (!this.active) {
                return false;
            }
            Cursor start = this.getStart();
            if (start.isSame(end = this.getEnd())) {
                this.cancel();
                return false;
            }
            if (start.column == 0 && end.column >= SpruceTextFieldWidget.this.text.length()) {
                SpruceTextFieldWidget.this.text = "";
                this.cancel();
                return true;
            }
            String text = SpruceTextFieldWidget.this.getText();
            String newText = text.substring(0, start.getPosition()) + text.substring(end.getPosition());
            if (SpruceTextFieldWidget.this.textPredicate.test(newText)) {
                SpruceTextFieldWidget.this.text = newText;
                SpruceTextFieldWidget.this.onChanged();
            }
            SpruceTextFieldWidget.this.cursor.copy(start);
            this.cancel();
            return true;
        }

        public String getSelectedText() {
            Cursor end;
            if (!this.active) {
                return "";
            }
            Cursor start = this.getStart();
            if (start.isSame(end = this.getEnd())) {
                return "";
            }
            return SpruceTextFieldWidget.this.getText().substring(start.getPosition(), end.getPosition());
        }

        public Cursor getStart() {
            return this.isInverted() ? this.follower : this.anchor;
        }

        public Cursor getEnd() {
            return this.isInverted() ? this.anchor : this.follower;
        }

        private boolean isInverted() {
            return this.anchor.column > this.follower.column;
        }
    }
}

