/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi;

import com.google.common.collect.Lists;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiPackSource;
import com.yungnickyoung.minecraft.paxi.mixin.accessor.FolderRepositorySourceAccessor;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public class PaxiRepositorySource
extends FolderRepositorySource {
    private static final FileFilter PACK_FILTER = file -> {
        boolean isValidPackZip = file.isFile() && file.getName().endsWith(".zip");
        boolean isValidPackFolder = file.isDirectory() && new File(file, "pack.mcmeta").isFile();
        return isValidPackZip || isValidPackFolder;
    };
    private File ordering;
    public List<String> orderedPaxiPacks = new ArrayList<String>();
    public List<String> unorderedPaxiPacks = new ArrayList<String>();

    public PaxiRepositorySource(File packsFolder, File ordering) {
        super(packsFolder, PaxiPackSource.PACK_SOURCE_PAXI);
        this.ordering = ordering;
    }

    public PaxiRepositorySource(File packsFolder) {
        super(packsFolder, PaxiPackSource.PACK_SOURCE_PAXI);
    }

    public void m_7686_(Consumer<Pack> packAdder, Pack.PackConstructor packConstructor) {
        File[] packs;
        File folder = ((FolderRepositorySourceAccessor)((Object)this)).getFolder();
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        if (this.ordering != null && !this.ordering.isFile()) {
            PackOrdering emptyPackOrdering = new PackOrdering(new String[0]);
            try {
                JSON.createJsonFileFromObject((Path)this.ordering.toPath(), (Object)emptyPackOrdering);
            }
            catch (IOException e) {
                PaxiCommon.LOGGER.error("Unable to create default pack ordering file! This shouldn't happen.");
                PaxiCommon.LOGGER.error(e.toString());
            }
        }
        if ((packs = this.loadPacksFromFiles()) != null) {
            for (File file : packs) {
                String packName = file.getName();
                Pack resourcePackProfile = Pack.m_10430_((String)packName, (boolean)true, this.createPackResourcesSupplier(file), (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.TOP, (PackSource)PaxiPackSource.PACK_SOURCE_PAXI);
                if (resourcePackProfile == null) continue;
                packAdder.accept(resourcePackProfile);
            }
        }
    }

    private File[] loadPacksFromFiles() {
        if (this.ordering != null) {
            PackOrdering packOrdering = null;
            try {
                packOrdering = (PackOrdering)JSON.loadObjectFromJsonFile((Path)this.ordering.toPath(), PackOrdering.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                PaxiCommon.LOGGER.error("Error loading Paxi ordering JSON file {}: {}", (Object)this.ordering.getName(), (Object)e.toString());
            }
            if (packOrdering == null) {
                PaxiCommon.LOGGER.error("Unable to load ordering JSON file {}! Is it proper JSON formatting? Ignoring load order...", (Object)this.ordering.getName());
                return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            }
            if (packOrdering.getOrderedPackNames() == null) {
                PaxiCommon.LOGGER.error("Unable to find entry with name 'loadOrder' in load ordering JSON file {}! Ignoring load order...", (Object)this.ordering.getName());
                return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            }
            List<File> orderedPacks = this.filesFromNames(packOrdering.getOrderedPackNames(), PACK_FILTER);
            File[] allPacks = ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
            ArrayList unorderedPacks = allPacks == null ? Lists.newArrayList() : Arrays.stream(allPacks).filter(file -> !orderedPacks.contains(file)).collect(Collectors.toList());
            orderedPacks.forEach(file -> this.orderedPaxiPacks.add(file.getName()));
            unorderedPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
            return (File[])Stream.of(unorderedPacks, orderedPacks).flatMap(Collection::stream).toArray(File[]::new);
        }
        return ((FolderRepositorySourceAccessor)((Object)this)).getFolder().listFiles(PACK_FILTER);
    }

    private List<File> filesFromNames(String[] packFileNames, FileFilter filter) {
        ArrayList<File> packFiles = new ArrayList<File>();
        for (String fileName : packFileNames) {
            File packFile = new File(((FolderRepositorySourceAccessor)((Object)this)).getFolder(), fileName);
            if (!packFile.exists()) {
                PaxiCommon.LOGGER.error("Unable to find pack with name {} specified in load ordering JSON file {}! Skipping...", (Object)fileName, (Object)this.ordering.getName());
                continue;
            }
            if (filter != null && !filter.accept(packFile)) continue;
            packFiles.add(packFile);
        }
        return packFiles;
    }

    private Supplier<PackResources> createPackResourcesSupplier(File file) {
        return file.isDirectory() ? () -> new FolderPackResources(file) : () -> new FilePackResources(file);
    }

    public boolean hasPacks() {
        return this.unorderedPaxiPacks.size() > 0 || this.orderedPaxiPacks.size() > 0;
    }

    private static class PackOrdering {
        @SerializedName(value="loadOrder")
        private String[] orderedPackNames;

        public PackOrdering(String[] orderedPackNames) {
            this.orderedPackNames = orderedPackNames;
        }

        public String[] getOrderedPackNames() {
            return this.orderedPackNames;
        }
    }
}

