/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.api.IQuarkButtonAllowed;
import vazkii.quark.base.client.handler.InventoryButtonHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.InventoryTransferHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.RGBAColorConfig;
import vazkii.quark.content.management.client.screen.widgets.MiniInventoryButton;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ChestSearchingModule
extends QuarkModule {
    @Config
    public RGBAColorConfig overlayColor = RGBAColorConfig.forColor(0.0, 0.0, 0.0, 0.67);
    @OnlyIn(value=Dist.CLIENT)
    private static EditBox searchBar;
    private static String text;
    public static boolean searchEnabled;
    private static long lastClick;
    private static int matched;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 1, (parent, x, y) -> new MiniInventoryButton(parent, 3, x, y, "quark.gui.button.filter", b -> {
            searchEnabled = !searchEnabled;
            this.updateSearchStatus();
            searchBar.m_94178_(true);
        }).setTextureShift(() -> searchEnabled), null);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void initGui(ScreenEvent.Init.Post event) {
        Screen gui = event.getScreen();
        boolean apiAllowed = gui instanceof IQuarkButtonAllowed;
        if (!(gui instanceof InventoryScreen) && gui instanceof AbstractContainerScreen) {
            AbstractContainerScreen chest = (AbstractContainerScreen)gui;
            if (apiAllowed || GeneralConfig.isScreenAllowed(gui)) {
                Minecraft mc = gui.getMinecraft();
                if (apiAllowed || InventoryTransferHandler.accepts(chest.m_6262_(), (Player)mc.f_91074_)) {
                    searchBar = new EditBox(mc.f_91062_, 18, 6, 117, 10, (Component)Component.m_237113_((String)text));
                    searchBar.m_94144_(text);
                    searchBar.m_94199_(50);
                    searchBar.m_94182_(false);
                    this.updateSearchStatus();
                    return;
                }
            }
        }
        searchBar = null;
    }

    private void updateSearchStatus() {
        if (searchBar != null) {
            searchBar.m_94186_(searchEnabled);
            searchBar.m_94194_(searchEnabled);
            if (!searchEnabled) {
                searchBar.m_94178_(false);
            }
        }
    }

    @SubscribeEvent
    public void charTyped(ScreenEvent.CharacterTyped.Pre event) {
        if (searchBar != null && searchBar.m_93696_() && searchEnabled) {
            searchBar.m_5534_(event.getCodePoint(), event.getModifiers());
            text = searchBar.m_94155_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeypress(ScreenEvent.KeyPressed.Pre event) {
        if (searchBar != null && searchBar.m_93696_() && searchEnabled) {
            searchBar.m_7933_(event.getKeyCode(), event.getScanCode(), event.getModifiers());
            text = searchBar.m_94155_();
            event.setCanceled(event.getKeyCode() != 256);
        }
    }

    @SubscribeEvent
    public void onClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen;
        if (searchBar != null && searchEnabled && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            searchBar.m_6375_(event.getMouseX() - (double)containerScreen.getGuiLeft(), event.getMouseY() - (double)containerScreen.getGuiTop(), event.getButton());
            long time = System.currentTimeMillis();
            long delta = time - lastClick;
            if (delta < 200L && searchBar.m_93696_()) {
                searchBar.m_94144_("");
                text = "";
            }
            lastClick = time;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(ContainerScreenEvent.Render.Foreground event) {
        if (searchBar != null && searchEnabled) {
            PoseStack matrix = event.getPoseStack();
            AbstractContainerScreen gui = event.getContainerScreen();
            matrix.m_85836_();
            this.drawBackground(matrix, (Screen)gui, ChestSearchingModule.searchBar.f_93620_ - 11, ChestSearchingModule.searchBar.f_93621_ - 3);
            if (!text.isEmpty()) {
                AbstractContainerMenu container = gui.m_6262_();
                matched = 0;
                for (Slot s : container.f_38839_) {
                    if (!s.m_6659_()) continue;
                    ItemStack stack = s.m_7993_();
                    if (!ChestSearchingModule.namesMatch(stack, text)) {
                        int x = s.f_40220_;
                        int y = s.f_40221_;
                        Screen.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)this.overlayColor.getColor());
                        continue;
                    }
                    ++matched;
                }
            }
            if (matched == 0 && !text.isEmpty()) {
                searchBar.m_94202_(0xFF5555);
            } else {
                searchBar.m_94202_(0xFFFFFF);
            }
            searchBar.m_6305_(matrix, 0, 0, 0.0f);
            matrix.m_85849_();
        }
    }

    private void drawBackground(PoseStack matrix, Screen gui, int x, int y) {
        if (gui == null) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
        Screen.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)126, (int)13, (int)256, (int)256);
    }

    public static boolean namesMatch(ItemStack stack) {
        return !searchEnabled || ChestSearchingModule.namesMatch(stack, text);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean namesMatch(ItemStack stack, String search) {
        CompoundTag cmp;
        if ((search = ChatFormatting.m_126649_((String)search.trim().toLowerCase(Locale.ROOT))) == null || search.isEmpty()) {
            return true;
        }
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        ResourceLocation res = Registry.f_122827_.m_7981_((Object)item);
        if (SimilarBlockTypeHandler.isShulkerBox(res) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)true)) != null) {
            LazyOptional handler;
            BlockEntity te;
            if (!cmp.m_128441_("id")) {
                cmp = cmp.m_6426_();
                cmp.m_128359_("id", "minecraft:shulker_box");
            }
            if ((te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)item).m_40614_().m_49966_(), (CompoundTag)cmp)) != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
                void var8_9;
                IItemHandler items = (IItemHandler)handler.orElseGet(EmptyHandler::new);
                boolean bl = false;
                while (var8_9 < items.getSlots()) {
                    if (ChestSearchingModule.namesMatch(items.getStackInSlot((int)var8_9), search)) {
                        return true;
                    }
                    ++var8_9;
                }
            }
        }
        String name = stack.m_41786_().getString();
        name = ChatFormatting.m_126649_((String)name.trim().toLowerCase(Locale.ROOT));
        StringMatcher matcher = String::contains;
        if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
            search = search.substring(1, search.length() - 1);
            matcher = String::equals;
        }
        if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
            search = search.substring(1, search.length() - 1);
            matcher = (s1, s2) -> Pattern.compile(s2).matcher((CharSequence)s1).find();
        }
        if (stack.m_41793_()) {
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            for (Enchantment enchantment : enchants.keySet()) {
                if (enchantment == null || !matcher.test(enchantment.m_44700_(((Integer)enchants.get(enchantment)).intValue()).toString().toLowerCase(Locale.ROOT), search)) continue;
                return true;
            }
        }
        ArrayList potionNames = new ArrayList();
        PotionUtils.m_43555_((ItemStack)stack, potionNames, (float)1.0f);
        for (Component component : potionNames) {
            if (!matcher.test(ChatFormatting.m_126649_((String)component.toString().trim().toLowerCase(Locale.ROOT)), search)) continue;
            return true;
        }
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            int lvl = (Integer)entry.getValue();
            Enchantment e = (Enchantment)entry.getKey();
            if (e == null || !matcher.test(e.m_44700_(lvl).toString().toLowerCase(Locale.ROOT), search)) continue;
            return true;
        }
        CreativeModeTab tab = item.m_41471_();
        if (tab != null && matcher.test(tab.m_40786_().getString().toLowerCase(Locale.ROOT), search)) {
            return true;
        }
        ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)item);
        Optional mod = ModList.get().getModContainerById(resourceLocation.m_135815_());
        if (mod.isPresent() && matcher.test(((ModContainer)mod.orElse(null)).getModInfo().getDisplayName().toLowerCase(Locale.ROOT), search)) {
            return true;
        }
        return matcher.test(name, search);
    }

    static {
        text = "";
        searchEnabled = false;
    }

    private static interface StringMatcher
    extends BiPredicate<String, String> {
    }
}

