/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.goal.WalkToRaiderGoal;
import com.mrbysco.raided.registry.RaidedRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;

public class Necromancer
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> HEALING = SynchedEntityData.m_135353_(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int healingTickCount;

    public Necromancer(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new WalkToRaiderGoal((Mob)this, 1.0, 4.0f, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALING, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.healingTickCount = tag.m_128451_("HealingTicks");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("HealingTicks", this.healingTickCount);
    }

    public boolean isHealing() {
        if (this.f_19853_.f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(HEALING);
        }
        return this.healingTickCount > 0;
    }

    public void setIsHealing(boolean value) {
        this.f_19804_.m_135381_(HEALING, (Object)value);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isHealing()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.healingTickCount > 0) {
            --this.healingTickCount;
        } else {
            this.setIsHealing(false);
        }
    }

    public boolean canHeal() {
        return this.healingTickCount == 0;
    }

    public void healMember(Raider raider) {
        float halfHealth = raider.m_21233_() / 2.0f;
        raider.m_5634_(halfHealth);
        this.m_6469_(DamageSource.f_19319_, (float)Math.ceil(halfHealth / 5.0f));
        this.setIsHealing(true);
        this.healingTickCount = 30;
    }

    public boolean m_7490_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return RaidedRegistry.NECROMANCER.getAmbient();
    }

    protected SoundEvent m_5592_() {
        return RaidedRegistry.NECROMANCER.getDeath();
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return RaidedRegistry.NECROMANCER.getHurt();
    }

    public SoundEvent m_7930_() {
        return RaidedRegistry.NECROMANCER.getCelebrate();
    }
}

