/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import fuzs.resourcepackoverrides.client.gui.screens.packs.PackAwareSelectionEntry;
import fuzs.resourcepackoverrides.mixin.client.accessor.AbstractSelectionListAccessor;
import fuzs.resourcepackoverrides.mixin.client.accessor.PackEntryAccessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class PackActionsHandler {
    private static final Int2ObjectMap<PackAction> PACK_ACTIONS = new Int2ObjectOpenHashMap();
    private static boolean debugTooltips;

    public static void onScreen$Render$Post(Screen screen, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (debugTooltips) {
            PackActionsHandler.getHoveredPackId(screen).map(Component::m_237113_).ifPresent(component -> screen.m_96602_(poseStack, (Component)component, mouseX, mouseY));
        }
    }

    private static Optional<String> getHoveredPackId(@Nullable Screen screen) {
        if (screen == null) {
            return Optional.empty();
        }
        for (GuiEventListener guiEventListener : screen.m_6702_()) {
            TransferableSelectionList.PackEntry entry;
            PackSelectionModel.Entry entry2;
            ObjectSelectionList selectionList;
            Object e;
            if (!(guiEventListener instanceof ObjectSelectionList) || !((e = ((AbstractSelectionListAccessor)(selectionList = (ObjectSelectionList)guiEventListener)).resourcepackoverrides$callGetHovered()) instanceof TransferableSelectionList.PackEntry) || !((entry2 = ((PackEntryAccessor)(entry = (TransferableSelectionList.PackEntry)e)).resourcepackoverrides$getPack()) instanceof PackAwareSelectionEntry)) continue;
            PackAwareSelectionEntry selectionEntry = (PackAwareSelectionEntry)entry2;
            return Optional.of(selectionEntry.getPackId().replace("\u00a7", "\\u00A7"));
        }
        return Optional.empty();
    }

    public static void onClientTick$End(Minecraft minecraft) {
        PACK_ACTIONS.values().forEach(action -> action.tick(minecraft));
    }

    public static void onKeyPressed$Post(Screen screen, int keyCode, int scanCode, int modifiers) {
        PackAction packAction = (PackAction)PACK_ACTIONS.get(keyCode);
        if (packAction != null) {
            packAction.update();
        }
    }

    static {
        PACK_ACTIONS.put(67, (Object)new PackAction((Component)Component.m_237115_((String)"packAction.copyId.title"), (Component)Component.m_237110_((String)"packAction.copyId.description", (Object[])new Object[]{Component.m_237113_((String)"C").m_130940_(ChatFormatting.BOLD)}), (Component)Component.m_237115_((String)"packAction.copyId.success")){

            @Override
            boolean execute(Minecraft minecraft) {
                Optional<String> hoveredPackId = PackActionsHandler.getHoveredPackId(minecraft.f_91080_);
                hoveredPackId.ifPresent(arg_0 -> ((KeyboardHandler)minecraft.f_91068_).m_90911_(arg_0));
                return hoveredPackId.isPresent();
            }
        });
        PACK_ACTIONS.put(68, (Object)new PackAction((Component)Component.m_237115_((String)"packAction.toggleDebug.title"), (Component)Component.m_237110_((String)"packAction.toggleDebug.description", (Object[])new Object[]{Component.m_237113_((String)"D").m_130940_(ChatFormatting.BOLD)}), (Component)Component.m_237115_((String)"packAction.toggleDebug.success")){

            @Override
            boolean execute(Minecraft minecraft) {
                debugTooltips = !debugTooltips;
                return true;
            }
        });
        PACK_ACTIONS.put(82, (Object)new PackAction((Component)Component.m_237115_((String)"packAction.reloadSettings.title"), (Component)Component.m_237110_((String)"packAction.reloadSettings.description", (Object[])new Object[]{Component.m_237113_((String)"R").m_130940_(ChatFormatting.BOLD)}), (Component)Component.m_237115_((String)"packAction.reloadSettings.success")){

            @Override
            boolean execute(Minecraft minecraft) {
                ResourceOverridesManager.load();
                if (minecraft.f_91080_ != null) {
                    minecraft.f_91080_.m_6575_(minecraft, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
                }
                return true;
            }
        });
    }

    private static abstract class PackAction {
        private final Component title;
        private final Component description;
        private final Component success;
        @Nullable
        private TutorialToast toast;
        @Nullable
        private TutorialToast successToast;
        private int successTicks;
        private int pressTime;
        private int lastPressTime;
        private int decreaseTimeDelay;
        private boolean wasExecuted;

        public PackAction(Component title, Component description, Component success) {
            this.title = title;
            this.description = description;
            this.success = success;
        }

        public void tick(Minecraft minecraft) {
            if (this.pressTime == this.lastPressTime && this.pressTime > 0 && --this.decreaseTimeDelay < 0) {
                if (this.wasExecuted) {
                    this.reset();
                } else {
                    --this.pressTime;
                }
            }
            this.lastPressTime = this.pressTime;
            if (this.pressTime > 0) {
                if (this.toast == null) {
                    this.toast = new TutorialToast(TutorialToast.Icons.MOVEMENT_KEYS, this.title, this.description, true);
                    minecraft.m_91300_().m_94922_((Toast)this.toast);
                }
                if (this.pressTime < 20) {
                    this.toast.m_94962_(Mth.m_14036_((float)((float)this.pressTime / 20.0f), (float)0.0f, (float)1.0f));
                } else if (!this.wasExecuted) {
                    if (this.execute(minecraft)) {
                        this.finish(minecraft);
                    }
                    this.wasExecuted = true;
                    this.toast.m_94962_(1.0f);
                }
            } else {
                this.reset();
            }
            if (this.successTicks > 0) {
                --this.successTicks;
                this.successToast.m_94962_((float)this.successTicks / 80.0f);
            } else if (this.successToast != null) {
                this.successToast.m_94968_();
                this.successToast = null;
            }
        }

        private void reset() {
            if (this.toast != null) {
                this.toast.m_94968_();
                this.toast = null;
            }
            this.lastPressTime = 0;
            this.pressTime = 0;
            this.wasExecuted = false;
        }

        abstract boolean execute(Minecraft var1);

        private void finish(Minecraft minecraft) {
            if (this.successToast != null) {
                this.successToast.m_94968_();
            }
            this.successToast = new TutorialToast(TutorialToast.Icons.MOVEMENT_KEYS, this.title, this.success, true);
            minecraft.m_91300_().m_94922_((Toast)this.successToast);
            this.successTicks = 80;
            this.successToast.m_94962_(1.0f);
        }

        public void update() {
            ++this.pressTime;
            this.resetDelay();
        }

        public void resetDelay() {
            this.decreaseTimeDelay = 10;
        }
    }
}

