/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.mixin.lightsource;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.thinkingstudio.ryoamiclights.DynamicLightSource;
import org.thinkingstudio.ryoamiclights.ExplosiveLightingMode;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandlers;

@Mixin(value={PrimedTnt.class})
public abstract class TntEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    private int startFuseTimer = 80;
    @Unique
    private int ryoamiclights$luminance;

    @Shadow
    public abstract int m_32100_();

    public TntEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="TAIL")})
    private void onNew(EntityType<? extends PrimedTnt> entityType, Level world, CallbackInfo ci) {
        this.startFuseTimer = this.m_32100_();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.m_9236_().m_5776_()) {
            if (!RyoamicLights.get().config.getTntLightingMode().isEnabled()) {
                return;
            }
            if (this.m_213877_()) {
                this.ryoamicLights$setDynamicLightEnabled(false);
            } else {
                if (!((Boolean)RyoamicLights.get().config.getEntitiesLightSource().get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
                    this.ryoamicLights$resetDynamicLight();
                } else {
                    this.ryoamicLights$dynamicLightTick();
                }
                RyoamicLights.updateTracking(this);
            }
        }
    }

    @Override
    public void ryoamicLights$dynamicLightTick() {
        if (this.m_6060_()) {
            this.ryoamiclights$luminance = 15;
        } else {
            ExplosiveLightingMode lightingMode = RyoamicLights.get().config.getTntLightingMode();
            if (lightingMode == ExplosiveLightingMode.FANCY) {
                int fuse = this.m_32100_() / this.startFuseTimer;
                this.ryoamiclights$luminance = (int)((double)(-(fuse * fuse)) * 10.0) + 10;
            } else {
                this.ryoamiclights$luminance = 10;
            }
        }
    }

    @Override
    public int ryoamicLights$getLuminance() {
        return this.ryoamiclights$luminance;
    }
}

