/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemLightSources {
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ObjectArrayList();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ObjectArrayList();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(ResourceManager resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.m_214159_("dynamiclights/item", path -> path.m_135815_().endsWith(".json")).forEach(ItemLightSources::load);
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(ResourceLocation resourceId, Resource resource) {
        ResourceLocation id = new ResourceLocation(resourceId.m_135827_(), resourceId.m_135815_().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.m_215507_());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.get().warn("Failed to load item light source \"" + String.valueOf(id) + "\".");
        }
    }

    private static void register(ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(ItemStack stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item() != stack.m_41720_()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.m_40614_().m_49966_());
        }
        return 0;
    }
}

