/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.slf4j.Logger;

public class ServerPinger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component CANT_CONNECT_MESSAGE = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130938_(style -> style.m_178520_(-65536));
    private final List<Connection> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final ServerData data, final Runnable runnable) throws UnknownHostException {
        ServerAddress serverAddress = ServerAddress.m_171864_((String)data.f_105363_);
        Optional<InetSocketAddress> optionalINet = ServerNameResolver.f_171881_.m_171890_(serverAddress).map(ResolvedServerAddress::m_142641_);
        if (!optionalINet.isPresent()) {
            this.onPingFailed(ConnectScreen.f_169260_, data);
        } else {
            InetSocketAddress socketAddress = optionalINet.get();
            final Connection connection = Connection.m_178300_((InetSocketAddress)socketAddress, (boolean)false);
            this.connections.add(connection);
            data.f_105365_ = Component.m_237115_((String)"multiplayer.status.pinging");
            data.f_105366_ = -1L;
            data.f_105370_ = Collections.emptyList();
            connection.m_129505_((PacketListener)new ClientStatusPacketListener(){
                private boolean success;
                private boolean receivedPing;
                private long pingStart;

                public void m_6440_(ClientboundStatusResponsePacket responsePacket) {
                    if (this.receivedPing) {
                        connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.unrequested"));
                    } else {
                        this.receivedPing = true;
                        ServerStatus serverstatus = responsePacket.m_134897_();
                        data.f_105365_ = serverstatus.m_134905_() != null ? serverstatus.m_134905_() : CommonComponents.f_237098_;
                        if (serverstatus.m_134915_() != null) {
                            data.f_105368_ = Component.m_237113_((String)serverstatus.m_134915_().m_134967_());
                            data.f_105367_ = serverstatus.m_134915_().m_134968_();
                        } else {
                            data.f_105368_ = Component.m_237115_((String)"multiplayer.status.old");
                            data.f_105367_ = 0;
                        }
                        if (serverstatus.m_134914_() != null) {
                            data.f_105364_ = ServerPinger.formatPlayerCount(serverstatus.m_134914_().m_134926_(), serverstatus.m_134914_().m_134923_());
                            ArrayList list = Lists.newArrayList();
                            GameProfile[] agameprofile = serverstatus.m_134914_().m_134927_();
                            if (agameprofile != null && agameprofile.length > 0) {
                                for (GameProfile gameprofile : agameprofile) {
                                    list.add(Component.m_237113_((String)gameprofile.getName()));
                                }
                                if (agameprofile.length < serverstatus.m_134914_().m_134926_()) {
                                    list.add(Component.m_237110_((String)"multiplayer.status.and_more", (Object[])new Object[]{serverstatus.m_134914_().m_134926_() - agameprofile.length}));
                                }
                                data.f_105370_ = list;
                            }
                        } else {
                            data.f_105364_ = Component.m_237115_((String)"multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                        }
                        String s = serverstatus.m_134916_();
                        if (s != null) {
                            try {
                                s = ServerData.m_233808_((String)s);
                            }
                            catch (ParseException parseexception) {
                                LOGGER.error("Invalid server icon", (Throwable)parseexception);
                            }
                        }
                        if (!Objects.equals(s, data.m_105388_())) {
                            data.m_105383_(s);
                            runnable.run();
                        }
                        this.pingStart = Util.m_137550_();
                        connection.m_129512_((Packet)new ServerboundPingRequestPacket(this.pingStart));
                        this.success = true;
                    }
                }

                public void m_7017_(ClientboundPongResponsePacket response) {
                    long start = this.pingStart;
                    long current = Util.m_137550_();
                    data.f_105366_ = current - start;
                    connection.m_129507_((Component)Component.m_237115_((String)"multiplayer.status.finished"));
                }

                public void m_7026_(Component message) {
                    if (!this.success) {
                        ServerPinger.this.onPingFailed(message, data);
                    }
                }

                public Connection m_6198_() {
                    return connection;
                }

                public boolean isAcceptingMessages() {
                    return connection.m_129536_();
                }
            });
            try {
                System.out.print("");
                connection.m_129512_((Packet)new ClientIntentionPacket(serverAddress.m_171863_(), serverAddress.m_171866_(), ConnectionProtocol.STATUS));
                connection.m_129512_((Packet)new ServerboundStatusRequestPacket());
            }
            catch (Throwable error) {
                LOGGER.error("Failed to ping server {}", (Object)data, (Object)error);
            }
        }
    }

    static Component formatPlayerCount(int $$0, int $$1) {
        return Component.m_237113_((String)Integer.toString($$0)).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(Integer.toString($$1)).m_130940_(ChatFormatting.GRAY);
    }

    public void onPingFailed(Component message, ServerData server) {
        LOGGER.error("Can't ping {}: {}", (Object)server.f_105363_, (Object)message.getString());
        server.f_105365_ = CANT_CONNECT_MESSAGE;
        server.f_105364_ = CommonComponents.f_237098_;
    }
}

