/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.RenderAPI;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.client.model.SnowVariantModel;

public final class SnowClient {
    public static final SnowBlockEntity.Options fallbackOptions = new SnowBlockEntity.Options();
    public static BakedModel cachedSnowModel;
    public static BakedModel cachedOverlayModel;
    public static final ResourceLocation OVERLAY_MODEL;
    public static final Map<ResourceLocation, ModelDefinition> snowVariantMapping;

    public static boolean shouldRedirect(BlockState state) {
        if (!(state.m_60734_() instanceof SnowVariant)) {
            return false;
        }
        if (!state.m_155947_()) {
            return false;
        }
        return !state.m_61138_((Property)SnowLayerBlock.f_56581_) || (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) != 8;
    }

    public static boolean renderHook(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState camo, SnowBlockEntity.Options options, @Nullable RenderType layer, Supplier<RandomSource> randomSupplier, boolean cullSides, RenderAPI api) {
        double yOffset;
        BakedModel model;
        Block block;
        if ((layer == null || layer == RenderType.m_110451_()) && (block = state.m_60734_()) instanceof WatcherSnowVariant) {
            WatcherSnowVariant watcher = (WatcherSnowVariant)block;
            watcher.updateOptions(state, (BlockGetter)world, pos, options);
        }
        boolean rendered = false;
        boolean useVariant = false;
        if (!camo.m_60795_() && camo.m_60799_() == RenderShape.MODEL) {
            BakedModel snowVariant;
            model = SnowClient.getBlockModel(camo);
            if (SnowClientConfig.snowVariants && model instanceof SnowVariantModel && (snowVariant = ((SnowVariantModel)model).getSnowVariant()) != null) {
                model = snowVariant;
                useVariant = true;
            }
            double yOffset2 = camo.m_204336_(CoreModule.OFFSET_Y) ? 0.101 : 0.0;
            rendered |= api.translateYAndRender(world, camo, pos, layer, randomSupplier, cullSides, model, yOffset2);
        }
        if (options.renderBottom && (layer == null || layer == RenderType.m_110451_())) {
            BlockState snow;
            BlockState blockState = snow = state.m_60734_() instanceof SnowVariant ? ((SnowVariant)state.m_60734_()).getSnowState(state, (BlockGetter)world, pos) : Blocks.f_50016_.m_49966_();
            if (!snow.m_60795_()) {
                if (snow == Blocks.f_50125_.m_49966_()) {
                    if (cachedSnowModel == null) {
                        cachedSnowModel = SnowClient.getBlockModel(snow);
                    }
                    model = cachedSnowModel;
                } else {
                    model = SnowClient.getBlockModel(snow);
                }
                yOffset = CoreModule.SLAB.is(state) ? 0.5 : 0.0;
                rendered |= api.translateYAndRender(world, snow, pos, layer, randomSupplier, cullSides, model, yOffset);
            }
        }
        if (!(!options.renderOverlay || layer != null && layer != RenderType.m_110457_() || useVariant && !CoreModule.TILE_BLOCK.is(state))) {
            BlockPos pos2 = pos;
            if (CoreModule.TILE_BLOCK.is(state) || CoreModule.SLAB.is(state)) {
                if (cachedOverlayModel == null) {
                    cachedOverlayModel = SnowClient.getBlockModel(OVERLAY_MODEL);
                }
                model = cachedOverlayModel;
                if (CoreModule.SLAB.is(state)) {
                    yOffset = -0.375;
                } else {
                    yOffset = -1.0;
                    pos2 = pos.m_7495_();
                }
            } else {
                yOffset = state.m_60734_() instanceof SnowVariant ? (double)((float)((SnowVariant)state.m_60734_()).getYOffset()) : 0.0;
                model = SnowClient.getBlockModel(state);
            }
            rendered |= api.translateYAndRender(world, state, pos2, layer, randomSupplier, cullSides, model, yOffset);
        }
        return rendered;
    }

    private static BakedModel getBlockModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    private static BakedModel getBlockModel(ResourceLocation location) {
        return Minecraft.m_91087_().m_91304_().getModel(location);
    }

    static {
        OVERLAY_MODEL = new ResourceLocation("snowrealmagic", "block/overlay");
        snowVariantMapping = Maps.newLinkedHashMap();
    }
}

