/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair;

import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CommonFactories;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import fuzs.puzzleslib.proxy.Proxy;
import fuzs.thinair.ThinAir;
import fuzs.thinair.advancements.ModAdvancementTriggers;
import fuzs.thinair.capability.AirBubblePositionsCapability;
import fuzs.thinair.capability.AirProtectionCapability;
import fuzs.thinair.config.CommonConfig;
import fuzs.thinair.data.ModAdvancementProvider;
import fuzs.thinair.data.ModBlockLootProvider;
import fuzs.thinair.data.ModBlockModels;
import fuzs.thinair.data.ModBlockTagsProvider;
import fuzs.thinair.data.ModChestLootProvider;
import fuzs.thinair.data.ModCraftingRecipes;
import fuzs.thinair.data.ModItemModels;
import fuzs.thinair.data.ModItemTagsProvider;
import fuzs.thinair.handler.AirBubbleTracker;
import fuzs.thinair.handler.DrownedOxygent;
import fuzs.thinair.handler.TickAirChecker;
import fuzs.thinair.init.ModRegistry;
import fuzs.thinair.integration.curios.CuriosIntegration;
import fuzs.thinair.world.level.block.SignalTorchBlock;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.util.Unit;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

@Mod(value="thinair")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThinAirForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        CommonFactories.INSTANCE.modConstructor("thinair").accept(new ThinAir());
        ModAdvancementTriggers.registerTriggers(CriteriaTriggers::m_10595_);
        ThinAirForge.registerCapabilities();
        ThinAirForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.AIR_PROTECTION_CAPABILITY, (CapabilityToken)new CapabilityToken<AirProtectionCapability>(){});
        ForgeCapabilityController.setCapabilityToken(ModRegistry.AIR_BUBBLE_POSITIONS_CAPABILITY, (CapabilityToken)new CapabilityToken<AirBubblePositionsCapability>(){});
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            Optional<Unit> result = SignalTorchBlock.switchTorchType(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getHitVec());
            result.ifPresent(unit -> evt.setUseItem(Event.Result.DENY));
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getLevel().m_5776_()) {
                return;
            }
            AirBubbleTracker.onChunkLoadServer(evt.getLevel(), evt.getChunk());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getLevel().m_5776_()) {
                return;
            }
            AirBubbleTracker.onWorldClose(Proxy.INSTANCE.getGameServer(), evt.getLevel());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase != TickEvent.Phase.END || evt.level.f_46443_) {
                return;
            }
            AirBubbleTracker.consumeReqdChunksServer(evt.level);
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> DrownedOxygent.onLivingHurt(evt.getEntity(), evt.getSource(), evt.getAmount()));
        MinecraftForge.EVENT_BUS.addListener(evt -> TickAirChecker.onLivingTick(evt.getEntity()));
        if (ModLoaderEnvironment.INSTANCE.isModLoaded("curios")) {
            CuriosIntegration.registerHandlers();
        }
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent evt) {
        if (ModLoaderEnvironment.INSTANCE.isModLoaded("curios")) {
            CuriosIntegration.sendInterModComms();
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModAdvancementProvider(dataGenerator, fileHelper));
        dataGenerator.m_236039_(evt.includeClient(), (DataProvider)new ModBlockModels(dataGenerator, "thinair", fileHelper));
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModBlockTagsProvider(dataGenerator, fileHelper));
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModBlockLootProvider(dataGenerator, "thinair"));
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModChestLootProvider(dataGenerator, "thinair"));
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModCraftingRecipes(dataGenerator));
        dataGenerator.m_236039_(evt.includeClient(), (DataProvider)new ModItemModels(dataGenerator, fileHelper));
        dataGenerator.m_236039_(evt.includeServer(), (DataProvider)new ModItemTagsProvider(evt, "thinair"));
    }
}

