/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.client;

import fuzs.puzzleslib.client.core.ClientFactories;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import fuzs.thinair.client.ThinAirClient;
import fuzs.thinair.client.handler.ClientAirBubbleTracker;
import fuzs.thinair.integration.curios.CuriosClientIntegration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="thinair", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ThinAirClientForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ClientFactories.INSTANCE.clientModConstructor("thinair").accept(new ThinAirClient());
        ThinAirClientForge.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (!evt.getLevel().m_5776_()) {
                return;
            }
            ClientAirBubbleTracker.onChunkLoadClient(evt.getLevel(), evt.getChunk());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (!evt.getLevel().m_5776_()) {
                return;
            }
            ClientAirBubbleTracker.onWorldClose(Minecraft.m_91087_(), evt.getLevel());
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            ClientAirBubbleTracker.consumeReqdChunksClient(Minecraft.m_91087_());
        });
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent evt) {
        if (ModLoaderEnvironment.INSTANCE.isModLoaded("curios")) {
            CuriosClientIntegration.registerCuriosRenderer();
        }
    }
}

