/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.client.handler;

import fuzs.thinair.capability.AirBubblePositionsCapability;
import fuzs.thinair.handler.AirBubbleTracker;
import fuzs.thinair.init.ModRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class ClientAirBubbleTracker {
    private static final Deque<ChunkPos> CLIENT_CHUNKS_TO_SCAN = new ArrayDeque<ChunkPos>();

    public static void onChunkLoadClient(LevelAccessor level, ChunkAccess chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        LevelChunk chunkFromSource = level.m_7726_().m_7131_(chunkpos.f_45578_, chunkpos.f_45579_);
        if (chunkFromSource != null) {
            CLIENT_CHUNKS_TO_SCAN.addLast(chunkpos);
        }
    }

    public static void consumeReqdChunksClient(Minecraft client) {
        if (!CLIENT_CHUNKS_TO_SCAN.isEmpty()) {
            Optional maybeCap;
            ChunkPos chunkpos = CLIENT_CHUNKS_TO_SCAN.removeFirst();
            LevelChunk chunk = client.f_91073_.m_7726_().m_7131_(chunkpos.f_45578_, chunkpos.f_45579_);
            if (chunk != null && (maybeCap = ModRegistry.AIR_BUBBLE_POSITIONS_CAPABILITY.maybeGet((Object)chunk)).isPresent()) {
                AirBubblePositionsCapability cap = (AirBubblePositionsCapability)maybeCap.get();
                if (cap.getSkipCountLeft() >= 0) {
                    AirBubbleTracker.recalcChunk(chunk, cap.getEntries());
                    chunk.m_8092_(true);
                    cap.setSkipCountLeft(8);
                } else {
                    cap.setSkipCountLeft(cap.getSkipCountLeft() - 1);
                }
            }
        }
    }

    public static void onWorldClose(Minecraft client, LevelAccessor level) {
        CLIENT_CHUNKS_TO_SCAN.clear();
    }
}

